/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import org.projectnessie.model.Content;
import org.projectnessie.model.UDF;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class UDFSerializer
extends BaseSerializer<UDF> {
    public Content.Type contentType() {
        return Content.Type.UDF;
    }

    public int payload() {
        return 5;
    }

    @Override
    protected void toStoreOnRefState(UDF udf, ObjectTypes.Content.Builder builder) {
        String signature;
        String version;
        String metadata;
        String sqlText;
        ObjectTypes.UDF.Builder stateBuilder = ObjectTypes.UDF.newBuilder();
        String dialect = udf.getDialect();
        if (dialect != null) {
            stateBuilder.setDialect(udf.getDialect());
        }
        if ((sqlText = udf.getSqlText()) != null) {
            stateBuilder.setSqlText(udf.getSqlText());
        }
        if ((metadata = udf.getMetadataLocation()) != null) {
            stateBuilder.setMetadataLocation(udf.getMetadataLocation());
        }
        if ((version = udf.getVersionId()) != null) {
            stateBuilder.setVersionId(version);
        }
        if ((signature = udf.getSignatureId()) != null) {
            stateBuilder.setSignatureId(signature);
        }
        builder.setUdf(stateBuilder);
    }

    @Override
    protected UDF valueFromStore(ObjectTypes.Content content) {
        return UDFSerializer.valueFromStoreUDF(content);
    }
}

