/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import java.util.function.Supplier;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableIcebergView;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.InvalidProtocolBufferException;
import org.projectnessie.server.store.proto.ObjectTypes;
import org.projectnessie.versioned.store.ContentSerializer;

abstract class BaseSerializer<C extends Content>
implements ContentSerializer<C> {
    BaseSerializer() {
    }

    public ByteString toStoreOnReferenceState(C content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        this.toStoreOnRefState(content, builder);
        return builder.build().toByteString();
    }

    public C valueFromStore(byte payload, ByteString onReferenceValue, Supplier<ByteString> globalState) {
        ObjectTypes.Content content = BaseSerializer.parse(onReferenceValue);
        return this.valueFromStore(content, globalState);
    }

    protected abstract C valueFromStore(ObjectTypes.Content var1, Supplier<ByteString> var2);

    static ImmutableDeltaLakeTable valueFromStoreDeltaLakeTable(ObjectTypes.Content content) {
        ObjectTypes.DeltaLakeTable deltaLakeTable = content.getDeltaLakeTable();
        ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().id(content.getId()).addAllMetadataLocationHistory((Iterable)deltaLakeTable.getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)deltaLakeTable.getCheckpointLocationHistoryList());
        if (deltaLakeTable.hasLastCheckpoint()) {
            builder.lastCheckpoint(content.getDeltaLakeTable().getLastCheckpoint());
        }
        return builder.build();
    }

    static ImmutableNamespace valueFromStoreNamespace(ObjectTypes.Content content) {
        ObjectTypes.Namespace namespace = content.getNamespace();
        return Namespace.builder().id(content.getId()).elements((Iterable)namespace.getElementsList()).putAllProperties(namespace.getPropertiesMap()).build();
    }

    static ImmutableIcebergTable valueFromStoreIcebergTable(ObjectTypes.Content content, Supplier<String> metadataPointerSupplier) {
        ObjectTypes.IcebergRefState table = content.getIcebergRefState();
        String metadataLocation = table.hasMetadataLocation() ? table.getMetadataLocation() : metadataPointerSupplier.get();
        ImmutableIcebergTable.Builder tableBuilder = IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(table.getSnapshotId()).schemaId(table.getSchemaId()).specId(table.getSpecId()).sortOrderId(table.getSortOrderId()).id(content.getId());
        return tableBuilder.build();
    }

    static ImmutableIcebergView valueFromStoreIcebergView(ObjectTypes.Content content, Supplier<String> metadataPointerSupplier) {
        ObjectTypes.IcebergViewState view = content.getIcebergViewState();
        String metadataLocation = view.hasMetadataLocation() ? view.getMetadataLocation() : metadataPointerSupplier.get();
        ImmutableIcebergView.Builder viewBuilder = IcebergView.builder().metadataLocation(metadataLocation).versionId(view.getVersionId()).schemaId(view.getSchemaId()).dialect(view.getDialect()).sqlText(view.getSqlText()).id(content.getId());
        return viewBuilder.build();
    }

    static IllegalArgumentException noIcebergMetadataPointer() {
        return new IllegalArgumentException("Iceberg content from reference must have global state, but has none");
    }

    protected abstract void toStoreOnRefState(C var1, ObjectTypes.Content.Builder var2);

    static ObjectTypes.Content parse(ByteString value) {
        try {
            return ObjectTypes.Content.parseFrom((ByteString)value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failure parsing data", e);
        }
    }

    static final class IcebergMetadataPointerSupplier
    implements Supplier<String> {
        private final Supplier<ByteString> globalState;

        IcebergMetadataPointerSupplier(Supplier<ByteString> globalState) {
            this.globalState = globalState;
        }

        @Override
        public String get() {
            ByteString global = this.globalState.get();
            if (global == null) {
                throw BaseSerializer.noIcebergMetadataPointer();
            }
            ObjectTypes.Content globalContent = BaseSerializer.parse(global);
            if (!globalContent.hasIcebergMetadataPointer()) {
                throw BaseSerializer.noIcebergMetadataPointer();
            }
            return globalContent.getIcebergMetadataPointer().getMetadataLocation();
        }
    }
}

