/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import java.util.function.Supplier;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class IcebergTableSerializer
extends BaseSerializer<IcebergTable> {
    public Content.Type contentType() {
        return Content.Type.ICEBERG_TABLE;
    }

    public int payload() {
        return 1;
    }

    @Override
    protected void toStoreOnRefState(IcebergTable table, ObjectTypes.Content.Builder builder) {
        ObjectTypes.IcebergRefState.Builder stateBuilder = ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(table.getSnapshotId()).setSchemaId(table.getSchemaId()).setSpecId(table.getSpecId()).setSortOrderId(table.getSortOrderId()).setMetadataLocation(table.getMetadataLocation());
        builder.setIcebergRefState(stateBuilder);
    }

    public boolean requiresGlobalState(ByteString content) {
        ObjectTypes.Content parsed = IcebergTableSerializer.parse(content);
        return !parsed.getIcebergRefState().hasMetadataLocation();
    }

    @Override
    protected IcebergTable valueFromStore(ObjectTypes.Content content, Supplier<ByteString> globalState) {
        return IcebergTableSerializer.valueFromStoreIcebergTable(content, new BaseSerializer.IcebergMetadataPointerSupplier(globalState));
    }
}

