/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import java.util.function.Supplier;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergView;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class IcebergViewSerializer
extends BaseSerializer<IcebergView> {
    public Content.Type contentType() {
        return Content.Type.ICEBERG_VIEW;
    }

    public int payload() {
        return 3;
    }

    @Override
    protected void toStoreOnRefState(IcebergView view, ObjectTypes.Content.Builder builder) {
        ObjectTypes.IcebergViewState.Builder stateBuilder = ObjectTypes.IcebergViewState.newBuilder().setVersionId(view.getVersionId()).setSchemaId(view.getSchemaId());
        String dialect = view.getDialect();
        String sqlText = view.getSqlText();
        String metadataLocation = view.getMetadataLocation();
        if (dialect != null) {
            stateBuilder.setDialect(dialect);
        }
        if (sqlText != null) {
            stateBuilder.setSqlText(sqlText);
        }
        if (metadataLocation != null) {
            stateBuilder.setMetadataLocation(metadataLocation);
        }
        builder.setIcebergViewState(stateBuilder);
    }

    public boolean requiresGlobalState(ByteString content) {
        ObjectTypes.Content parsed = IcebergViewSerializer.parse(content);
        return !parsed.getIcebergViewState().hasMetadataLocation();
    }

    @Override
    protected IcebergView valueFromStore(ObjectTypes.Content content, Supplier<ByteString> globalState) {
        return IcebergViewSerializer.valueFromStoreIcebergView(content, new BaseSerializer.IcebergMetadataPointerSupplier(globalState));
    }
}

