/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.model.ImmutableNessieConfiguration;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.types.GenericRepositoryConfig;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.ApiContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.VersionStore;

public class ConfigApiImpl
extends BaseApiImpl
implements ConfigService {
    public ConfigApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext, ApiContext apiContext) {
        super(config, store, authorizer, accessContext, apiContext);
    }

    @Override
    public NessieConfiguration getConfig() {
        RepositoryInformation info = this.getStore().getRepositoryInformation();
        String defaultBranch = info.getDefaultBranch();
        if (defaultBranch == null) {
            defaultBranch = this.getServerConfig().getDefaultBranch();
        }
        return ImmutableNessieConfiguration.builder().from(NessieConfiguration.getBuiltInConfig()).defaultBranch(defaultBranch).actualApiVersion(this.getApiContext().getApiVersion()).noAncestorHash(info.getNoAncestorHash()).repositoryCreationTimestamp(info.getRepositoryCreationTimestamp()).oldestPossibleCommitTimestamp(info.getOldestPossibleCommitTimestamp()).additionalProperties(info.getAdditionalProperties()).build();
    }

    @Override
    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        BatchAccessChecker check = this.startAccessCheck();
        repositoryConfigTypes.forEach(check::canReadRepositoryConfig);
        check.checkAndThrow();
        return this.getStore().getRepositoryConfig(repositoryConfigTypes);
    }

    @Override
    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) throws NessieConflictException {
        Preconditions.checkArgument((!(repositoryConfig instanceof GenericRepositoryConfig) ? 1 : 0) != 0, (String)"Repository config type bundle for '%s' is not available on the Nessie server side.", (Object)repositoryConfig.getType().name());
        this.startAccessCheck().canUpdateRepositoryConfig(repositoryConfig.getType()).checkAndThrow();
        try {
            return this.getStore().updateRepositoryConfig(repositoryConfig);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }
}

