/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import jakarta.annotation.Nullable;
import java.util.Set;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.services.authz.ImmutableCheck;
import org.projectnessie.versioned.NamedRef;

@Value.Immutable
public interface Check {
    @Value.Parameter(order=1)
    public CheckType type();

    @Nullable
    @Value.Parameter(order=2)
    public NamedRef ref();

    @Nullable
    @Value.Parameter(order=3)
    public ContentKey key();

    @Nullable
    @Value.Parameter(order=4)
    public String contentId();

    @Nullable
    @Value.Parameter(order=5)
    public Content.Type contentType();

    @Nullable
    @Value.Parameter(order=6)
    public IdentifiedContentKey identifiedKey();

    @Nullable
    @Value.Parameter(order=7)
    public RepositoryConfig.Type repositoryConfigType();

    @Value.Parameter(order=8)
    public Set<String> actions();

    public static Check check(CheckType type) {
        return ImmutableCheck.of(type, null, null, null, null, null, null, Set.of());
    }

    public static Check check(CheckType type, RepositoryConfig.Type repositoryConfigType) {
        return ImmutableCheck.of(type, null, null, null, null, null, repositoryConfigType, Set.of());
    }

    public static Check check(CheckType type, NamedRef ref) {
        return ImmutableCheck.of(type, ref, null, null, null, null, null, Set.of());
    }

    public static Check check(CheckType type, NamedRef ref, ContentKey key) {
        return Check.check(type, ref, key, Set.of());
    }

    public static Check check(CheckType type, NamedRef ref, ContentKey key, Set<String> actions) {
        return ImmutableCheck.of(type, ref, key, null, null, null, null, actions);
    }

    public static Check check(CheckType type, NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(type, ref, identifiedKey, Set.of());
    }

    public static Check check(CheckType type, NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        if (identifiedKey != null) {
            IdentifiedContentKey.IdentifiedElement element = identifiedKey.lastElement();
            return ImmutableCheck.of(type, ref, identifiedKey.contentKey(), element.contentId(), identifiedKey.type(), identifiedKey, null, actions);
        }
        return ImmutableCheck.of(type, ref, null, null, null, null, null, actions);
    }

    public static ImmutableCheck.Builder builder(CheckType type) {
        return ImmutableCheck.builder().type(type);
    }

    public static Check canViewReference(NamedRef ref) {
        return Check.check(CheckType.VIEW_REFERENCE, ref);
    }

    public static Check canCreateReference(NamedRef ref) {
        return Check.check(CheckType.CREATE_REFERENCE, ref);
    }

    public static Check canAssignRefToHash(NamedRef ref) {
        return Check.check(CheckType.ASSIGN_REFERENCE_TO_HASH, ref);
    }

    public static Check canDeleteReference(NamedRef ref) {
        return Check.check(CheckType.DELETE_REFERENCE, ref);
    }

    public static Check canReadEntries(NamedRef ref) {
        return Check.check(CheckType.READ_ENTRIES, ref);
    }

    public static Check canReadContentKey(NamedRef ref, ContentKey key) {
        return Check.check(CheckType.READ_CONTENT_KEY, ref, key);
    }

    public static Check canReadContentKey(NamedRef ref, ContentKey key, Set<String> actions) {
        return Check.check(CheckType.READ_CONTENT_KEY, ref, key, actions);
    }

    public static Check canReadContentKey(NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(CheckType.READ_CONTENT_KEY, ref, identifiedKey);
    }

    public static Check canReadContentKey(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        return Check.check(CheckType.READ_CONTENT_KEY, ref, identifiedKey, actions);
    }

    public static Check canListCommitLog(NamedRef ref) {
        return Check.check(CheckType.LIST_COMMIT_LOG, ref);
    }

    public static Check canCommitChangeAgainstReference(NamedRef ref) {
        return Check.check(CheckType.COMMIT_CHANGE_AGAINST_REFERENCE, ref);
    }

    public static Check canReadEntityValue(NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(CheckType.READ_ENTITY_VALUE, ref, identifiedKey);
    }

    public static Check canReadEntityValue(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        return Check.check(CheckType.READ_ENTITY_VALUE, ref, identifiedKey, actions);
    }

    public static Check canCreateEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(CheckType.CREATE_ENTITY, ref, identifiedKey);
    }

    public static Check canCreateEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        return Check.check(CheckType.CREATE_ENTITY, ref, identifiedKey, actions);
    }

    public static Check canUpdateEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(CheckType.UPDATE_ENTITY, ref, identifiedKey);
    }

    public static Check canUpdateEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        return Check.check(CheckType.UPDATE_ENTITY, ref, identifiedKey, actions);
    }

    public static Check canDeleteEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        return Check.check(CheckType.DELETE_ENTITY, ref, identifiedKey);
    }

    public static Check canDeleteEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        return Check.check(CheckType.DELETE_ENTITY, ref, identifiedKey, actions);
    }

    public static Check canReadRepositoryConfig(RepositoryConfig.Type repositoryConfigType) {
        return Check.check(CheckType.READ_REPOSITORY_CONFIG, repositoryConfigType);
    }

    public static Check canUpdateRepositoryConfig(RepositoryConfig.Type repositoryConfigType) {
        return Check.check(CheckType.UPDATE_REPOSITORY_CONFIG, repositoryConfigType);
    }

    public static enum CheckType {
        VIEW_REFERENCE(true, false, false),
        CREATE_REFERENCE(true, false, false),
        ASSIGN_REFERENCE_TO_HASH(true, false, false),
        DELETE_REFERENCE(true, false, false),
        READ_ENTRIES(true, false, false),
        READ_CONTENT_KEY(true, true, false),
        LIST_COMMIT_LOG(true, false, false),
        COMMIT_CHANGE_AGAINST_REFERENCE(true, false, false),
        READ_ENTITY_VALUE(true, true, false),
        CREATE_ENTITY(true, true, false),
        UPDATE_ENTITY(true, true, false),
        DELETE_ENTITY(true, true, false),
        READ_REPOSITORY_CONFIG(false, false, true),
        UPDATE_REPOSITORY_CONFIG(false, false, true);

        private final boolean ref;
        private final boolean content;
        private final boolean repositoryConfigType;

        private CheckType(boolean ref, boolean content, boolean repositoryConfigType) {
            this.ref = ref;
            this.content = content;
            this.repositoryConfigType = repositoryConfigType;
        }

        public boolean isRef() {
            return this.ref;
        }

        public boolean isContent() {
            return this.content;
        }

        public boolean isRepositoryConfigType() {
            return this.repositoryConfigType;
        }
    }
}

