/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.services.authz.ApiContext;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.NamedRef;

public abstract class AbstractBatchAccessChecker
implements BatchAccessChecker {
    public static final BatchAccessChecker NOOP_ACCESS_CHECKER = new AbstractBatchAccessChecker(ApiContext.apiContext("<unknown>", 0)){

        @Override
        public Map<Check, String> check() {
            return Collections.emptyMap();
        }

        @Override
        public BatchAccessChecker can(Check check) {
            return this;
        }
    };
    private final ApiContext apiContext;
    private final Collection<Check> checks = new LinkedHashSet<Check>();

    protected AbstractBatchAccessChecker(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    @Override
    public ApiContext getApiContext() {
        return this.apiContext;
    }

    protected Collection<Check> getChecks() {
        return this.checks;
    }

    @Override
    public BatchAccessChecker can(Check check) {
        this.checks.add(check);
        return this;
    }

    @Override
    public BatchAccessChecker canViewReference(NamedRef ref) {
        return this.can(Check.canViewReference(ref));
    }

    @Override
    public BatchAccessChecker canCreateReference(NamedRef ref) {
        return this.can(Check.canCreateReference(ref));
    }

    @Override
    public BatchAccessChecker canAssignRefToHash(NamedRef ref) {
        this.canViewReference(ref);
        return this.can(Check.canAssignRefToHash(ref));
    }

    @Override
    public BatchAccessChecker canDeleteReference(NamedRef ref) {
        this.canViewReference(ref);
        return this.can(Check.canDeleteReference(ref));
    }

    @Override
    public BatchAccessChecker canReadEntries(NamedRef ref) {
        this.canViewReference(ref);
        return this.can(Check.canReadEntries(ref));
    }

    @Override
    public BatchAccessChecker canReadContentKey(NamedRef ref, IdentifiedContentKey identifiedKey) {
        this.canViewReference(ref);
        return this.can(Check.canReadContentKey(ref, identifiedKey));
    }

    @Override
    public BatchAccessChecker canReadContentKey(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        this.canViewReference(ref);
        return this.can(Check.canReadContentKey(ref, identifiedKey, actions));
    }

    @Override
    public BatchAccessChecker canListCommitLog(NamedRef ref) {
        this.canViewReference(ref);
        return this.can(Check.canListCommitLog(ref));
    }

    @Override
    public BatchAccessChecker canCommitChangeAgainstReference(NamedRef ref) {
        this.canViewReference(ref);
        return this.can(Check.canCommitChangeAgainstReference(ref));
    }

    @Override
    public BatchAccessChecker canReadEntityValue(NamedRef ref, IdentifiedContentKey identifiedKey) {
        this.canViewReference(ref);
        return this.can(Check.canReadEntityValue(ref, identifiedKey));
    }

    @Override
    public BatchAccessChecker canReadEntityValue(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        this.canViewReference(ref);
        return this.can(Check.canReadEntityValue(ref, identifiedKey, actions));
    }

    @Override
    @Deprecated
    public BatchAccessChecker canCreateEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        this.canViewReference(ref);
        return this.can(Check.canCreateEntity(ref, identifiedKey));
    }

    @Override
    @Deprecated
    public BatchAccessChecker canCreateEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        this.canViewReference(ref);
        return this.can(Check.canCreateEntity(ref, identifiedKey, actions));
    }

    @Override
    @Deprecated
    public BatchAccessChecker canUpdateEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        this.canViewReference(ref);
        return this.can(Check.canUpdateEntity(ref, identifiedKey));
    }

    @Override
    @Deprecated
    public BatchAccessChecker canUpdateEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        this.canViewReference(ref);
        return this.can(Check.canUpdateEntity(ref, identifiedKey, actions));
    }

    @Override
    public BatchAccessChecker canDeleteEntity(NamedRef ref, IdentifiedContentKey identifiedKey) {
        this.canViewReference(ref);
        return this.can(Check.canDeleteEntity(ref, identifiedKey));
    }

    @Override
    public BatchAccessChecker canDeleteEntity(NamedRef ref, IdentifiedContentKey identifiedKey, Set<String> actions) {
        this.canViewReference(ref);
        return this.can(Check.canDeleteEntity(ref, identifiedKey, actions));
    }

    @Override
    public BatchAccessChecker canReadRepositoryConfig(RepositoryConfig.Type repositoryConfigType) {
        return this.can(Check.canReadRepositoryConfig(repositoryConfigType));
    }

    @Override
    public BatchAccessChecker canUpdateRepositoryConfig(RepositoryConfig.Type repositoryConfigType) {
        return this.can(Check.canUpdateRepositoryConfig(repositoryConfigType));
    }
}

