/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.spi;

import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceHistoryResponse;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RequestMeta;
import org.projectnessie.versioned.WithHash;

public interface TreeService {
    public static final int MAX_COMMIT_LOG_ENTRIES = 250;

    public Branch getDefaultBranch() throws NessieNotFoundException;

    public <R> R getAllReferences(FetchOption var1, @Nullable String var2, String var3, PagedResponseHandler<R, Reference> var4);

    public Reference getReferenceByName(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, FetchOption var2) throws NessieNotFoundException;

    public ReferenceHistoryResponse getReferenceHistory(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, Integer var2) throws NessieNotFoundException;

    public Reference createReference(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, Reference.ReferenceType var2, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var3, @Valid @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var4) throws NessieNotFoundException, NessieConflictException;

    public Reference assignReference(Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var2, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var3, @Valid Reference var4) throws NessieNotFoundException, NessieConflictException;

    public Reference deleteReference(Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var2, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var3) throws NessieConflictException, NessieNotFoundException;

    public <R> R getCommitLog(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, FetchOption var2, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var3, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var4, @Nullable String var5, @Nullable String var6, @NotNull PagedResponseHandler<R, LogResponse.LogEntry> var7) throws NessieNotFoundException;

    public MergeResponse transplantCommitsIntoBranch(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var2, @Nullable CommitMeta var3, List<@Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String> var4, @Valid @NotBlank @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotBlank @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var5, Collection<MergeKeyBehavior> var6, MergeBehavior var7, @Nullable Boolean var8, @Nullable Boolean var9, @Nullable Boolean var10) throws NessieNotFoundException, NessieConflictException;

    public MergeResponse mergeRefIntoBranch(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var2, @Valid @NotBlank @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotBlank @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var3, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var4, @Nullable CommitMeta var5, Collection<MergeKeyBehavior> var6, MergeBehavior var7, @Nullable Boolean var8, @Nullable Boolean var9, @Nullable Boolean var10) throws NessieNotFoundException, NessieConflictException;

    public <R> R getEntries(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @Nullable @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var2, @Nullable Integer var3, @Nullable String var4, @Nullable String var5, boolean var6, PagedResponseHandler<R, EntriesResponse.Entry> var7, Consumer<WithHash<NamedRef>> var8, @Nullable ContentKey var9, @Nullable ContentKey var10, ContentKey var11, List<ContentKey> var12) throws NessieNotFoundException;

    public CommitResponse commitMultipleOperations(@Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Valid @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String var2, @Valid Operations var3, @NotNull RequestMeta var4) throws NessieNotFoundException, NessieConflictException;
}

