/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.ApiContext;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;

public final class RetriableAccessChecker {
    private final Supplier<BatchAccessChecker> validator;
    private final ApiContext apiContext;
    private Collection<Check> validatedChecks;
    private Map<Check, String> result;

    public RetriableAccessChecker(Supplier<BatchAccessChecker> validator, ApiContext apiContext) {
        Preconditions.checkNotNull(validator);
        this.validator = validator;
        this.apiContext = apiContext;
    }

    public BatchAccessChecker newAttempt() {
        return new Attempt(this.apiContext);
    }

    private class Attempt
    extends AbstractBatchAccessChecker {
        private final ApiContext apiContext;

        Attempt(ApiContext apiContext) {
            super(apiContext);
            this.apiContext = apiContext;
        }

        @Override
        public ApiContext getApiContext() {
            return this.apiContext;
        }

        @Override
        public Map<Check, String> check() {
            ArrayList<Check> currentChecks = new ArrayList<Check>(this.getChecks());
            if (RetriableAccessChecker.this.validatedChecks != null && RetriableAccessChecker.this.result != null && RetriableAccessChecker.this.validatedChecks.equals(currentChecks)) {
                return RetriableAccessChecker.this.result;
            }
            BatchAccessChecker checker = RetriableAccessChecker.this.validator.get();
            currentChecks.forEach(checker::can);
            RetriableAccessChecker.this.result = checker.check();
            RetriableAccessChecker.this.validatedChecks = currentChecks;
            return RetriableAccessChecker.this.result;
        }
    }
}

