/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.hash;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.projectnessie.services.hash.ResolvedHash;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;

@Generated(from="ResolvedHash", generator="Immutables")
public final class ImmutableResolvedHash
implements ResolvedHash {
    private final NamedRef namedRef;
    private final Hash head;
    private final Hash hash;

    private ImmutableResolvedHash(NamedRef namedRef, Hash head, Hash hash) {
        this.namedRef = namedRef;
        this.head = head;
        this.hash = hash;
    }

    @Override
    public NamedRef getNamedRef() {
        return this.namedRef;
    }

    @Override
    public Optional<Hash> getHead() {
        return Optional.ofNullable(this.head);
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    public final ImmutableResolvedHash withNamedRef(NamedRef value) {
        if (this.namedRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "namedRef");
        return new ImmutableResolvedHash(newValue, this.head, this.hash);
    }

    public final ImmutableResolvedHash withHead(Hash value) {
        Hash newValue = Objects.requireNonNull(value, "head");
        if (this.head == newValue) {
            return this;
        }
        return new ImmutableResolvedHash(this.namedRef, newValue, this.hash);
    }

    public final ImmutableResolvedHash withHead(Optional<? extends Hash> optional) {
        Hash value = optional.orElse(null);
        if (this.head == value) {
            return this;
        }
        return new ImmutableResolvedHash(this.namedRef, value, this.hash);
    }

    public final ImmutableResolvedHash withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableResolvedHash(this.namedRef, this.head, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResolvedHash && this.equalTo(0, (ImmutableResolvedHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableResolvedHash another) {
        return this.namedRef.equals((Object)another.namedRef) && Objects.equals(this.head, another.head) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namedRef.hashCode();
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResolvedHash").omitNullValues().add("namedRef", (Object)this.namedRef).add("head", (Object)this.head).add("hash", (Object)this.hash).toString();
    }

    public static ImmutableResolvedHash copyOf(ResolvedHash instance) {
        if (instance instanceof ImmutableResolvedHash) {
            return (ImmutableResolvedHash)instance;
        }
        return ImmutableResolvedHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ResolvedHash", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAMED_REF = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private long initBits = 3L;
        private NamedRef namedRef;
        private Hash head;
        private Hash hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ResolvedHash instance) {
            Objects.requireNonNull(instance, "instance");
            this.namedRef(instance.getNamedRef());
            Optional<Hash> headOptional = instance.getHead();
            if (headOptional.isPresent()) {
                this.head(headOptional);
            }
            this.hash(instance.getHash());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namedRef(NamedRef namedRef) {
            this.namedRef = Objects.requireNonNull(namedRef, "namedRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder head(Hash head) {
            this.head = Objects.requireNonNull(head, "head");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder head(Optional<? extends Hash> head) {
            this.head = head.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableResolvedHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResolvedHash(this.namedRef, this.head, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namedRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build ResolvedHash, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

