/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.ApiContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.hash.HashValidator;
import org.projectnessie.services.hash.ResolvedHash;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RequestMeta;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class ContentApiImpl
extends BaseApiImpl
implements ContentService {
    public ContentApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext, ApiContext apiContext) {
        super(config, store, authorizer, accessContext, apiContext);
    }

    @Override
    public ContentResponse getContent(ContentKey key, String namedRef, String hashOnRef, boolean withDocumentation, RequestMeta requestMeta) throws NessieNotFoundException {
        try {
            ResolvedHash ref = this.getHashResolver().resolveHashOnRef(namedRef, hashOnRef, new HashValidator("Expected hash"));
            boolean forWrite = requestMeta.forWrite();
            ContentResult obj = this.getStore().getValue((Ref)ref.getHash(), key, forWrite);
            BatchAccessChecker accessCheck = this.startAccessCheck();
            NamedRef r = ref.getValue();
            accessCheck.canViewReference(r);
            if (forWrite) {
                accessCheck.canCommitChangeAgainstReference(r);
            }
            Set actions = requestMeta.keyActions(key);
            if (obj != null && obj.content() != null) {
                accessCheck.canReadEntityValue(r, obj.identifiedKey(), actions);
                if (forWrite) {
                    accessCheck.canUpdateEntity(r, obj.identifiedKey(), actions);
                }
                accessCheck.checkAndThrow();
                return ContentResponse.of((Content)obj.content(), (Reference)ContentApiImpl.makeReference(ref), null);
            }
            if (forWrite) {
                accessCheck.canReadEntityValue(r, Objects.requireNonNull(obj, "obj is null").identifiedKey(), actions).canCreateEntity(r, obj.identifiedKey(), actions);
            }
            accessCheck.checkAndThrow();
            throw new NessieContentNotFoundException(key, namedRef);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public GetMultipleContentsResponse getMultipleContents(String namedRef, String hashOnRef, List<ContentKey> keys, boolean withDocumentation, RequestMeta requestMeta) throws NessieNotFoundException {
        try {
            ResolvedHash ref = this.getHashResolver().resolveHashOnRef(namedRef, hashOnRef, new HashValidator("Expected hash"));
            NamedRef r = ref.getValue();
            BatchAccessChecker check = this.startAccessCheck().canViewReference(r);
            boolean forWrite = requestMeta.forWrite();
            if (forWrite) {
                check.canCommitChangeAgainstReference(r);
            }
            Map values = this.getStore().getValues((Ref)ref.getHash(), keys, forWrite);
            List output = values.entrySet().stream().filter(e -> {
                ContentResult contentResult = (ContentResult)e.getValue();
                IdentifiedContentKey identifiedKey = contentResult.identifiedKey();
                Set actions = requestMeta.keyActions(identifiedKey.contentKey());
                check.canReadEntityValue(r, identifiedKey, actions);
                if (contentResult.content() != null) {
                    if (forWrite) {
                        check.canUpdateEntity(r, identifiedKey, actions);
                    }
                    return true;
                }
                if (forWrite) {
                    check.canCreateEntity(r, identifiedKey, actions);
                }
                return false;
            }).map(e -> {
                ContentResult contentResult = (ContentResult)e.getValue();
                return GetMultipleContentsResponse.ContentWithKey.of((ContentKey)((ContentKey)e.getKey()), (Content)contentResult.content(), (Documentation)contentResult.documentation());
            }).collect(Collectors.toList());
            check.checkAndThrow();
            return GetMultipleContentsResponse.of(output, (Reference)ContentApiImpl.makeReference(ref));
        }
        catch (ReferenceNotFoundException ex) {
            throw new NessieReferenceNotFoundException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static Reference makeReference(WithHash<NamedRef> refWithHash) {
        NamedRef ref = (NamedRef)refWithHash.getValue();
        if (ref instanceof TagName) {
            return Tag.of((String)ref.getName(), (String)refWithHash.getHash().asString());
        }
        if (ref instanceof BranchName) {
            return Branch.of((String)ref.getName(), (String)refWithHash.getHash().asString());
        }
        if (ref instanceof DetachedRef) {
            return Detached.of((String)refWithHash.getHash().asString());
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }
}

