/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.services.authz.ApiContext;

@Generated(from="ApiContext", generator="Immutables")
public final class ImmutableApiContext
implements ApiContext {
    private final String apiName;
    private final int apiVersion;

    private ImmutableApiContext(String apiName, int apiVersion) {
        this.apiName = Objects.requireNonNull(apiName, "apiName");
        this.apiVersion = apiVersion;
    }

    private ImmutableApiContext(ImmutableApiContext original, String apiName, int apiVersion) {
        this.apiName = apiName;
        this.apiVersion = apiVersion;
    }

    @Override
    public String getApiName() {
        return this.apiName;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    public final ImmutableApiContext withApiName(String value) {
        String newValue = Objects.requireNonNull(value, "apiName");
        if (this.apiName.equals(newValue)) {
            return this;
        }
        return new ImmutableApiContext(this, newValue, this.apiVersion);
    }

    public final ImmutableApiContext withApiVersion(int value) {
        if (this.apiVersion == value) {
            return this;
        }
        return new ImmutableApiContext(this, this.apiName, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApiContext && this.equalsByValue((ImmutableApiContext)another);
    }

    private boolean equalsByValue(ImmutableApiContext another) {
        return this.apiName.equals(another.apiName) && this.apiVersion == another.apiVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiName.hashCode();
        h += (h << 5) + this.apiVersion;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApiContext").omitNullValues().add("apiName", (Object)this.apiName).add("apiVersion", this.apiVersion).toString();
    }

    public static ImmutableApiContext of(String apiName, int apiVersion) {
        return new ImmutableApiContext(apiName, apiVersion);
    }

    public static ImmutableApiContext copyOf(ApiContext instance) {
        if (instance instanceof ImmutableApiContext) {
            return (ImmutableApiContext)instance;
        }
        return ImmutableApiContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApiContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_API_NAME = 1L;
        private static final long INIT_BIT_API_VERSION = 2L;
        private long initBits = 3L;
        private String apiName;
        private int apiVersion;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ApiContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiName(instance.getApiName());
            this.apiVersion(instance.getApiVersion());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiName(String apiName) {
            this.apiName = Objects.requireNonNull(apiName, "apiName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(int apiVersion) {
            this.apiVersion = apiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableApiContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApiContext(null, this.apiName, this.apiVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiVersion");
            }
            return "Cannot build ApiContext, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

