/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.NamedRef;

@Generated(from="Check", generator="Immutables")
public final class ImmutableCheck
implements Check {
    private final Check.CheckType type;
    @Nullable
    private final NamedRef ref;
    @Nullable
    private final ContentKey key;
    @Nullable
    private final String contentId;
    @Nullable
    private final Content.Type contentType;
    @Nullable
    private final IdentifiedContentKey identifiedKey;
    @Nullable
    private final RepositoryConfig.Type repositoryConfigType;
    private final ImmutableSet<String> actions;

    private ImmutableCheck(Check.CheckType type, @Nullable NamedRef ref, @Nullable ContentKey key, @Nullable String contentId, @Nullable Content.Type contentType, @Nullable IdentifiedContentKey identifiedKey, @Nullable RepositoryConfig.Type repositoryConfigType, Iterable<String> actions) {
        this.type = Objects.requireNonNull(type, "type");
        this.ref = ref;
        this.key = key;
        this.contentId = contentId;
        this.contentType = contentType;
        this.identifiedKey = identifiedKey;
        this.repositoryConfigType = repositoryConfigType;
        this.actions = ImmutableSet.copyOf(actions);
    }

    private ImmutableCheck(ImmutableCheck original, Check.CheckType type, @Nullable NamedRef ref, @Nullable ContentKey key, @Nullable String contentId, @Nullable Content.Type contentType, @Nullable IdentifiedContentKey identifiedKey, @Nullable RepositoryConfig.Type repositoryConfigType, ImmutableSet<String> actions) {
        this.type = type;
        this.ref = ref;
        this.key = key;
        this.contentId = contentId;
        this.contentType = contentType;
        this.identifiedKey = identifiedKey;
        this.repositoryConfigType = repositoryConfigType;
        this.actions = actions;
    }

    @Override
    public Check.CheckType type() {
        return this.type;
    }

    @Override
    @Nullable
    public NamedRef ref() {
        return this.ref;
    }

    @Override
    @Nullable
    public ContentKey key() {
        return this.key;
    }

    @Override
    @Nullable
    public String contentId() {
        return this.contentId;
    }

    @Override
    @Nullable
    public Content.Type contentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public IdentifiedContentKey identifiedKey() {
        return this.identifiedKey;
    }

    @Override
    @Nullable
    public RepositoryConfig.Type repositoryConfigType() {
        return this.repositoryConfigType;
    }

    public ImmutableSet<String> actions() {
        return this.actions;
    }

    public final ImmutableCheck withType(Check.CheckType value) {
        Check.CheckType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableCheck(this, newValue, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withRef(@Nullable NamedRef value) {
        if (this.ref == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, value, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withKey(@Nullable ContentKey value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, value, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withContentId(@Nullable String value) {
        if (Objects.equals(this.contentId, value)) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, value, this.contentType, this.identifiedKey, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withContentType(@Nullable Content.Type value) {
        if (this.contentType == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, value, this.identifiedKey, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withIdentifiedKey(@Nullable IdentifiedContentKey value) {
        if (this.identifiedKey == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, value, this.repositoryConfigType, this.actions);
    }

    public final ImmutableCheck withRepositoryConfigType(@Nullable RepositoryConfig.Type value) {
        if (this.repositoryConfigType == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, value, this.actions);
    }

    public final ImmutableCheck withActions(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, (ImmutableSet<String>)newValue);
    }

    public final ImmutableCheck withActions(Iterable<String> elements) {
        if (this.actions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, (ImmutableSet<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalsByValue((ImmutableCheck)another);
    }

    private boolean equalsByValue(ImmutableCheck another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.ref, another.ref) && Objects.equals(this.key, another.key) && Objects.equals(this.contentId, another.contentId) && Objects.equals(this.contentType, another.contentType) && Objects.equals(this.identifiedKey, another.identifiedKey) && Objects.equals(this.repositoryConfigType, another.repositoryConfigType) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.contentId);
        h += (h << 5) + Objects.hashCode(this.contentType);
        h += (h << 5) + Objects.hashCode(this.identifiedKey);
        h += (h << 5) + Objects.hashCode(this.repositoryConfigType);
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("type", (Object)this.type).add("ref", (Object)this.ref).add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("contentType", (Object)this.contentType).add("identifiedKey", (Object)this.identifiedKey).add("repositoryConfigType", (Object)this.repositoryConfigType).add("actions", this.actions).toString();
    }

    public static ImmutableCheck of(Check.CheckType type, @Nullable NamedRef ref, @Nullable ContentKey key, @Nullable String contentId, @Nullable Content.Type contentType, @Nullable IdentifiedContentKey identifiedKey, @Nullable RepositoryConfig.Type repositoryConfigType, Set<String> actions) {
        return ImmutableCheck.of(type, ref, key, contentId, contentType, identifiedKey, repositoryConfigType, actions);
    }

    public static ImmutableCheck of(Check.CheckType type, @Nullable NamedRef ref, @Nullable ContentKey key, @Nullable String contentId, @Nullable Content.Type contentType, @Nullable IdentifiedContentKey identifiedKey, @Nullable RepositoryConfig.Type repositoryConfigType, Iterable<String> actions) {
        return new ImmutableCheck(type, ref, key, contentId, contentType, identifiedKey, repositoryConfigType, actions);
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Check", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private Check.CheckType type;
        private NamedRef ref;
        private ContentKey key;
        private String contentId;
        private Content.Type contentType;
        private IdentifiedContentKey identifiedKey;
        private RepositoryConfig.Type repositoryConfigType;
        private ImmutableSet.Builder<String> actions = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Check instance) {
            RepositoryConfig.Type repositoryConfigTypeValue;
            IdentifiedContentKey identifiedKeyValue;
            Content.Type contentTypeValue;
            String contentIdValue;
            ContentKey keyValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            NamedRef refValue = instance.ref();
            if (refValue != null) {
                this.ref(refValue);
            }
            if ((keyValue = instance.key()) != null) {
                this.key(keyValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            if ((contentTypeValue = instance.contentType()) != null) {
                this.contentType(contentTypeValue);
            }
            if ((identifiedKeyValue = instance.identifiedKey()) != null) {
                this.identifiedKey(identifiedKeyValue);
            }
            if ((repositoryConfigTypeValue = instance.repositoryConfigType()) != null) {
                this.repositoryConfigType(repositoryConfigTypeValue);
            }
            this.addAllActions(instance.actions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Check.CheckType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable NamedRef ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(@Nullable ContentKey key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@Nullable String contentId) {
            this.contentId = contentId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(@Nullable Content.Type contentType) {
            this.contentType = contentType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifiedKey(@Nullable IdentifiedContentKey identifiedKey) {
            this.identifiedKey = identifiedKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryConfigType(@Nullable RepositoryConfig.Type repositoryConfigType) {
            this.repositoryConfigType = repositoryConfigType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(String element) {
            this.actions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(String ... elements) {
            this.actions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Iterable<String> elements) {
            this.actions = ImmutableSet.builder();
            return this.addAllActions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllActions(Iterable<String> elements) {
            this.actions.addAll(elements);
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheck(null, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType, (ImmutableSet<String>)this.actions.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Check, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

