/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.WithHash;

public final class RefUtil {
    private RefUtil() {
    }

    public static NamedRef toNamedRef(@Nonnull Reference reference) {
        Objects.requireNonNull(reference, "reference must not be null");
        if (reference instanceof Branch) {
            return BranchName.of((String)reference.getName());
        }
        if (reference instanceof Tag) {
            return TagName.of((String)reference.getName());
        }
        if (reference instanceof Detached) {
            return DetachedRef.INSTANCE;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", reference));
    }

    public static NamedRef toNamedRef(@Nonnull Reference.ReferenceType referenceType, @Nonnull String referenceName) {
        Objects.requireNonNull(referenceType, "referenceType must not be null");
        switch (referenceType) {
            case BRANCH: {
                return BranchName.of((String)referenceName);
            }
            case TAG: {
                return TagName.of((String)referenceName);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type '%s'", referenceType));
    }

    public static Reference toReference(@Nonnull NamedRef namedRef, Hash hash) {
        Objects.requireNonNull(namedRef, "namedRef must not be null");
        return RefUtil.toReference(namedRef, hash != null ? hash.asString() : null);
    }

    public static Reference toReference(@Nonnull NamedRef namedRef, String hash) {
        Objects.requireNonNull(namedRef, "namedRef must not be null");
        if (namedRef instanceof BranchName) {
            return Branch.of((String)namedRef.getName(), (String)hash);
        }
        if (namedRef instanceof TagName) {
            return Tag.of((String)namedRef.getName(), (String)hash);
        }
        if (namedRef instanceof DetachedRef) {
            return Detached.of((String)Objects.requireNonNull(hash, "hash must not be null for detached references"));
        }
        throw new IllegalArgumentException(String.format("Unsupported named reference '%s'", namedRef));
    }

    public static Reference toReference(@Nonnull WithHash<NamedRef> hashWitRef) {
        return RefUtil.toReference((NamedRef)hashWitRef.getValue(), hashWitRef.getHash());
    }

    public static Reference.ReferenceType referenceType(@Nonnull NamedRef namedRef) {
        if (namedRef instanceof BranchName) {
            return Reference.ReferenceType.BRANCH;
        }
        if (namedRef instanceof TagName) {
            return Reference.ReferenceType.TAG;
        }
        throw new IllegalArgumentException(String.format("Not a branch or tag: " + String.valueOf(namedRef), new Object[0]));
    }
}

