/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.authz.ImmutableCheck;
import org.projectnessie.versioned.NamedRef;

public abstract class AbstractBatchAccessChecker
implements BatchAccessChecker {
    public static final BatchAccessChecker NOOP_ACCESS_CHECKER = new AbstractBatchAccessChecker(){

        @Override
        public Map<Check, String> check() {
            return Collections.emptyMap();
        }

        @Override
        public BatchAccessChecker can(Check check) {
            return this;
        }
    };
    private final Collection<Check> checks = new LinkedHashSet<Check>();

    private BatchAccessChecker add(ImmutableCheck.Builder builder) {
        return this.can(builder.build());
    }

    protected Collection<Check> getChecks() {
        return this.checks;
    }

    @Override
    public BatchAccessChecker can(Check check) {
        this.checks.add(check);
        return this;
    }

    @Override
    public BatchAccessChecker canViewReference(NamedRef ref) {
        return this.add(Check.builder(Check.CheckType.VIEW_REFERENCE).ref(ref));
    }

    @Override
    public BatchAccessChecker canCreateReference(NamedRef ref) {
        return this.add(Check.builder(Check.CheckType.CREATE_REFERENCE).ref(ref));
    }

    @Override
    public BatchAccessChecker canAssignRefToHash(NamedRef ref) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.ASSIGN_REFERENCE_TO_HASH).ref(ref));
    }

    @Override
    public BatchAccessChecker canDeleteReference(NamedRef ref) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.DELETE_REFERENCE).ref(ref));
    }

    @Override
    public BatchAccessChecker canReadEntries(NamedRef ref) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.READ_ENTRIES).ref(ref));
    }

    @Override
    public BatchAccessChecker canReadContentKey(NamedRef ref, ContentKey key, String contentId) {
        this.canViewReference(ref);
        ImmutableCheck.Builder builder = Check.builder(Check.CheckType.READ_CONTENT_KEY).ref(ref).key(key);
        if (contentId != null) {
            builder.contentId(contentId);
        }
        return this.add(builder);
    }

    @Override
    public BatchAccessChecker canListCommitLog(NamedRef ref) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.LIST_COMMIT_LOG).ref(ref));
    }

    @Override
    public BatchAccessChecker canCommitChangeAgainstReference(NamedRef ref) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.COMMIT_CHANGE_AGAINST_REFERENCE).ref(ref));
    }

    @Override
    public BatchAccessChecker canReadEntityValue(NamedRef ref, ContentKey key, String contentId) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.READ_ENTITY_VALUE).ref(ref).key(key).contentId(contentId));
    }

    @Override
    public BatchAccessChecker canUpdateEntity(NamedRef ref, ContentKey key, String contentId, Content.Type contentType) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.UPDATE_ENTITY).ref(ref).key(key).contentId(contentId).contentType(contentType));
    }

    @Override
    public BatchAccessChecker canDeleteEntity(NamedRef ref, ContentKey key, String contentId) {
        this.canViewReference(ref);
        return this.add(Check.builder(Check.CheckType.DELETE_ENTITY).ref(ref).key(key).contentId(contentId));
    }

    @Override
    public BatchAccessChecker canViewRefLog() {
        return this.add(Check.builder(Check.CheckType.VIEW_REFLOG));
    }
}

