/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.ServerAccessContext;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseApiImpl {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    private final Supplier<Principal> principal;
    protected static final int ACCESS_CHECK_BATCH_SIZE = 10;

    protected BaseApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
        this.principal = principal;
    }

    WithHash<NamedRef> namedRefWithHashOrThrow(@Nullable String namedRef, @Nullable String hashOnRef) throws NessieReferenceNotFoundException {
        WithHash namedRefWithHash;
        if (null == namedRef) {
            namedRef = this.config.getDefaultBranch();
        }
        if ("DETACHED".equals(namedRef)) {
            Objects.requireNonNull(hashOnRef, String.format("hashOnRef must not be null for '%s'", "DETACHED"));
            return WithHash.of((Hash)Hash.of((String)hashOnRef), (Object)DetachedRef.INSTANCE);
        }
        try {
            ReferenceInfo ref = this.getStore().getNamedRef(namedRef, GetNamedRefsParams.DEFAULT);
            namedRefWithHash = WithHash.of((Hash)ref.getHash(), (Object)ref.getNamedRef());
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        try {
            if (null == hashOnRef) {
                return namedRefWithHash;
            }
            if (this.store.noAncestorHash().asString().equals(hashOnRef)) {
                return WithHash.of((Hash)this.store.noAncestorHash(), (Object)((NamedRef)namedRefWithHash.getValue()));
            }
            if (namedRefWithHash.getHash().asString().equals(hashOnRef)) {
                return namedRefWithHash;
            }
            return WithHash.of((Hash)this.getStore().hashOnReference((NamedRef)namedRefWithHash.getValue(), Optional.of(Hash.of((String)hashOnRef))), (Object)((NamedRef)namedRefWithHash.getValue()));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected ServerConfig getConfig() {
        return this.config;
    }

    protected VersionStore getStore() {
        return this.store;
    }

    protected Principal getPrincipal() {
        return this.principal.get();
    }

    protected Authorizer getAuthorizer() {
        return this.authorizer;
    }

    protected BatchAccessChecker startAccessCheck() {
        return this.getAuthorizer().startAccessCheck(this.createAccessContext());
    }

    protected ServerAccessContext createAccessContext() {
        return ServerAccessContext.of(UUID.randomUUID().toString(), this.getPrincipal());
    }

    protected MetadataRewriter<CommitMeta> commitMetaUpdate(final @Nullable String messageOverride) {
        return new MetadataRewriter<CommitMeta>(){
            private final Principal principal;
            private final String committer;
            private final Instant now;
            {
                this.principal = BaseApiImpl.this.getPrincipal();
                this.committer = this.principal == null ? "" : this.principal.getName();
                this.now = Instant.now();
            }

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                ImmutableCommitMeta.Builder builder = metadata.toBuilder().committer(this.committer).commitTime(this.now).author(metadata.getAuthor() == null ? this.committer : metadata.getAuthor()).authorTime(metadata.getAuthorTime() == null ? this.now : metadata.getAuthorTime());
                if (messageOverride != null) {
                    builder.message(messageOverride);
                }
                return builder.build();
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                if (metadata.size() == 1) {
                    return this.rewriteSingle(metadata.get(0));
                }
                ImmutableCommitMeta.Builder newMeta = CommitMeta.builder().committer(this.committer).commitTime(this.now).author(this.committer).authorTime(this.now);
                StringBuilder newMessage = new StringBuilder();
                if (messageOverride != null) {
                    newMessage.append(messageOverride);
                }
                HashMap newProperties = new HashMap();
                for (CommitMeta commitMeta : metadata) {
                    newProperties.putAll(commitMeta.getProperties());
                    if (messageOverride != null) continue;
                    if (newMessage.length() > 0) {
                        newMessage.append("\n---------------------------------------------\n");
                    }
                    newMessage.append(commitMeta.getMessage());
                }
                return newMeta.putAllProperties(newProperties).message(newMessage.toString()).build();
            }
        };
    }
}

