/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.spi.NamespaceService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.paging.PaginationIterator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NamespaceApiImpl
extends BaseApiImpl
implements NamespaceService {
    public NamespaceApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public Namespace createNamespace(String refName, Namespace namespace) throws NessieReferenceNotFoundException {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (Object)"Namespace name must not be empty");
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(refName, null);
        try {
            Callable<Void> validator = () -> {
                Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, refWithHash.getHash());
                if (explicitlyCreatedNamespace.isPresent()) {
                    Namespace ignored = (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.otherContentAlreadyExistsException(namespace));
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
                if (this.getImplicitlyCreatedNamespace(namespace, refWithHash.getHash()).isPresent()) {
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
                return null;
            };
            ContentKey key = namespace.toContentKey();
            Operation.Put put = Operation.Put.of((ContentKey)key, (Content)namespace);
            Hash hash = this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "create namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put), validator);
            Content content = this.getExplicitlyCreatedNamespace(namespace, hash).orElse(null);
            Preconditions.checkState((boolean)(content instanceof Namespace), (String)"Expected %s to return the created Namespace, but got %s", (Object)key, (Object)content);
            return (Namespace)content;
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteNamespace(String refName, Namespace namespaceToDelete) throws NessieReferenceNotFoundException, NessieNamespaceNotFoundException {
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(refName, null);
        try {
            Namespace namespace = this.getNamespace(namespaceToDelete, refWithHash.getHash());
            Operation.Delete delete = Operation.Delete.of((ContentKey)namespace.toContentKey());
            Callable<Void> validator = () -> {
                try (PaginationIterator keys = this.getStore().getKeys((Ref)refWithHash.getHash(), null, false);){
                    while (keys.hasNext()) {
                        KeyEntry k = (KeyEntry)keys.next();
                        if (!Namespace.of((List)k.getKey().getElements()).isSameOrSubElementOf(namespaceToDelete) || k.getType().equals(Content.Type.NAMESPACE)) continue;
                        throw NamespaceApiImpl.namespaceNotEmptyException(namespaceToDelete);
                    }
                }
                return null;
            };
            this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "delete namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)delete), validator);
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public Namespace getNamespace(String refName, String hashOnRef, Namespace namespace) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            return this.getNamespace(namespace, this.namedRefWithHashOrThrow(refName, hashOnRef).getHash());
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    private Namespace getNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException, NessieNamespaceNotFoundException {
        Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, hash);
        if (explicitlyCreatedNamespace.isPresent()) {
            return (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
        }
        return this.getImplicitlyCreatedNamespace(namespace, hash).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
    }

    @Override
    public GetNamespacesResponse getNamespaces(String refName, String hashOnRef, Namespace namespace) throws NessieReferenceNotFoundException {
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(refName, hashOnRef);
        try {
            HashSet explicitNamespaceKeys = new HashSet();
            HashMap implicitNamespaces = new HashMap();
            try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(namespace, refWithHash.getHash(), k -> true);){
                stream.forEach(namespaceKeyWithType -> {
                    if (namespaceKeyWithType.getType().equals(Content.Type.NAMESPACE)) {
                        explicitNamespaceKeys.add(namespaceKeyWithType.getKey());
                    } else {
                        Namespace implicitNamespace = NamespaceApiImpl.namespaceFromType(namespaceKeyWithType);
                        if (!implicitNamespace.isEmpty()) {
                            implicitNamespaces.put(implicitNamespace.getElements(), implicitNamespace);
                        }
                    }
                });
            }
            ImmutableGetNamespacesResponse.Builder response = GetNamespacesResponse.builder().effectiveReference(RefUtil.toReference((NamedRef)refWithHash.getValue(), refWithHash.getHash()));
            if (!explicitNamespaceKeys.isEmpty()) {
                Map namespaceValues = this.getStore().getValues((Ref)refWithHash.getHash(), explicitNamespaceKeys);
                namespaceValues.values().stream().filter(Namespace.class::isInstance).map(Namespace.class::cast).peek(explicitNamespace -> implicitNamespaces.remove(explicitNamespace.getElements())).forEach(arg_0 -> ((ImmutableGetNamespacesResponse.Builder)response).addNamespaces(arg_0));
            }
            response.addAllNamespaces(implicitNamespaces.values());
            return response.build();
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    @Override
    public void updateProperties(String refName, Namespace namespaceToUpdate, Map<String, String> propertyUpdates, Set<String> propertyRemovals) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(refName, null);
            Namespace namespace = this.getNamespace(namespaceToUpdate, refWithHash.getHash());
            HashMap<String, String> properties = new HashMap<String, String>(namespace.getProperties());
            if (null != propertyRemovals) {
                propertyRemovals.forEach(properties::remove);
            }
            if (null != propertyUpdates) {
                properties.putAll(propertyUpdates);
            }
            ImmutableNamespace updatedNamespace = ImmutableNamespace.copyOf((Namespace)namespace).withProperties(properties);
            Operation.Put put = Operation.Put.of((ContentKey)updatedNamespace.toContentKey(), (Content)updatedNamespace);
            this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "update properties for namespace " + updatedNamespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put), () -> null);
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @MustBeClosed
    private Stream<KeyEntry> getNamespacesKeyStream(@Nullable Namespace namespace, Hash hash, Predicate<KeyEntry> earlyFilterPredicate) throws ReferenceNotFoundException {
        PaginationIterator iter = this.getStore().getKeys((Ref)hash, null, false);
        return ((Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false).onClose(() -> ((PaginationIterator)iter).close())).filter(earlyFilterPredicate).filter(k -> null == namespace || NamespaceApiImpl.namespaceFromType(k).isSameOrSubElementOf(namespace));
    }

    private static Namespace namespaceFromType(KeyEntry withType) {
        List elements = withType.getKey().getElements();
        if (!Content.Type.NAMESPACE.equals(withType.getType())) {
            elements = elements.subList(0, elements.size() - 1);
        }
        return Namespace.of((List)elements);
    }

    private Optional<Content> getExplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        return Optional.ofNullable(this.getStore().getValue((Ref)hash, namespace.toContentKey()));
    }

    private Optional<Namespace> getImplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(namespace, hash, k -> true);){
            Optional<Namespace> optional = stream.findAny().map(NamespaceApiImpl::namespaceFromType);
            return optional;
        }
    }

    private static NessieNamespaceAlreadyExistsException namespaceAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(String.format("Namespace '%s' already exists", namespace));
    }

    private static NessieNamespaceAlreadyExistsException otherContentAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(String.format("Another content object with name '%s' already exists", namespace));
    }

    private static NessieNamespaceNotFoundException namespaceDoesNotExistException(Namespace namespace) {
        return new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", namespace));
    }

    private static NessieNamespaceNotEmptyException namespaceNotEmptyException(Namespace namespace) {
        return new NessieNamespaceNotEmptyException(String.format("Namespace '%s' is not empty", namespace));
    }

    private static NessieReferenceNotFoundException refNotFoundException(ReferenceNotFoundException e) {
        return new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
    }

    private Hash commit(BranchName branch, String commitMsg, Operation contentOperation, Callable<Void> validator) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.getStore().commit(branch, Optional.empty(), (CommitMeta)this.commitMetaUpdate(null).rewriteSingle((Object)CommitMeta.fromMessage((String)commitMsg)), Collections.singletonList(contentOperation), validator, (k, c) -> {});
    }
}

