/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableCommitResponse;
import org.projectnessie.model.ImmutableContentKeyDetails;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.ImmutableMergeResponse;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.AuthzPaginationIterator;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.paging.PaginationIterator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TreeApiImpl
extends BaseApiImpl
implements TreeService {
    public TreeApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public <R> R getAllReferences(FetchOption fetchOption, String filter, String pagingToken, PagedResponseHandler<R, Reference> pagedResponseHandler) {
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
        try (PaginationIterator references = this.getStore().getNamedRefs(this.getGetNamedRefsParams(fetchAll), pagingToken);){
            AuthzPaginationIterator<ReferenceInfo<CommitMeta>> authz = new AuthzPaginationIterator<ReferenceInfo<CommitMeta>>(references, () -> super.startAccessCheck(), 10){

                @Override
                protected Set<Check> checksForEntry(ReferenceInfo<CommitMeta> entry) {
                    return Collections.singleton(Check.canViewReference(entry.getNamedRef()));
                }
            };
            Predicate<Reference> filterPredicate = TreeApiImpl.filterReferences(filter);
            while (authz.hasNext()) {
                ReferenceInfo refInfo = (ReferenceInfo)authz.next();
                Reference ref = TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)refInfo, fetchAll);
                if (!filterPredicate.test(ref) || pagedResponseHandler.addEntry(ref)) continue;
                pagedResponseHandler.hasMore(authz.tokenForCurrent());
                break;
            }
        }
        catch (ReferenceNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find default branch '%s'.", this.getConfig().getDefaultBranch()));
        }
        return pagedResponseHandler.build();
    }

    private GetNamedRefsParams getGetNamedRefsParams(boolean fetchMetadata) {
        return fetchMetadata ? GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)this.getConfig().getDefaultBranch())).branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BASE_REFERENCE_RELATED_AND_COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build() : GetNamedRefsParams.DEFAULT;
    }

    private static Predicate<Reference> filterReferences(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return r -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.REFERENCES_DECLARATIONS).withTypes(CELUtil.REFERENCES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return reference -> {
            try {
                CommitMeta commit;
                ReferenceMetadata refMeta = reference.getMetadata();
                if (refMeta == null) {
                    refMeta = CELUtil.EMPTY_REFERENCE_METADATA;
                }
                if ((commit = refMeta.getCommitMetaOfHEAD()) == null) {
                    commit = CELUtil.EMPTY_COMMIT_META;
                }
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"ref", (Object)reference, (Object)"refType", (Object)reference.getType().name(), (Object)"commit", (Object)commit, (Object)"refMeta", (Object)refMeta));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public Reference getReferenceByName(String refName, FetchOption fetchOption) throws NessieNotFoundException {
        try {
            boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
            Reference ref = TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)this.getStore().getNamedRef(refName, this.getGetNamedRefsParams(fetchAll)), fetchAll);
            this.startAccessCheck().canViewReference(RefUtil.toNamedRef(ref)).checkAndThrow();
            return ref;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Reference createReference(String refName, Reference.ReferenceType type, String targetHash, String sourceRefName) throws NessieNotFoundException, NessieConflictException {
        BatchAccessChecker check;
        NamedRef namedReference;
        block6: {
            Validation.validateForbiddenReferenceName((String)refName);
            namedReference = RefUtil.toNamedRef(type, refName);
            if (type == Reference.ReferenceType.TAG && targetHash == null) {
                throw new IllegalArgumentException("Tag-creation requires a target named-reference and hash.");
            }
            check = this.startAccessCheck().canCreateReference(RefUtil.toNamedRef(type, refName));
            try {
                check.canViewReference((NamedRef)this.namedRefWithHashOrThrow(sourceRefName, targetHash).getValue());
            }
            catch (NessieNotFoundException e) {
                if (Reference.ReferenceType.BRANCH.equals((Object)type) && refName.equals(this.getConfig().getDefaultBranch()) && (null == targetHash || this.getStore().noAncestorHash().asString().equals(targetHash))) break block6;
                throw e;
            }
        }
        check.checkAndThrow();
        try {
            Hash hash = this.getStore().create(namedReference, TreeApiImpl.toHash(targetHash, false));
            return RefUtil.toReference(namedReference, hash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceAlreadyExistsException e) {
            throw new NessieReferenceAlreadyExistsException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        Reference r = this.getReferenceByName(this.getConfig().getDefaultBranch(), FetchOption.MINIMAL);
        Preconditions.checkState((boolean)(r instanceof Branch), (Object)"Default branch isn't a branch");
        return (Branch)r;
    }

    @Override
    public Reference assignReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        try {
            ReferenceInfo resolved = this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT);
            NamedRef ref = resolved.getNamedRef();
            Preconditions.checkArgument((referenceType == null || referenceType == RefUtil.referenceType(ref) ? 1 : 0) != 0, (String)"Expected reference type %s does not match existing reference %s", (Object)referenceType, (Object)ref);
            this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(assignTo.getName(), assignTo.getHash()).getValue()).canAssignRefToHash(ref).checkAndThrow();
            Hash targetHash = this.toHash(assignTo.getName(), assignTo.getHash());
            this.getStore().assign(resolved.getNamedRef(), TreeApiImpl.toHash(expectedHash, true), targetHash);
            return RefUtil.toReference(ref, targetHash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Reference deleteReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        try {
            ReferenceInfo resolved = this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT);
            NamedRef ref = resolved.getNamedRef();
            Preconditions.checkArgument((referenceType == null || referenceType == RefUtil.referenceType(ref) ? 1 : 0) != 0, (String)"Expected reference type %s does not match existing reference %s", (Object)referenceType, (Object)ref);
            Preconditions.checkArgument((!(ref instanceof BranchName) || !this.getConfig().getDefaultBranch().equals(ref.getName()) ? 1 : 0) != 0, (String)"Default branch '%s' cannot be deleted.", (Object)ref.getName());
            this.startAccessCheck().canDeleteReference(ref).checkAndThrow();
            Hash deletedAthash = this.getStore().delete(ref, TreeApiImpl.toHash(expectedHash, true));
            return RefUtil.toReference(ref, deletedAthash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R getCommitLog(String namedRef, FetchOption fetchOption, String oldestHashLimit, String youngestHash, String filter, String pageToken, PagedResponseHandler<R, LogResponse.LogEntry> pagedResponseHandler) throws NessieNotFoundException {
        WithHash<NamedRef> endRef = this.namedRefWithHashOrThrow(namedRef, null == pageToken ? youngestHash : pageToken);
        this.startAccessCheck().canListCommitLog((NamedRef)endRef.getValue()).checkAndThrow();
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
        HashSet<Check> successfulChecks = new HashSet<Check>();
        HashSet<Check> failedChecks = new HashSet<Check>();
        try (PaginationIterator commits = this.getStore().getCommits((Ref)endRef.getHash(), fetchAll);){
            Predicate<LogResponse.LogEntry> predicate = TreeApiImpl.filterCommitLog(filter);
            while (commits.hasNext()) {
                Commit commit = (Commit)commits.next();
                ImmutableLogEntry logEntry = this.commitToLogEntry(fetchAll, commit);
                String hash = logEntry.getCommitMeta().getHash();
                if (!predicate.test((LogResponse.LogEntry)logEntry)) continue;
                boolean stop = Objects.equals(hash, oldestHashLimit);
                if (!pagedResponseHandler.addEntry((LogResponse.LogEntry)(logEntry = this.logEntryOperationsAccessCheck(successfulChecks, failedChecks, endRef, (LogResponse.LogEntry)logEntry)))) {
                    if (stop) break;
                    pagedResponseHandler.hasMore(commits.tokenForCurrent());
                    break;
                }
                if (!stop) continue;
            }
            R r = pagedResponseHandler.build();
            return r;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private LogResponse.LogEntry logEntryOperationsAccessCheck(Set<Check> successfulChecks, Set<Check> failedChecks, WithHash<NamedRef> endRef, LogResponse.LogEntry logEntry) {
        List operations = logEntry.getOperations();
        if (operations == null || operations.isEmpty()) {
            return logEntry;
        }
        ImmutableLogEntry.Builder newLogEntry = ImmutableLogEntry.builder().from(logEntry).operations(Collections.emptyList());
        HashSet checks = Sets.newHashSetWithExpectedSize((int)operations.size());
        for (Operation op : operations) {
            if (op instanceof Operation.Put) {
                Operation.Put put = (Operation.Put)op;
                checks.add(Check.canReadContentKey((NamedRef)endRef.getValue(), put.getKey(), put.getContent().getId()));
                continue;
            }
            if (op instanceof Operation.Delete) {
                Operation.Delete delete = (Operation.Delete)op;
                checks.add(Check.canReadContentKey((NamedRef)endRef.getValue(), delete.getKey(), null));
                continue;
            }
            throw new IllegalStateException("Unknown operation " + op);
        }
        BatchAccessChecker accessCheck = this.startAccessCheck();
        boolean anyCheck = false;
        for (Check check : checks) {
            if (successfulChecks.contains(check) || failedChecks.contains(check)) continue;
            accessCheck.can(check);
            anyCheck = true;
        }
        Map<Object, Object> failures = anyCheck ? accessCheck.check() : Collections.emptyMap();
        for (Operation op : operations) {
            Check check;
            if (op instanceof Operation.Put) {
                Operation.Put put = (Operation.Put)op;
                check = Check.canReadContentKey((NamedRef)endRef.getValue(), put.getKey(), put.getContent().getId());
            } else if (op instanceof Operation.Delete) {
                Operation.Delete delete = (Operation.Delete)op;
                check = Check.canReadContentKey((NamedRef)endRef.getValue(), delete.getKey(), null);
            } else {
                throw new IllegalStateException("Unknown operation " + op);
            }
            if (failures.containsKey(check)) {
                failedChecks.add(check);
                continue;
            }
            if (failedChecks.contains(check)) continue;
            newLogEntry.addOperations(op);
            successfulChecks.add(check);
        }
        return newLogEntry.build();
    }

    private ImmutableLogEntry commitToLogEntry(boolean fetchAll, Commit commit) {
        CommitMeta commitMetaWithHash = TreeApiImpl.enhanceCommitMeta(commit.getHash(), commit.getCommitMeta());
        ImmutableLogEntry.Builder logEntry = LogResponse.LogEntry.builder();
        logEntry.commitMeta(commitMetaWithHash);
        if (commit.getParentHash() != null) {
            logEntry.parentCommitHash(commit.getParentHash().asString());
        }
        if (fetchAll && commit.getOperations() != null) {
            commit.getOperations().forEach(op -> {
                ContentKey key = op.getKey();
                if (op instanceof Put) {
                    Content content = ((Put)op).getValue();
                    logEntry.addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)content));
                }
                if (op instanceof Delete) {
                    logEntry.addOperations((Operation)Operation.Delete.of((ContentKey)key));
                }
            });
        }
        return logEntry.build();
    }

    private static CommitMeta enhanceCommitMeta(Hash hash, CommitMeta commitMeta) {
        if (commitMeta.getParentCommitHashes().size() > 1) {
            ImmutableCommitMeta.Builder updatedCommitMeta = commitMeta.toBuilder().hash(hash.asString());
            updatedCommitMeta.putProperties("_merge_parent", (String)commitMeta.getParentCommitHashes().get(1));
            return updatedCommitMeta.build();
        }
        return commitMeta;
    }

    private static Predicate<LogResponse.LogEntry> filterCommitLog(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.COMMIT_LOG_DECLARATIONS).withTypes(CELUtil.COMMIT_LOG_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return logEntry -> {
            try {
                List operations = logEntry.getOperations();
                if (operations == null) {
                    operations = Collections.emptyList();
                }
                List operationsForCel = operations.stream().map(CELUtil::forCel).collect(Collectors.toList());
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"commit", (Object)logEntry.getCommitMeta(), (Object)"operations", operationsForCel));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, String message, List<String> hashesToTransplant, String fromRefName, Boolean keepIndividualCommits, Collection<MergeKeyBehavior> keyMergeTypes, MergeBehavior defaultMergeType, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        try {
            List transplants;
            if (hashesToTransplant.isEmpty()) {
                throw new IllegalArgumentException("No hashes given to transplant.");
            }
            BranchName targetBranch = BranchName.of((String)branchName);
            this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(fromRefName, hashesToTransplant.get(hashesToTransplant.size() - 1)).getValue()).canCommitChangeAgainstReference((NamedRef)targetBranch).checkAndThrow();
            try (Stream<Hash> s = hashesToTransplant.stream().map(Hash::of);){
                transplants = s.collect(Collectors.toList());
            }
            if (Boolean.TRUE.equals(keepIndividualCommits) && transplants.size() > 1) {
                message = null;
            }
            MergeResult result = this.getStore().transplant(targetBranch, TreeApiImpl.toHash(expectedHash, true), transplants, this.commitMetaUpdate(message), Boolean.TRUE.equals(keepIndividualCommits), TreeApiImpl.keyMergeTypes(keyMergeTypes), TreeApiImpl.defaultMergeType(defaultMergeType), Boolean.TRUE.equals(dryRun), Boolean.TRUE.equals(fetchAdditionalInfo));
            return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(returnConflictAsResult)) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, String fromRefName, String fromHash, Boolean keepIndividualCommits, @Nullable String message, Collection<MergeKeyBehavior> keyMergeTypes, MergeBehavior defaultMergeType, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        try {
            BranchName targetBranch = BranchName.of((String)branchName);
            this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(fromRefName, fromHash).getValue()).canCommitChangeAgainstReference((NamedRef)targetBranch).checkAndThrow();
            MergeResult result = this.getStore().merge(this.toHash(fromRefName, fromHash), targetBranch, TreeApiImpl.toHash(expectedHash, true), this.commitMetaUpdate(message), Boolean.TRUE.equals(keepIndividualCommits), TreeApiImpl.keyMergeTypes(keyMergeTypes), TreeApiImpl.defaultMergeType(defaultMergeType), Boolean.TRUE.equals(dryRun), Boolean.TRUE.equals(fetchAdditionalInfo));
            return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(returnConflictAsResult)) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private MergeResponse createResponse(Boolean fetchAdditionalInfo, MergeResult<Commit> result) {
        Function<Hash, String> hashToString = h -> h != null ? h.asString() : null;
        ImmutableMergeResponse.Builder response = ImmutableMergeResponse.builder().targetBranch(result.getTargetBranch().getName()).resultantTargetHash(hashToString.apply(result.getResultantTargetHash())).effectiveTargetHash(hashToString.apply(result.getEffectiveTargetHash())).expectedHash(hashToString.apply(result.getExpectedHash())).commonAncestor(hashToString.apply(result.getCommonAncestor())).wasApplied(result.wasApplied()).wasSuccessful(result.wasSuccessful());
        BiConsumer<List, Consumer> convertCommits = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(c -> this.commitToLogEntry(Boolean.TRUE.equals(fetchAdditionalInfo), (Commit)c)).forEach((Consumer<ImmutableLogEntry>)dest);
        };
        convertCommits.accept(result.getSourceCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addSourceCommits(arg_0));
        convertCommits.accept(result.getTargetCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addTargetCommits(arg_0));
        BiConsumer<List, Consumer> convertCommitIds = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(hashToString).forEach(dest);
        };
        result.getDetails().forEach((key, details) -> {
            ImmutableContentKeyDetails.Builder keyDetails = ImmutableContentKeyDetails.builder().key(ContentKey.of((List)key.getElements())).conflictType(MergeResponse.ContentKeyConflict.valueOf((String)details.getConflictType().name())).mergeBehavior(MergeBehavior.valueOf((String)details.getMergeType().name()));
            convertCommitIds.accept(details.getSourceCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addSourceCommits(arg_0));
            convertCommitIds.accept(details.getTargetCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addTargetCommits(arg_0));
            response.addDetails((MergeResponse.ContentKeyDetails)keyDetails.build());
        });
        return response.build();
    }

    private static Map<ContentKey, MergeType> keyMergeTypes(Collection<MergeKeyBehavior> behaviors) {
        return behaviors != null ? behaviors.stream().collect(Collectors.toMap(MergeKeyBehavior::getKey, e -> MergeType.valueOf((String)e.getMergeBehavior().name()))) : Collections.emptyMap();
    }

    private static MergeType defaultMergeType(MergeBehavior mergeBehavior) {
        return mergeBehavior != null ? MergeType.valueOf((String)mergeBehavior.name()) : MergeType.NORMAL;
    }

    @Override
    public <R> R getEntries(String namedRef, String hashOnRef, Integer namespaceDepth, String filter, String pagingToken, boolean withContent, PagedResponseHandler<R, EntriesResponse.Entry> pagedResponseHandler, Consumer<WithHash<NamedRef>> effectiveReference) throws NessieNotFoundException {
        final WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        effectiveReference.accept(refWithHash);
        try {
            block11: {
                Predicate<KeyEntry> filterPredicate = this.filterEntries(filter);
                try (PaginationIterator entries = this.getStore().getKeys((Ref)refWithHash.getHash(), pagingToken, withContent);){
                    AuthzPaginationIterator authz = new AuthzPaginationIterator<KeyEntry>(entries, () -> super.startAccessCheck(), 10){

                        @Override
                        protected Set<Check> checksForEntry(KeyEntry entry) {
                            return Collections.singleton(Check.canReadContentKey((NamedRef)refWithHash.getValue(), entry.getKey(), entry.getContentId()));
                        }
                    }.initialCheck(Check.canReadEntries((NamedRef)refWithHash.getValue()));
                    if (namespaceDepth != null && namespaceDepth > 0) {
                        int depth = namespaceDepth;
                        filterPredicate = filterPredicate.and(e -> e.getKey().getElementCount() >= depth);
                        HashSet<ContentKey> seen = new HashSet<ContentKey>();
                        while (authz.hasNext()) {
                            KeyEntry key = (KeyEntry)authz.next();
                            if (!filterPredicate.test(key)) continue;
                            EntriesResponse.Entry entry = EntriesResponse.Entry.entry((ContentKey)key.getKey(), (Content.Type)key.getType(), (String)key.getContentId());
                            if (!seen.add((entry = TreeApiImpl.namespaceDepthMapping(entry, depth)).getName()) || pagedResponseHandler.addEntry(entry)) continue;
                            pagedResponseHandler.hasMore(authz.tokenForCurrent());
                            break block11;
                        }
                        break block11;
                    }
                    while (authz.hasNext()) {
                        Content c;
                        EntriesResponse.Entry entry;
                        KeyEntry key = (KeyEntry)authz.next();
                        if (!filterPredicate.test(key) || pagedResponseHandler.addEntry(entry = (c = key.getContent()) != null ? EntriesResponse.Entry.entry((ContentKey)key.getKey(), (Content.Type)key.getType(), (Content)c) : EntriesResponse.Entry.entry((ContentKey)key.getKey(), (Content.Type)key.getType(), (String)key.getContentId()))) continue;
                        pagedResponseHandler.hasMore(authz.tokenForCurrent());
                        break;
                    }
                }
            }
            return pagedResponseHandler.build();
        }
        catch (ReferenceNotFoundException e2) {
            throw new NessieReferenceNotFoundException(e2.getMessage(), (Throwable)e2);
        }
    }

    private static EntriesResponse.Entry namespaceDepthMapping(EntriesResponse.Entry entry, int depth) {
        Content.Type type = entry.getName().getElementCount() > depth ? Content.Type.NAMESPACE : entry.getType();
        ContentKey key = ContentKey.of(entry.getName().getElements().subList(0, depth));
        return EntriesResponse.Entry.entry((ContentKey)key, (Content.Type)type);
    }

    protected Predicate<KeyEntry> filterEntries(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.ENTRIES_DECLARATIONS).withTypes(CELUtil.ENTRIES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return entry -> {
            ImmutableMap arguments = ImmutableMap.of((Object)"entry", (Object)CELUtil.forCel(entry));
            try {
                return (Boolean)script.execute(Boolean.class, (Map)arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public CommitResponse commitMultipleOperations(String branch, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        BranchName branchName = BranchName.of((String)branch);
        BatchAccessChecker check = this.startAccessCheck().canCommitChangeAgainstReference((NamedRef)branchName);
        operations.getOperations().forEach(op -> {
            if (op instanceof Operation.Delete) {
                check.canDeleteEntity((NamedRef)branchName, op.getKey(), null);
            } else if (op instanceof Operation.Put) {
                Operation.Put putOp = (Operation.Put)op;
                check.canUpdateEntity((NamedRef)branchName, op.getKey(), putOp.getContent().getId(), putOp.getContent().getType());
            }
        });
        check.checkAndThrow();
        List ops = (List)operations.getOperations().stream().map(TreeApiImpl::toOp).collect(ImmutableList.toImmutableList());
        CommitMeta commitMeta = operations.getCommitMeta();
        if (commitMeta.getCommitter() != null) {
            throw new IllegalArgumentException("Cannot set the committer on the client side. It is set by the server.");
        }
        try {
            ImmutableCommitResponse.Builder commitResponse = ImmutableCommitResponse.builder();
            Hash newHash = this.getStore().commit(BranchName.of((String)branch), Optional.ofNullable(expectedHash).map(Hash::of), (CommitMeta)this.commitMetaUpdate(null).rewriteSingle((Object)commitMeta), ops, () -> null, (key, cid) -> commitResponse.addAddedContents(CommitResponse.AddedContent.addedContent((ContentKey)key, (String)cid)));
            return commitResponse.targetBranch(Branch.of((String)branch, (String)newHash.asString())).build();
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private Hash toHash(String referenceName, String hashOnReference) throws ReferenceNotFoundException {
        if ("DETACHED".equals(referenceName)) {
            return Hash.of((String)hashOnReference);
        }
        if (hashOnReference == null) {
            return this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT).getHash();
        }
        return TreeApiImpl.toHash(hashOnReference, true).orElseThrow(() -> new IllegalStateException("Required hash is missing"));
    }

    private static Optional<Hash> toHash(String hash, boolean required) {
        if (hash == null || hash.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException("Must provide expected hash value for operation.");
            }
            return Optional.empty();
        }
        return Optional.of(Hash.of((String)hash));
    }

    private static Reference makeReference(ReferenceInfo<CommitMeta> refWithHash, boolean fetchMetadata) {
        NamedRef ref = refWithHash.getNamedRef();
        if (ref instanceof TagName) {
            return Tag.of((String)ref.getName(), (String)refWithHash.getHash().asString(), (ReferenceMetadata)(fetchMetadata ? TreeApiImpl.extractReferenceMetadata(refWithHash) : null));
        }
        if (ref instanceof BranchName) {
            return Branch.of((String)ref.getName(), (String)refWithHash.getHash().asString(), (ReferenceMetadata)(fetchMetadata ? TreeApiImpl.extractReferenceMetadata(refWithHash) : null));
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }

    @Nullable
    private static ReferenceMetadata extractReferenceMetadata(ReferenceInfo<CommitMeta> refWithHash) {
        ImmutableReferenceMetadata.Builder builder = ImmutableReferenceMetadata.builder();
        boolean found = false;
        if (null != refWithHash.getAheadBehind()) {
            found = true;
            builder.numCommitsAhead(Integer.valueOf(refWithHash.getAheadBehind().getAhead()));
            builder.numCommitsBehind(Integer.valueOf(refWithHash.getAheadBehind().getBehind()));
        }
        if (null != refWithHash.getHeadCommitMeta()) {
            found = true;
            builder.commitMetaOfHEAD(TreeApiImpl.enhanceCommitMeta(refWithHash.getHash(), (CommitMeta)refWithHash.getHeadCommitMeta()));
        }
        if (0L != refWithHash.getCommitSeq()) {
            found = true;
            builder.numTotalCommits(Long.valueOf(refWithHash.getCommitSeq()));
        }
        if (null != refWithHash.getCommonAncestor()) {
            found = true;
            builder.commonAncestorHash(refWithHash.getCommonAncestor().asString());
        }
        if (!found) {
            return null;
        }
        return builder.build();
    }

    protected static org.projectnessie.versioned.Operation toOp(Operation o) {
        ContentKey key = o.getKey();
        if (o instanceof Operation.Delete) {
            return Delete.of((ContentKey)key);
        }
        if (o instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)o;
            return Put.of((ContentKey)key, (Content)put.getContent());
        }
        if (o instanceof Operation.Unchanged) {
            return Unchanged.of((ContentKey)key);
        }
        throw new IllegalStateException("Unknown operation " + o);
    }
}

