/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Detached;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class ContentApiImpl
extends BaseApiImpl
implements ContentService {
    public ContentApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public ContentResponse getContent(ContentKey key, String namedRef, String hashOnRef) throws NessieNotFoundException {
        WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        this.startAccessCheck().canReadEntityValue((NamedRef)ref.getValue(), key, null).checkAndThrow();
        try {
            Content obj = this.getStore().getValue((Ref)ref.getHash(), key);
            if (obj != null) {
                return ContentResponse.of((Content)obj, (Reference)ContentApiImpl.makeReference(ref));
            }
            throw new NessieContentNotFoundException(key, namedRef);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public GetMultipleContentsResponse getMultipleContents(String namedRef, String hashOnRef, List<ContentKey> externalKeys) throws NessieNotFoundException {
        try {
            WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
            BatchAccessChecker check = this.startAccessCheck();
            ArrayList<ContentKey> internalKeys = new ArrayList<ContentKey>(externalKeys.size());
            for (ContentKey externalKey : externalKeys) {
                check.canReadEntityValue((NamedRef)ref.getValue(), externalKey, null);
                internalKeys.add(externalKey);
            }
            check.checkAndThrow();
            Map values = this.getStore().getValues((Ref)ref.getHash(), internalKeys);
            List output = values.entrySet().stream().map(e -> GetMultipleContentsResponse.ContentWithKey.of((ContentKey)((ContentKey)e.getKey()), (Content)((Content)e.getValue()))).collect(Collectors.toList());
            return GetMultipleContentsResponse.of(output, (Reference)ContentApiImpl.makeReference(ref));
        }
        catch (ReferenceNotFoundException ex) {
            throw new NessieReferenceNotFoundException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static Reference makeReference(WithHash<NamedRef> refWithHash) {
        NamedRef ref = (NamedRef)refWithHash.getValue();
        if (ref instanceof TagName) {
            return Tag.of((String)ref.getName(), (String)refWithHash.getHash().asString());
        }
        if (ref instanceof BranchName) {
            return Branch.of((String)ref.getName(), (String)refWithHash.getHash().asString());
        }
        if (ref instanceof DetachedRef) {
            return Detached.of((String)refWithHash.getHash().asString());
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }
}

