/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.ServerAccessContext;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseApiImpl {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    private final Supplier<Principal> principal;
    protected static final int ACCESS_CHECK_BATCH_SIZE = 10;

    protected BaseApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
        this.principal = principal;
    }

    static Predicate<ContentKey> filterOnContentKey(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.CONTENT_KEY_DECLARATIONS).withTypes(CELUtil.CONTENT_KEY_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return key -> {
            try {
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"key", (Object)CELUtil.forCel(key)));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    WithHash<NamedRef> namedRefWithHashOrThrow(@Nullable String namedRef, @Nullable String hashOnRef) throws NessieReferenceNotFoundException {
        WithHash namedRefWithHash;
        if (null == namedRef) {
            namedRef = this.config.getDefaultBranch();
        }
        if ("DETACHED".equals(namedRef)) {
            Objects.requireNonNull(hashOnRef, String.format("hashOnRef must not be null for '%s'", "DETACHED"));
            return WithHash.of((Hash)Hash.of((String)hashOnRef), (Object)DetachedRef.INSTANCE);
        }
        try {
            ReferenceInfo ref = this.getStore().getNamedRef(namedRef, GetNamedRefsParams.DEFAULT);
            namedRefWithHash = WithHash.of((Hash)ref.getHash(), (Object)ref.getNamedRef());
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        try {
            if (null == hashOnRef) {
                return namedRefWithHash;
            }
            if (this.store.noAncestorHash().asString().equals(hashOnRef)) {
                return WithHash.of((Hash)this.store.noAncestorHash(), (Object)((NamedRef)namedRefWithHash.getValue()));
            }
            if (namedRefWithHash.getHash().asString().equals(hashOnRef)) {
                return namedRefWithHash;
            }
            return WithHash.of((Hash)this.getStore().hashOnReference((NamedRef)namedRefWithHash.getValue(), Optional.of(Hash.of((String)hashOnRef))), (Object)((NamedRef)namedRefWithHash.getValue()));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected ServerConfig getConfig() {
        return this.config;
    }

    protected VersionStore getStore() {
        return this.store;
    }

    protected Principal getPrincipal() {
        return this.principal.get();
    }

    protected Authorizer getAuthorizer() {
        return this.authorizer;
    }

    protected BatchAccessChecker startAccessCheck() {
        return this.getAuthorizer().startAccessCheck(this.createAccessContext());
    }

    protected ServerAccessContext createAccessContext() {
        return ServerAccessContext.of(UUID.randomUUID().toString(), this.getPrincipal());
    }

    protected MetadataRewriter<CommitMeta> commitMetaUpdate(final @Nullable CommitMeta commitMeta, final IntFunction<String> squashMessage) {
        return new MetadataRewriter<CommitMeta>(){
            private final Principal principal;
            private final String committer;
            private final Instant now;
            {
                this.principal = BaseApiImpl.this.getPrincipal();
                this.committer = this.principal == null ? "" : this.principal.getName();
                this.now = Instant.now();
            }

            private CommitMeta buildCommitMeta(ImmutableCommitMeta.Builder metadata, Supplier<String> defaultMessage) {
                ImmutableCommitMeta pre = metadata.message("").build();
                if (commitMeta != null && !commitMeta.getAllAuthors().isEmpty()) {
                    metadata.allAuthors((Iterable)commitMeta.getAllAuthors());
                } else if (pre.getAllAuthors().isEmpty()) {
                    metadata.allAuthors(Collections.singletonList(this.committer));
                }
                if (commitMeta != null && !commitMeta.getAllSignedOffBy().isEmpty()) {
                    metadata.allSignedOffBy((Iterable)commitMeta.getAllSignedOffBy());
                }
                if (commitMeta != null && commitMeta.getAuthorTime() != null) {
                    metadata.authorTime(commitMeta.getAuthorTime());
                } else if (pre.getAuthorTime() == null) {
                    metadata.authorTime(this.now);
                }
                if (commitMeta != null && !commitMeta.getAllProperties().isEmpty()) {
                    metadata.allProperties(commitMeta.getAllProperties());
                }
                if (commitMeta != null && !commitMeta.getMessage().isEmpty()) {
                    metadata.message(commitMeta.getMessage());
                } else {
                    metadata.message(defaultMessage.get());
                }
                return metadata.committer(this.committer).commitTime(this.now).build();
            }

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                return this.buildCommitMeta(CommitMeta.builder().from(metadata), () -> ((CommitMeta)metadata).getMessage());
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                Optional<String> msg = Optional.ofNullable((String)squashMessage.apply(metadata.size()));
                if (metadata.size() == 1 && !msg.isPresent()) {
                    return this.rewriteSingle(metadata.get(0));
                }
                HashMap newProperties = new HashMap();
                for (CommitMeta commitMeta2 : metadata) {
                    newProperties.putAll(commitMeta2.getProperties());
                }
                return this.buildCommitMeta(CommitMeta.builder().properties(newProperties), () -> msg.orElseGet(() -> {
                    StringBuilder newMessage = new StringBuilder();
                    for (CommitMeta commitMeta2 : metadata) {
                        if (newMessage.length() > 0) {
                            newMessage.append("\n---------------------------------------------\n");
                        }
                        newMessage.append(commitMeta2.getMessage());
                    }
                    return newMessage.toString();
                }));
            }
        };
    }
}

