/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import org.projectnessie.model.ImmutableNessieConfiguration;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.VersionStore;

public class ConfigApiImpl
implements ConfigService {
    private final VersionStore store;
    private final ServerConfig config;
    private final int actualApiVersion;

    public ConfigApiImpl(ServerConfig config, VersionStore store, int actualApiVersion) {
        this.store = store;
        this.config = config;
        this.actualApiVersion = actualApiVersion;
    }

    @Override
    public NessieConfiguration getConfig() {
        RepositoryInformation info = this.store.getRepositoryInformation();
        String defaultBranch = info.getDefaultBranch();
        if (defaultBranch == null) {
            defaultBranch = this.config.getDefaultBranch();
        }
        return ImmutableNessieConfiguration.builder().from(NessieConfiguration.getBuiltInConfig()).defaultBranch(this.config.getDefaultBranch()).actualApiVersion(this.actualApiVersion).noAncestorHash(info.getNoAncestorHash()).repositoryCreationTimestamp(info.getRepositoryCreationTimestamp()).oldestPossibleCommitTimestamp(info.getOldestPossibleCommitTimestamp()).additionalProperties(info.getAdditionalProperties()).build();
    }
}

