/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Validation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.ServerAccessContext;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.DefaultMetadataRewriter;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BaseApiImpl {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    private final Supplier<Principal> principal;

    protected BaseApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
        this.principal = principal;
    }

    static Predicate<ContentKey> filterOnContentKey(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.CONTENT_KEY_DECLARATIONS).withTypes(CELUtil.CONTENT_KEY_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return key -> {
            try {
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"key", (Object)CELUtil.forCel(key)));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    WithHash<NamedRef> namedRefWithHashOrThrow(@Nullable String namedRef, @Nullable String hashOnRef) throws NessieReferenceNotFoundException {
        DetachedRef ref;
        if (null == namedRef) {
            namedRef = this.config.getDefaultBranch();
        }
        Hash hash = null;
        Hash knownValid = null;
        if ("DETACHED".equals(namedRef)) {
            ref = DetachedRef.INSTANCE;
            Objects.requireNonNull(hashOnRef, String.format("hashOnRef must not be null for '%s'", "DETACHED"));
        } else {
            try {
                ReferenceInfo refInfo = this.getStore().getNamedRef(namedRef, GetNamedRefsParams.DEFAULT);
                ref = refInfo.getNamedRef();
                knownValid = hash = refInfo.getHash();
                if (hashOnRef == null || hashOnRef.isEmpty()) {
                    return WithHash.of((Hash)refInfo.getHash(), (Object)ref);
                }
            }
            catch (ReferenceNotFoundException e) {
                throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            Matcher hashAndRelatives = Validation.HASH_OR_RELATIVE_COMMIT_SPEC_PATTERN.matcher(hashOnRef);
            Preconditions.checkArgument((boolean)hashAndRelatives.find(), (Object)"Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit");
            String s = hashAndRelatives.group(1);
            if (s != null) {
                hash = Hash.of((String)s);
            }
            Objects.requireNonNull(hash, String.format("hashOnRef must contain a valid starting commit ID for '%s'", "DETACHED"));
            List relativeSpecs = RelativeCommitSpec.parseRelativeSpecs((String)hashAndRelatives.group(2));
            if (this.store.noAncestorHash().equals(hash)) {
                return WithHash.of((Hash)this.store.noAncestorHash(), (Object)ref);
            }
            if (!hash.equals(knownValid) || !relativeSpecs.isEmpty()) {
                hash = this.getStore().hashOnReference((NamedRef)ref, Optional.of(hash), relativeSpecs);
            }
            return WithHash.of((Hash)hash, (Object)ref);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected ServerConfig getConfig() {
        return this.config;
    }

    protected VersionStore getStore() {
        return this.store;
    }

    protected Principal getPrincipal() {
        return this.principal.get();
    }

    protected Authorizer getAuthorizer() {
        return this.authorizer;
    }

    protected BatchAccessChecker startAccessCheck() {
        return this.getAuthorizer().startAccessCheck(this.createAccessContext());
    }

    protected ServerAccessContext createAccessContext() {
        return ServerAccessContext.of(UUID.randomUUID().toString(), this.getPrincipal());
    }

    protected MetadataRewriter<CommitMeta> commitMetaUpdate(@Nullable CommitMeta commitMeta, IntFunction<String> squashMessage) {
        Principal principal = this.getPrincipal();
        String committer = principal == null ? "" : principal.getName();
        return new DefaultMetadataRewriter(committer, Instant.now(), commitMeta, squashMessage);
    }
}

