/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableCommitResponse;
import org.projectnessie.model.ImmutableContentKeyDetails;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.ImmutableMergeResponse;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.AuthzPaginationIterator;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.paging.PaginationIterator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TreeApiImpl
extends BaseApiImpl
implements TreeService {
    public TreeApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public <R> R getAllReferences(FetchOption fetchOption, String filter, String pagingToken, PagedResponseHandler<R, Reference> pagedResponseHandler) {
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
        try (PaginationIterator references = this.getStore().getNamedRefs(this.getGetNamedRefsParams(fetchAll), pagingToken);){
            AuthzPaginationIterator<ReferenceInfo<CommitMeta>> authz = new AuthzPaginationIterator<ReferenceInfo<CommitMeta>>(references, () -> super.startAccessCheck(), this.getConfig().accessChecksBatchSize()){

                @Override
                protected Set<Check> checksForEntry(ReferenceInfo<CommitMeta> entry) {
                    return Collections.singleton(Check.canViewReference(entry.getNamedRef()));
                }
            };
            Predicate<Reference> filterPredicate = TreeApiImpl.filterReferences(filter);
            while (authz.hasNext()) {
                ReferenceInfo refInfo = (ReferenceInfo)authz.next();
                Reference ref = TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)refInfo, fetchAll);
                if (!filterPredicate.test(ref) || pagedResponseHandler.addEntry(ref)) continue;
                pagedResponseHandler.hasMore(authz.tokenForCurrent());
                break;
            }
        }
        catch (ReferenceNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find default branch '%s'.", this.getConfig().getDefaultBranch()));
        }
        return pagedResponseHandler.build();
    }

    private GetNamedRefsParams getGetNamedRefsParams(boolean fetchMetadata) {
        return fetchMetadata ? GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)this.getConfig().getDefaultBranch())).branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BASE_REFERENCE_RELATED_AND_COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build() : GetNamedRefsParams.DEFAULT;
    }

    private static Predicate<Reference> filterReferences(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return r -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.REFERENCES_DECLARATIONS).withTypes(CELUtil.REFERENCES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return reference -> {
            try {
                CommitMeta commit;
                ReferenceMetadata refMeta = reference.getMetadata();
                if (refMeta == null) {
                    refMeta = CELUtil.EMPTY_REFERENCE_METADATA;
                }
                if ((commit = refMeta.getCommitMetaOfHEAD()) == null) {
                    commit = CELUtil.EMPTY_COMMIT_META;
                }
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"ref", (Object)reference, (Object)"refType", (Object)reference.getType().name(), (Object)"commit", (Object)commit, (Object)"refMeta", (Object)refMeta));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public Reference getReferenceByName(String refName, FetchOption fetchOption) throws NessieNotFoundException {
        try {
            boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
            Reference ref = TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)this.getStore().getNamedRef(refName, this.getGetNamedRefsParams(fetchAll)), fetchAll);
            this.startAccessCheck().canViewReference(RefUtil.toNamedRef(ref)).checkAndThrow();
            return ref;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Reference createReference(String refName, Reference.ReferenceType type, String targetHash, String sourceRefName) throws NessieNotFoundException, NessieConflictException {
        BatchAccessChecker check;
        NamedRef namedReference;
        block6: {
            Validation.validateForbiddenReferenceName((String)refName);
            namedReference = RefUtil.toNamedRef(type, refName);
            if (type == Reference.ReferenceType.TAG && targetHash == null) {
                throw new IllegalArgumentException("Tag-creation requires a target named-reference and hash.");
            }
            check = this.startAccessCheck().canCreateReference(RefUtil.toNamedRef(type, refName));
            try {
                check.canViewReference((NamedRef)this.namedRefWithHashOrThrow(sourceRefName, targetHash).getValue());
            }
            catch (NessieNotFoundException e) {
                if (Reference.ReferenceType.BRANCH.equals((Object)type) && refName.equals(this.getConfig().getDefaultBranch()) && (null == targetHash || this.getStore().noAncestorHash().asString().equals(targetHash))) break block6;
                throw e;
            }
        }
        check.checkAndThrow();
        try {
            Hash hash = this.getStore().create(namedReference, TreeApiImpl.toHash(targetHash, false)).getHash();
            return RefUtil.toReference(namedReference, hash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceAlreadyExistsException e) {
            throw new NessieReferenceAlreadyExistsException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        Reference r = this.getReferenceByName(this.getConfig().getDefaultBranch(), FetchOption.MINIMAL);
        Preconditions.checkState((boolean)(r instanceof Branch), (Object)"Default branch isn't a branch");
        return (Branch)r;
    }

    @Override
    public Reference assignReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        try {
            ReferenceInfo resolved = this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT);
            NamedRef ref = resolved.getNamedRef();
            Preconditions.checkArgument((referenceType == null || referenceType == RefUtil.referenceType(ref) ? 1 : 0) != 0, (String)"Expected reference type %s does not match existing reference %s", (Object)referenceType, (Object)ref);
            this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(assignTo.getName(), assignTo.getHash()).getValue()).canAssignRefToHash(ref).checkAndThrow();
            Hash targetHash = this.toHash(assignTo.getName(), assignTo.getHash());
            this.getStore().assign(resolved.getNamedRef(), TreeApiImpl.toHash(expectedHash, true), targetHash);
            return RefUtil.toReference(ref, targetHash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Reference deleteReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        try {
            ReferenceInfo resolved = this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT);
            NamedRef ref = resolved.getNamedRef();
            Preconditions.checkArgument((referenceType == null || referenceType == RefUtil.referenceType(ref) ? 1 : 0) != 0, (String)"Expected reference type %s does not match existing reference %s", (Object)referenceType, (Object)ref);
            Preconditions.checkArgument((!(ref instanceof BranchName) || !this.getConfig().getDefaultBranch().equals(ref.getName()) ? 1 : 0) != 0, (String)"Default branch '%s' cannot be deleted.", (Object)ref.getName());
            this.startAccessCheck().canDeleteReference(ref).checkAndThrow();
            Hash deletedAthash = this.getStore().delete(ref, TreeApiImpl.toHash(expectedHash, true)).getHash();
            return RefUtil.toReference(ref, deletedAthash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R getCommitLog(String namedRef, FetchOption fetchOption, String oldestHashLimit, String youngestHash, String filter, String pageToken, PagedResponseHandler<R, LogResponse.LogEntry> pagedResponseHandler) throws NessieNotFoundException {
        WithHash<NamedRef> endRef = this.namedRefWithHashOrThrow(namedRef, null == pageToken ? youngestHash : pageToken);
        this.startAccessCheck().canListCommitLog((NamedRef)endRef.getValue()).checkAndThrow();
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)fetchOption);
        HashSet<Check> successfulChecks = new HashSet<Check>();
        HashSet<Check> failedChecks = new HashSet<Check>();
        try (PaginationIterator commits = this.getStore().getCommits((Ref)endRef.getHash(), fetchAll);){
            Predicate<LogResponse.LogEntry> predicate = TreeApiImpl.filterCommitLog(filter);
            while (commits.hasNext()) {
                Commit commit = (Commit)commits.next();
                ImmutableLogEntry logEntry = this.commitToLogEntry(fetchAll, commit);
                String hash = logEntry.getCommitMeta().getHash();
                if (!predicate.test((LogResponse.LogEntry)logEntry)) continue;
                boolean stop = Objects.equals(hash, oldestHashLimit);
                if (!pagedResponseHandler.addEntry((LogResponse.LogEntry)(logEntry = this.logEntryOperationsAccessCheck(successfulChecks, failedChecks, endRef, (LogResponse.LogEntry)logEntry)))) {
                    if (stop) break;
                    pagedResponseHandler.hasMore(commits.tokenForCurrent());
                    break;
                }
                if (!stop) continue;
            }
            R r = pagedResponseHandler.build();
            return r;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private LogResponse.LogEntry logEntryOperationsAccessCheck(Set<Check> successfulChecks, Set<Check> failedChecks, WithHash<NamedRef> endRef, LogResponse.LogEntry logEntry) {
        List operations = logEntry.getOperations();
        if (operations == null || operations.isEmpty()) {
            return logEntry;
        }
        ImmutableLogEntry.Builder newLogEntry = ImmutableLogEntry.builder().from(logEntry).operations(Collections.emptyList());
        HashMap identifiedKeys = new HashMap();
        try {
            this.getStore().getIdentifiedKeys((Ref)endRef.getHash(), (Collection)operations.stream().map(Operation::getKey).collect(Collectors.toList())).forEach(entry -> identifiedKeys.put(entry.contentKey(), entry));
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
        HashSet checks = Sets.newHashSetWithExpectedSize((int)operations.size());
        for (Operation op : operations) {
            if (op instanceof Operation.Put) {
                checks.add(Check.canReadContentKey((NamedRef)endRef.getValue(), (IdentifiedContentKey)identifiedKeys.get(op.getKey())));
                continue;
            }
            if (op instanceof Operation.Delete) {
                checks.add(Check.canReadContentKey((NamedRef)endRef.getValue(), (IdentifiedContentKey)identifiedKeys.get(op.getKey())));
                continue;
            }
            throw new IllegalStateException("Unknown operation " + op);
        }
        BatchAccessChecker accessCheck = this.startAccessCheck();
        boolean anyCheck = false;
        for (Check check : checks) {
            if (successfulChecks.contains(check) || failedChecks.contains(check)) continue;
            accessCheck.can(check);
            anyCheck = true;
        }
        Map<Object, Object> failures = anyCheck ? accessCheck.check() : Collections.emptyMap();
        for (Operation op : operations) {
            Check check;
            if (op instanceof Operation.Put) {
                check = Check.canReadContentKey((NamedRef)endRef.getValue(), (IdentifiedContentKey)identifiedKeys.get(op.getKey()));
            } else if (op instanceof Operation.Delete) {
                check = Check.canReadContentKey((NamedRef)endRef.getValue(), (IdentifiedContentKey)identifiedKeys.get(op.getKey()));
            } else {
                throw new IllegalStateException("Unknown operation " + op);
            }
            if (failures.containsKey(check)) {
                failedChecks.add(check);
                continue;
            }
            if (failedChecks.contains(check)) continue;
            newLogEntry.addOperations(op);
            successfulChecks.add(check);
        }
        return newLogEntry.build();
    }

    private ImmutableLogEntry commitToLogEntry(boolean fetchAll, Commit commit) {
        CommitMeta commitMetaWithHash = TreeApiImpl.enhanceCommitMeta(commit.getHash(), commit.getCommitMeta());
        ImmutableLogEntry.Builder logEntry = LogResponse.LogEntry.builder();
        logEntry.commitMeta(commitMetaWithHash);
        if (commit.getParentHash() != null) {
            logEntry.parentCommitHash(commit.getParentHash().asString());
        }
        if (fetchAll && commit.getOperations() != null) {
            commit.getOperations().forEach(op -> {
                ContentKey key = op.getKey();
                if (op instanceof Put) {
                    Content content = ((Put)op).getValue();
                    logEntry.addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)content));
                }
                if (op instanceof Delete) {
                    logEntry.addOperations((Operation)Operation.Delete.of((ContentKey)key));
                }
            });
        }
        return logEntry.build();
    }

    private static CommitMeta enhanceCommitMeta(Hash hash, CommitMeta commitMeta) {
        if (commitMeta.getParentCommitHashes().size() > 1) {
            ImmutableCommitMeta.Builder updatedCommitMeta = commitMeta.toBuilder().hash(hash.asString());
            updatedCommitMeta.putProperties("_merge_parent", (String)commitMeta.getParentCommitHashes().get(1));
            return updatedCommitMeta.build();
        }
        return commitMeta;
    }

    private static Predicate<LogResponse.LogEntry> filterCommitLog(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.COMMIT_LOG_DECLARATIONS).withTypes(CELUtil.COMMIT_LOG_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return logEntry -> {
            try {
                List operations = logEntry.getOperations();
                if (operations == null) {
                    operations = Collections.emptyList();
                }
                List operationsForCel = operations.stream().map(CELUtil::forCel).collect(Collectors.toList());
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"commit", (Object)logEntry.getCommitMeta(), (Object)"operations", operationsForCel));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, @Nullable CommitMeta commitMeta, List<String> hashesToTransplant, String fromRefName, Collection<MergeKeyBehavior> keyMergeBehaviors, MergeBehavior defaultMergeBehavior, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        try {
            List transplants;
            Preconditions.checkArgument((!hashesToTransplant.isEmpty() ? 1 : 0) != 0, (Object)"No hashes given to transplant.");
            TreeApiImpl.validateCommitMeta(commitMeta);
            BranchName targetBranch = BranchName.of((String)branchName);
            String lastHash = hashesToTransplant.get(hashesToTransplant.size() - 1);
            Validation.validateHash((String)lastHash);
            WithHash<NamedRef> namedRefWithHash = this.namedRefWithHashOrThrow(fromRefName, lastHash);
            this.startAccessCheck().canViewReference((NamedRef)namedRefWithHash.getValue()).canCommitChangeAgainstReference((NamedRef)targetBranch).checkAndThrow();
            try (Stream<Hash> s = hashesToTransplant.stream().map(Hash::of);){
                transplants = s.collect(Collectors.toList());
            }
            if (transplants.size() > 1) {
                commitMeta = null;
            }
            Optional<Hash> into = TreeApiImpl.toHash(expectedHash, true);
            MergeResult result = this.getStore().transplant((VersionStore.TransplantOp)VersionStore.TransplantOp.builder().fromRef((NamedRef)namedRefWithHash.getValue()).toBranch(targetBranch).expectedHash(into).sequenceToTransplant(transplants).updateCommitMetadata(this.commitMetaUpdate(commitMeta, numCommits -> String.format("Transplanted %d commits from %s at %s into %s%s", numCommits, fromRefName, lastHash, branchName, into.map(h -> " at " + h.asString()).orElse("")))).mergeKeyBehaviors(TreeApiImpl.keyMergeBehaviors(keyMergeBehaviors)).defaultMergeBehavior(TreeApiImpl.defaultMergeBehavior(defaultMergeBehavior)).dryRun(Boolean.TRUE.equals(dryRun)).fetchAdditionalInfo(Boolean.TRUE.equals(fetchAdditionalInfo)).validator(this.createCommitValidator(targetBranch)).build());
            return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(returnConflictAsResult)) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, String fromRefName, String fromHash, @Nullable CommitMeta commitMeta, Collection<MergeKeyBehavior> keyMergeBehaviors, MergeBehavior defaultMergeBehavior, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        try {
            TreeApiImpl.validateCommitMeta(commitMeta);
            BranchName targetBranch = BranchName.of((String)branchName);
            WithHash<NamedRef> namedRefWithHash = this.namedRefWithHashOrThrow(fromRefName, fromHash);
            this.startAccessCheck().canViewReference((NamedRef)namedRefWithHash.getValue()).canCommitChangeAgainstReference((NamedRef)targetBranch).checkAndThrow();
            Hash from = this.toHash(fromRefName, fromHash);
            Optional<Hash> into = TreeApiImpl.toHash(expectedHash, true);
            MergeResult result = this.getStore().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)namedRefWithHash.getValue()).fromHash(this.toHash(fromRefName, fromHash)).toBranch(targetBranch).expectedHash(into).updateCommitMetadata(this.commitMetaUpdate(commitMeta, numCommits -> String.format("Merged %s at %s into %s%s", fromRefName, from.asString(), branchName, into.map(h -> " at " + h.asString()).orElse("")))).mergeKeyBehaviors(TreeApiImpl.keyMergeBehaviors(keyMergeBehaviors)).defaultMergeBehavior(TreeApiImpl.defaultMergeBehavior(defaultMergeBehavior)).dryRun(Boolean.TRUE.equals(dryRun)).fetchAdditionalInfo(Boolean.TRUE.equals(fetchAdditionalInfo)).validator(this.createCommitValidator(targetBranch)).build());
            return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(returnConflictAsResult)) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse(fetchAdditionalInfo, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }

    private static void validateCommitMeta(CommitMeta commitMeta) {
        if (commitMeta != null) {
            Preconditions.checkArgument((commitMeta.getCommitter() == null ? 1 : 0) != 0, (Object)"Cannot set the committer on the client side. It is set by the server.");
            Preconditions.checkArgument((commitMeta.getCommitTime() == null ? 1 : 0) != 0, (Object)"Cannot set the commit time on the client side. It is set by the server.");
            Preconditions.checkArgument((commitMeta.getHash() == null ? 1 : 0) != 0, (Object)"Cannot set the commit hash on the client side. It is set by the server.");
            Preconditions.checkArgument((commitMeta.getParentCommitHashes() == null || commitMeta.getParentCommitHashes().isEmpty() ? 1 : 0) != 0, (Object)"Cannot set the parent commit hashes on the client side. It is set by the server.");
        }
    }

    private MergeResponse createResponse(Boolean fetchAdditionalInfo, MergeResult<Commit> result) {
        Function<Hash, String> hashToString = h -> h != null ? h.asString() : null;
        ImmutableMergeResponse.Builder response = ImmutableMergeResponse.builder().targetBranch(result.getTargetBranch().getName()).resultantTargetHash(hashToString.apply(result.getResultantTargetHash())).effectiveTargetHash(hashToString.apply(result.getEffectiveTargetHash())).expectedHash(hashToString.apply(result.getExpectedHash())).commonAncestor(hashToString.apply(result.getCommonAncestor())).wasApplied(result.wasApplied()).wasSuccessful(result.wasSuccessful());
        BiConsumer<List, Consumer> convertCommits = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(c -> this.commitToLogEntry(Boolean.TRUE.equals(fetchAdditionalInfo), (Commit)c)).forEach((Consumer<ImmutableLogEntry>)dest);
        };
        convertCommits.accept(result.getSourceCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addSourceCommits(arg_0));
        convertCommits.accept(result.getTargetCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addTargetCommits(arg_0));
        BiConsumer<List, Consumer> convertCommitIds = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(hashToString).forEach(dest);
        };
        result.getDetails().forEach((key, details) -> {
            ImmutableContentKeyDetails.Builder keyDetails = ImmutableContentKeyDetails.builder().key(ContentKey.of((List)key.getElements())).conflictType(MergeResponse.ContentKeyConflict.valueOf((String)details.getConflictType().name())).mergeBehavior(MergeBehavior.valueOf((String)details.getMergeBehavior().name())).conflict(details.getConflict());
            convertCommitIds.accept(details.getSourceCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addSourceCommits(arg_0));
            convertCommitIds.accept(details.getTargetCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addTargetCommits(arg_0));
            response.addDetails((MergeResponse.ContentKeyDetails)keyDetails.build());
        });
        return response.build();
    }

    private static Map<ContentKey, MergeKeyBehavior> keyMergeBehaviors(Collection<MergeKeyBehavior> behaviors) {
        return behaviors != null ? behaviors.stream().collect(Collectors.toMap(MergeKeyBehavior::getKey, Function.identity())) : Collections.emptyMap();
    }

    private static MergeBehavior defaultMergeBehavior(MergeBehavior mergeBehavior) {
        return mergeBehavior != null ? mergeBehavior : MergeBehavior.NORMAL;
    }

    @Override
    public <R> R getEntries(String namedRef, String hashOnRef, Integer namespaceDepth, String filter, String pagingToken, boolean withContent, PagedResponseHandler<R, EntriesResponse.Entry> pagedResponseHandler, Consumer<WithHash<NamedRef>> effectiveReference, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, List<ContentKey> requestedKeys) throws NessieNotFoundException {
        final WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        effectiveReference.accept(refWithHash);
        try {
            block17: {
                Predicate<ContentKey> contentKeyPredicate = null;
                if (requestedKeys != null && !requestedKeys.isEmpty()) {
                    contentKeyPredicate = new HashSet<ContentKey>(requestedKeys)::contains;
                    if (prefixKey == null) {
                        ContentKey minRequested = null;
                        ContentKey maxRequested = null;
                        for (ContentKey requestedKey : requestedKeys) {
                            if (minRequested == null || requestedKey.compareTo(minRequested) < 0) {
                                minRequested = requestedKey;
                            }
                            if (maxRequested != null && requestedKey.compareTo(maxRequested) <= 0) continue;
                            maxRequested = requestedKey;
                        }
                        if (minKey == null || minKey.compareTo(minRequested) < 0) {
                            minKey = minRequested;
                        }
                        if (maxKey == null || maxKey.compareTo(maxRequested) > 0) {
                            maxKey = maxRequested;
                        }
                    }
                }
                Predicate<KeyEntry> filterPredicate = this.filterEntries(filter);
                try (PaginationIterator entries = this.getStore().getKeys((Ref)refWithHash.getHash(), pagingToken, withContent, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(minKey).maxKey(maxKey).prefixKey(prefixKey).contentKeyPredicate(contentKeyPredicate).build());){
                    AuthzPaginationIterator authz = new AuthzPaginationIterator<KeyEntry>(entries, () -> super.startAccessCheck(), this.getConfig().accessChecksBatchSize()){

                        @Override
                        protected Set<Check> checksForEntry(KeyEntry entry) {
                            return Collections.singleton(Check.canReadContentKey((NamedRef)refWithHash.getValue(), entry.getKey()));
                        }
                    }.initialCheck(Check.canReadEntries((NamedRef)refWithHash.getValue()));
                    if (namespaceDepth != null && namespaceDepth > 0) {
                        int depth = namespaceDepth;
                        filterPredicate = filterPredicate.and(e -> e.getKey().elements().size() >= depth);
                        HashSet<ContentKey> seen = new HashSet<ContentKey>();
                        while (authz.hasNext()) {
                            EntriesResponse.Entry entry;
                            KeyEntry key = (KeyEntry)authz.next();
                            if (!filterPredicate.test(key)) continue;
                            Content c = key.getContent();
                            EntriesResponse.Entry entry2 = entry = c != null ? EntriesResponse.Entry.entry((ContentKey)key.getKey().contentKey(), (Content.Type)key.getKey().type(), (Content)c) : EntriesResponse.Entry.entry((ContentKey)key.getKey().contentKey(), (Content.Type)key.getKey().type(), (String)key.getKey().lastElement().contentId());
                            if (!seen.add((entry = TreeApiImpl.maybeTruncateToDepth(entry, depth)).getName()) || pagedResponseHandler.addEntry(entry)) continue;
                            pagedResponseHandler.hasMore(authz.tokenForCurrent());
                            break block17;
                        }
                        break block17;
                    }
                    while (authz.hasNext()) {
                        Content c;
                        EntriesResponse.Entry entry;
                        KeyEntry key = (KeyEntry)authz.next();
                        if (!filterPredicate.test(key) || pagedResponseHandler.addEntry(entry = (c = key.getContent()) != null ? EntriesResponse.Entry.entry((ContentKey)key.getKey().contentKey(), (Content.Type)key.getKey().type(), (Content)c) : EntriesResponse.Entry.entry((ContentKey)key.getKey().contentKey(), (Content.Type)key.getKey().type(), (String)key.getKey().lastElement().contentId()))) continue;
                        pagedResponseHandler.hasMore(authz.tokenForCurrent());
                        break;
                    }
                }
            }
            return pagedResponseHandler.build();
        }
        catch (ReferenceNotFoundException e2) {
            throw new NessieReferenceNotFoundException(e2.getMessage(), (Throwable)e2);
        }
    }

    private static EntriesResponse.Entry maybeTruncateToDepth(EntriesResponse.Entry entry, int depth) {
        boolean truncateToNamespace;
        List nameElements = entry.getName().getElements();
        boolean bl = truncateToNamespace = nameElements.size() > depth;
        if (truncateToNamespace) {
            ContentKey namespaceKey = ContentKey.of(nameElements.subList(0, depth));
            return EntriesResponse.Entry.entry((ContentKey)namespaceKey, (Content.Type)Content.Type.NAMESPACE);
        }
        return entry;
    }

    protected Predicate<KeyEntry> filterEntries(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.ENTRIES_DECLARATIONS).withTypes(CELUtil.ENTRIES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return entry -> {
            ImmutableMap arguments = ImmutableMap.of((Object)"entry", (Object)CELUtil.forCel(entry));
            try {
                return (Boolean)script.execute(Boolean.class, (Map)arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public CommitResponse commitMultipleOperations(String branch, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        BranchName branchName = BranchName.of((String)branch);
        CommitMeta commitMeta = operations.getCommitMeta();
        TreeApiImpl.validateCommitMeta(commitMeta);
        List ops = (List)operations.getOperations().stream().map(TreeApiImpl::toOp).collect(ImmutableList.toImmutableList());
        try {
            ImmutableCommitResponse.Builder commitResponse = ImmutableCommitResponse.builder();
            Hash newHash = this.getStore().commit(BranchName.of((String)branch), Optional.ofNullable(expectedHash).map(Hash::of), (CommitMeta)this.commitMetaUpdate(null, numCommits -> null).rewriteSingle((Object)commitMeta), ops, this.createCommitValidator(branchName), (key, cid) -> commitResponse.addAddedContents(CommitResponse.AddedContent.addedContent((ContentKey)key, (String)cid))).getCommitHash();
            return commitResponse.targetBranch(Branch.of((String)branch, (String)newHash.asString())).build();
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getReferenceConflicts(), e.getMessage(), (Throwable)e);
        }
    }

    private VersionStore.CommitValidator createCommitValidator(BranchName branchName) {
        return validation -> {
            BatchAccessChecker check = this.startAccessCheck().canCommitChangeAgainstReference((NamedRef)branchName);
            validation.operations().forEach(op -> {
                switch (op.operationType()) {
                    case CREATE: {
                        check.canCreateEntity((NamedRef)branchName, op.identifiedKey());
                        break;
                    }
                    case UPDATE: {
                        check.canUpdateEntity((NamedRef)branchName, op.identifiedKey());
                        break;
                    }
                    case DELETE: {
                        check.canDeleteEntity((NamedRef)branchName, op.identifiedKey());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown operation type " + op.operationType());
                    }
                }
            });
            check.checkAndThrow();
        };
    }

    private Hash toHash(String referenceName, String hashOnReference) throws ReferenceNotFoundException {
        if ("DETACHED".equals(referenceName)) {
            return Hash.of((String)hashOnReference);
        }
        if (hashOnReference == null) {
            return this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT).getHash();
        }
        return TreeApiImpl.toHash(hashOnReference, true).orElseThrow(() -> new IllegalStateException("Required hash is missing"));
    }

    private static Optional<Hash> toHash(String hash, boolean required) {
        if (hash == null || hash.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException("Must provide expected hash value for operation.");
            }
            return Optional.empty();
        }
        return Optional.of(Hash.of((String)hash));
    }

    private static Reference makeReference(ReferenceInfo<CommitMeta> refWithHash, boolean fetchMetadata) {
        NamedRef ref = refWithHash.getNamedRef();
        if (ref instanceof TagName) {
            return Tag.of((String)ref.getName(), (String)refWithHash.getHash().asString(), (ReferenceMetadata)(fetchMetadata ? TreeApiImpl.extractReferenceMetadata(refWithHash) : null));
        }
        if (ref instanceof BranchName) {
            return Branch.of((String)ref.getName(), (String)refWithHash.getHash().asString(), (ReferenceMetadata)(fetchMetadata ? TreeApiImpl.extractReferenceMetadata(refWithHash) : null));
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }

    @Nullable
    private static ReferenceMetadata extractReferenceMetadata(ReferenceInfo<CommitMeta> refWithHash) {
        ImmutableReferenceMetadata.Builder builder = ImmutableReferenceMetadata.builder();
        boolean found = false;
        if (null != refWithHash.getAheadBehind()) {
            found = true;
            builder.numCommitsAhead(Integer.valueOf(refWithHash.getAheadBehind().getAhead()));
            builder.numCommitsBehind(Integer.valueOf(refWithHash.getAheadBehind().getBehind()));
        }
        if (null != refWithHash.getHeadCommitMeta()) {
            found = true;
            builder.commitMetaOfHEAD(TreeApiImpl.enhanceCommitMeta(refWithHash.getHash(), (CommitMeta)refWithHash.getHeadCommitMeta()));
        }
        if (0L != refWithHash.getCommitSeq()) {
            found = true;
            builder.numTotalCommits(Long.valueOf(refWithHash.getCommitSeq()));
        }
        if (null != refWithHash.getCommonAncestor()) {
            found = true;
            builder.commonAncestorHash(refWithHash.getCommonAncestor().asString());
        }
        if (!found) {
            return null;
        }
        return builder.build();
    }

    protected static org.projectnessie.versioned.Operation toOp(Operation o) {
        ContentKey key = o.getKey();
        if (o instanceof Operation.Delete) {
            return Delete.of((ContentKey)key);
        }
        if (o instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)o;
            return Put.of((ContentKey)key, (Content)put.getContent());
        }
        if (o instanceof Operation.Unchanged) {
            return Unchanged.of((ContentKey)key);
        }
        throw new IllegalStateException("Unknown operation " + o);
    }
}

