/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.NamedRef;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Check", generator="Immutables")
@Immutable
public final class ImmutableCheck
implements Check {
    private final Check.CheckType type;
    @jakarta.annotation.Nullable
    private final NamedRef ref;
    @jakarta.annotation.Nullable
    private final ContentKey key;
    @jakarta.annotation.Nullable
    private final String contentId;
    @jakarta.annotation.Nullable
    private final Content.Type contentType;
    @jakarta.annotation.Nullable
    private final IdentifiedContentKey identifiedKey;
    @jakarta.annotation.Nullable
    private final RepositoryConfig.Type repositoryConfigType;

    private ImmutableCheck(Check.CheckType type, @jakarta.annotation.Nullable NamedRef ref, @jakarta.annotation.Nullable ContentKey key, @jakarta.annotation.Nullable String contentId, @jakarta.annotation.Nullable Content.Type contentType, @jakarta.annotation.Nullable IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable RepositoryConfig.Type repositoryConfigType) {
        this.type = Objects.requireNonNull(type, "type");
        this.ref = ref;
        this.key = key;
        this.contentId = contentId;
        this.contentType = contentType;
        this.identifiedKey = identifiedKey;
        this.repositoryConfigType = repositoryConfigType;
    }

    private ImmutableCheck(ImmutableCheck original, Check.CheckType type, @jakarta.annotation.Nullable NamedRef ref, @jakarta.annotation.Nullable ContentKey key, @jakarta.annotation.Nullable String contentId, @jakarta.annotation.Nullable Content.Type contentType, @jakarta.annotation.Nullable IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable RepositoryConfig.Type repositoryConfigType) {
        this.type = type;
        this.ref = ref;
        this.key = key;
        this.contentId = contentId;
        this.contentType = contentType;
        this.identifiedKey = identifiedKey;
        this.repositoryConfigType = repositoryConfigType;
    }

    @Override
    public Check.CheckType type() {
        return this.type;
    }

    @Override
    @jakarta.annotation.Nullable
    public NamedRef ref() {
        return this.ref;
    }

    @Override
    @jakarta.annotation.Nullable
    public ContentKey key() {
        return this.key;
    }

    @Override
    @jakarta.annotation.Nullable
    public String contentId() {
        return this.contentId;
    }

    @Override
    @jakarta.annotation.Nullable
    public Content.Type contentType() {
        return this.contentType;
    }

    @Override
    @jakarta.annotation.Nullable
    public IdentifiedContentKey identifiedKey() {
        return this.identifiedKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public RepositoryConfig.Type repositoryConfigType() {
        return this.repositoryConfigType;
    }

    public final ImmutableCheck withType(Check.CheckType value) {
        Check.CheckType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableCheck(this, newValue, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType);
    }

    public final ImmutableCheck withRef(@jakarta.annotation.Nullable NamedRef value) {
        if (this.ref == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, value, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType);
    }

    public final ImmutableCheck withKey(@jakarta.annotation.Nullable ContentKey value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, value, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType);
    }

    public final ImmutableCheck withContentId(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.contentId, value)) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, value, this.contentType, this.identifiedKey, this.repositoryConfigType);
    }

    public final ImmutableCheck withContentType(@jakarta.annotation.Nullable Content.Type value) {
        if (this.contentType == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, value, this.identifiedKey, this.repositoryConfigType);
    }

    public final ImmutableCheck withIdentifiedKey(@jakarta.annotation.Nullable IdentifiedContentKey value) {
        if (this.identifiedKey == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, value, this.repositoryConfigType);
    }

    public final ImmutableCheck withRepositoryConfigType(@jakarta.annotation.Nullable RepositoryConfig.Type value) {
        if (this.repositoryConfigType == value) {
            return this;
        }
        return new ImmutableCheck(this, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalTo(0, (ImmutableCheck)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheck another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.ref, another.ref) && Objects.equals(this.key, another.key) && Objects.equals(this.contentId, another.contentId) && Objects.equals(this.contentType, another.contentType) && Objects.equals(this.identifiedKey, another.identifiedKey) && Objects.equals(this.repositoryConfigType, another.repositoryConfigType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.contentId);
        h += (h << 5) + Objects.hashCode(this.contentType);
        h += (h << 5) + Objects.hashCode(this.identifiedKey);
        h += (h << 5) + Objects.hashCode(this.repositoryConfigType);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("type", (Object)this.type).add("ref", (Object)this.ref).add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("contentType", (Object)this.contentType).add("identifiedKey", (Object)this.identifiedKey).add("repositoryConfigType", (Object)this.repositoryConfigType).toString();
    }

    public static ImmutableCheck of(Check.CheckType type, @jakarta.annotation.Nullable NamedRef ref, @jakarta.annotation.Nullable ContentKey key, @jakarta.annotation.Nullable String contentId, @jakarta.annotation.Nullable Content.Type contentType, @jakarta.annotation.Nullable IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable RepositoryConfig.Type repositoryConfigType) {
        return new ImmutableCheck(type, ref, key, contentId, contentType, identifiedKey, repositoryConfigType);
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="Check", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Check.CheckType type;
        @Nullable
        private NamedRef ref;
        @Nullable
        private ContentKey key;
        @Nullable
        private String contentId;
        @Nullable
        private Content.Type contentType;
        @Nullable
        private IdentifiedContentKey identifiedKey;
        @Nullable
        private RepositoryConfig.Type repositoryConfigType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Check instance) {
            RepositoryConfig.Type repositoryConfigTypeValue;
            IdentifiedContentKey identifiedKeyValue;
            Content.Type contentTypeValue;
            String contentIdValue;
            ContentKey keyValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            NamedRef refValue = instance.ref();
            if (refValue != null) {
                this.ref(refValue);
            }
            if ((keyValue = instance.key()) != null) {
                this.key(keyValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            if ((contentTypeValue = instance.contentType()) != null) {
                this.contentType(contentTypeValue);
            }
            if ((identifiedKeyValue = instance.identifiedKey()) != null) {
                this.identifiedKey(identifiedKeyValue);
            }
            if ((repositoryConfigTypeValue = instance.repositoryConfigType()) != null) {
                this.repositoryConfigType(repositoryConfigTypeValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Check.CheckType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@jakarta.annotation.Nullable NamedRef ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(@jakarta.annotation.Nullable ContentKey key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@jakarta.annotation.Nullable String contentId) {
            this.contentId = contentId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(@jakarta.annotation.Nullable Content.Type contentType) {
            this.contentType = contentType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifiedKey(@jakarta.annotation.Nullable IdentifiedContentKey identifiedKey) {
            this.identifiedKey = identifiedKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryConfigType(@jakarta.annotation.Nullable RepositoryConfig.Type repositoryConfigType) {
            this.repositoryConfigType = repositoryConfigType;
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheck(null, this.type, this.ref, this.key, this.contentId, this.contentType, this.identifiedKey, this.repositoryConfigType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Check, some of required attributes are not set " + attributes;
        }
    }
}

