/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.AuthzPaginationIterator;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.hash.HashValidator;
import org.projectnessie.services.hash.ResolvedHash;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.paging.PaginationIterator;

public class DiffApiImpl
extends BaseApiImpl
implements DiffService {
    public DiffApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Supplier<Principal> principal) {
        super(config, store, authorizer, principal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R getDiff(String fromRef, String fromHash, String toRef, String toHash, String pagingToken, PagedResponseHandler<R, DiffResponse.DiffEntry> pagedResponseHandler, Consumer<WithHash<NamedRef>> fromReference, Consumer<WithHash<NamedRef>> toReference, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, List<ContentKey> requestedKeys, String filter) throws NessieNotFoundException {
        try {
            ResolvedHash from = this.getHashResolver().resolveHashOnRef(fromRef, fromHash, new HashValidator("\"From\" hash"));
            ResolvedHash to = this.getHashResolver().resolveHashOnRef(toRef, toHash, new HashValidator("\"To\" hash"));
            final NamedRef fromNamedRef = from.getNamedRef();
            final NamedRef toNamedRef = to.getNamedRef();
            fromReference.accept(from);
            toReference.accept(to);
            this.startAccessCheck().canViewReference(fromNamedRef).canViewReference(toNamedRef).checkAndThrow();
            BiPredicate<ContentKey, Content.Type> contentKeyPredicate = null;
            if (requestedKeys != null && !requestedKeys.isEmpty()) {
                HashSet<ContentKey> requestedKeysSet = new HashSet<ContentKey>(requestedKeys);
                contentKeyPredicate = (key, type) -> requestedKeysSet.contains(key);
            }
            if (!Strings.isNullOrEmpty((String)filter)) {
                Predicate<ContentKey> contentKeyFilter = DiffApiImpl.filterOnContentKey(filter);
                BiPredicate<ContentKey, Content.Type> filterPredicate = (key, type) -> contentKeyFilter.test((ContentKey)key);
                contentKeyPredicate = contentKeyPredicate != null ? contentKeyPredicate.and(filterPredicate) : filterPredicate;
            }
            try (PaginationIterator diffs = this.getStore().getDiffs((Ref)from.getHash(), (Ref)to.getHash(), pagingToken, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(minKey).maxKey(maxKey).prefixKey(prefixKey).contentKeyPredicate(contentKeyPredicate).build());){
                AuthzPaginationIterator authz = new AuthzPaginationIterator<Diff>(diffs, () -> super.startAccessCheck(), this.getServerConfig().accessChecksBatchSize()){

                    @Override
                    protected Set<Check> checksForEntry(Diff entry) {
                        if (entry.getFromValue().isPresent()) {
                            if (entry.getToValue().isPresent() && !Objects.equals(entry.getFromKey(), entry.getToKey())) {
                                return ImmutableSet.of((Object)Check.canReadContentKey(fromNamedRef, entry.getFromKey()), (Object)Check.canReadContentKey(fromNamedRef, entry.getToKey()));
                            }
                            return Collections.singleton(Check.canReadContentKey(fromNamedRef, entry.getFromKey()));
                        }
                        return Collections.singleton(Check.canReadContentKey(toNamedRef, entry.getToKey()));
                    }
                }.initialCheck(Check.canViewReference(fromNamedRef)).initialCheck(Check.canViewReference(toNamedRef));
                while (authz.hasNext()) {
                    Diff diff = (Diff)authz.next();
                    ContentKey key2 = diff.contentKey();
                    DiffResponse.DiffEntry entry = DiffResponse.DiffEntry.diffEntry((ContentKey)key2, (Content)diff.getFromValue().orElse(null), (Content)diff.getToValue().orElse(null));
                    if (pagedResponseHandler.addEntry(entry)) continue;
                    pagedResponseHandler.hasMore(authz.tokenForCurrent());
                    break;
                }
                R r = pagedResponseHandler.build();
                return r;
            }
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }
}

