/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.hash;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.hash.HashValidator;
import org.projectnessie.services.hash.ParsedHash;
import org.projectnessie.services.hash.ResolvedHash;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HashResolver {
    private final ServerConfig config;
    private final VersionStore store;

    public HashResolver(ServerConfig config, VersionStore store) {
        this.config = config;
        this.store = store;
    }

    public ResolvedHash resolveToHead(@Nullable String namedRef) throws ReferenceNotFoundException {
        Preconditions.checkArgument((namedRef == null || !namedRef.equals("DETACHED") ? 1 : 0) != 0, (Object)"Cannot resolve DETACHED to HEAD");
        return this.resolveHashOnRef(namedRef, null);
    }

    public ResolvedHash resolveHashOnRef(@Nullable String namedRef, @Nullable String hashOnRef) throws ReferenceNotFoundException {
        return this.resolveHashOnRef(namedRef, hashOnRef, HashValidator.DEFAULT);
    }

    public ResolvedHash resolveHashOnRef(@Nullable String namedRef, @Nullable String hashOnRef, HashValidator validator) throws ReferenceNotFoundException {
        DetachedRef ref;
        if (null == namedRef) {
            namedRef = this.config.getDefaultBranch();
        }
        Hash currentHead = null;
        if ("DETACHED".equals(namedRef)) {
            ref = DetachedRef.INSTANCE;
        } else {
            ReferenceInfo refInfo = this.store.getNamedRef(namedRef, GetNamedRefsParams.DEFAULT);
            ref = refInfo.getNamedRef();
            currentHead = refInfo.getHash();
        }
        return this.resolveHashOnRef((NamedRef)ref, currentHead, hashOnRef, validator);
    }

    public ResolvedHash resolveHashOnRef(ResolvedHash head, @Nullable String hashOnRef, HashValidator validator) throws ReferenceNotFoundException {
        return this.resolveHashOnRef(head.getNamedRef(), head.getHead().orElse(null), hashOnRef, validator);
    }

    public ResolvedHash resolveHashOnRef(NamedRef ref, @Nullable Hash currentHead, @Nullable String hashOnRef, HashValidator validator) throws ReferenceNotFoundException {
        Preconditions.checkState((currentHead != null || hashOnRef != null ? 1 : 0) != 0);
        Optional<ParsedHash> parsed = ParsedHash.parse(hashOnRef, this.store.noAncestorHash());
        validator.validate(ref, parsed.orElse(null));
        Hash resolved = parsed.flatMap(ParsedHash::getAbsolutePart).orElse(currentHead);
        Preconditions.checkState((resolved != null ? 1 : 0) != 0);
        List relativeParts = parsed.map(ParsedHash::getRelativeParts).orElse(Collections.emptyList());
        if (!relativeParts.isEmpty()) {
            resolved = this.store.hashOnReference((NamedRef)DetachedRef.INSTANCE, Optional.of(resolved), relativeParts);
        }
        return ResolvedHash.of(ref, Optional.ofNullable(currentHead), resolved);
    }
}

