/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.hash;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import org.projectnessie.services.hash.ParsedHash;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HashValidator {
    public static final HashValidator DEFAULT = new HashValidator();
    private final String refDescription;
    private final String hashDescription;
    private boolean refMustBeBranch;
    private boolean refMustBeBranchOrTag;
    private boolean hashMustBeUnambiguous;

    public HashValidator() {
        this("Hash");
    }

    public HashValidator(String hashDescription) {
        this("Reference", hashDescription);
    }

    public HashValidator(String refDescription, String hashDescription) {
        this.refDescription = refDescription;
        this.hashDescription = hashDescription;
    }

    public void validate(NamedRef namedRef, @Nullable ParsedHash parsed) {
        if (this.refMustBeBranch) {
            Preconditions.checkArgument((boolean)(namedRef instanceof BranchName), (String)"%s must be a branch.", (Object)this.refDescription);
        }
        if (this.refMustBeBranchOrTag) {
            Preconditions.checkArgument((namedRef instanceof BranchName || namedRef instanceof TagName ? 1 : 0) != 0, (String)"%s must be a branch or a tag.", (Object)this.refDescription);
        }
        if (this.hashMustBeUnambiguous || namedRef == DetachedRef.INSTANCE) {
            Preconditions.checkArgument((parsed != null ? 1 : 0) != 0, (String)"%s must be provided.", (Object)this.hashDescription);
            Preconditions.checkArgument((boolean)parsed.getAbsolutePart().isPresent(), (String)"%s must contain a starting commit ID.", (Object)this.hashDescription);
        }
    }

    @CanIgnoreReturnValue
    public HashValidator refMustBeBranch() {
        this.refMustBeBranch = true;
        return this;
    }

    @CanIgnoreReturnValue
    public HashValidator refMustBeBranchOrTag() {
        this.refMustBeBranchOrTag = true;
        return this;
    }

    @CanIgnoreReturnValue
    public HashValidator hashMustBeUnambiguous() {
        this.hashMustBeUnambiguous = true;
        return this;
    }
}

