/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.hash;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.services.hash.ParsedHash;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.RelativeCommitSpec;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParsedHash", generator="Immutables")
@Immutable
public final class ImmutableParsedHash
implements ParsedHash {
    @Nullable
    private final Hash absolutePart;
    private final ImmutableList<RelativeCommitSpec> relativeParts;

    private ImmutableParsedHash(@Nullable Hash absolutePart, ImmutableList<RelativeCommitSpec> relativeParts) {
        this.absolutePart = absolutePart;
        this.relativeParts = relativeParts;
    }

    @Override
    public Optional<Hash> getAbsolutePart() {
        return Optional.ofNullable(this.absolutePart);
    }

    public ImmutableList<RelativeCommitSpec> getRelativeParts() {
        return this.relativeParts;
    }

    public final ImmutableParsedHash withAbsolutePart(Hash value) {
        Hash newValue = Objects.requireNonNull(value, "absolutePart");
        if (this.absolutePart == newValue) {
            return this;
        }
        return new ImmutableParsedHash(newValue, this.relativeParts);
    }

    public final ImmutableParsedHash withAbsolutePart(Optional<? extends Hash> optional) {
        Hash value = optional.orElse(null);
        if (this.absolutePart == value) {
            return this;
        }
        return new ImmutableParsedHash(value, this.relativeParts);
    }

    public final ImmutableParsedHash withRelativeParts(RelativeCommitSpec ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableParsedHash(this.absolutePart, (ImmutableList<RelativeCommitSpec>)newValue);
    }

    public final ImmutableParsedHash withRelativeParts(Iterable<? extends RelativeCommitSpec> elements) {
        if (this.relativeParts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableParsedHash(this.absolutePart, (ImmutableList<RelativeCommitSpec>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParsedHash && this.equalTo(0, (ImmutableParsedHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableParsedHash another) {
        return Objects.equals(this.absolutePart, another.absolutePart) && this.relativeParts.equals(another.relativeParts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.absolutePart);
        h += (h << 5) + this.relativeParts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ParsedHash").omitNullValues().add("absolutePart", (Object)this.absolutePart).add("relativeParts", this.relativeParts).toString();
    }

    public static ImmutableParsedHash copyOf(ParsedHash instance) {
        if (instance instanceof ImmutableParsedHash) {
            return (ImmutableParsedHash)instance;
        }
        return ImmutableParsedHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ParsedHash", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Hash absolutePart;
        private ImmutableList.Builder<RelativeCommitSpec> relativeParts = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParsedHash instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Hash> absolutePartOptional = instance.getAbsolutePart();
            if (absolutePartOptional.isPresent()) {
                this.absolutePart(absolutePartOptional);
            }
            this.addAllRelativeParts(instance.getRelativeParts());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder absolutePart(Hash absolutePart) {
            this.absolutePart = Objects.requireNonNull(absolutePart, "absolutePart");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder absolutePart(Optional<? extends Hash> absolutePart) {
            this.absolutePart = absolutePart.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelativeParts(RelativeCommitSpec element) {
            this.relativeParts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRelativeParts(RelativeCommitSpec ... elements) {
            this.relativeParts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder relativeParts(Iterable<? extends RelativeCommitSpec> elements) {
            this.relativeParts = ImmutableList.builder();
            return this.addAllRelativeParts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRelativeParts(Iterable<? extends RelativeCommitSpec> elements) {
            this.relativeParts.addAll(elements);
            return this;
        }

        public ImmutableParsedHash build() {
            return new ImmutableParsedHash(this.absolutePart, this.relativeParts.build());
        }
    }
}

