/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.security.Principal;
import java.time.Instant;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.hash.HashResolver;
import org.projectnessie.versioned.DefaultMetadataRewriter;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.VersionStore;

public abstract class BaseApiImpl {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    private final AccessContext accessContext;
    private HashResolver hashResolver;

    protected BaseApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
        this.accessContext = accessContext;
    }

    static Predicate<ContentKey> filterOnContentKey(String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return x -> true;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.CONTENT_KEY_DECLARATIONS).withTypes(CELUtil.CONTENT_KEY_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return key -> {
            try {
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"key", (Object)CELUtil.forCel(key)));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected ServerConfig getServerConfig() {
        return this.config;
    }

    protected VersionStore getStore() {
        return this.store;
    }

    protected Principal getPrincipal() {
        return this.accessContext.user();
    }

    protected Authorizer getAuthorizer() {
        return this.authorizer;
    }

    protected HashResolver getHashResolver() {
        if (this.hashResolver == null) {
            this.hashResolver = new HashResolver(this.config, this.store);
        }
        return this.hashResolver;
    }

    protected BatchAccessChecker startAccessCheck() {
        return this.getAuthorizer().startAccessCheck(this.accessContext);
    }

    protected MetadataRewriter<CommitMeta> commitMetaUpdate(@Nullable CommitMeta commitMeta, IntFunction<String> squashMessage) {
        Principal principal = this.getPrincipal();
        String committer = principal == null ? "" : principal.getName();
        return new DefaultMetadataRewriter(committer, Instant.now(), commitMeta, squashMessage);
    }
}

