/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.cel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Decl;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type;
import org.projectnessie.cel.tools.ScriptHost;
import org.projectnessie.cel.types.jackson.JacksonRegistry;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

public final class CELUtil {
    public static final String CONTAINER = "org.projectnessie.model";
    public static final ScriptHost SCRIPT_HOST = ScriptHost.newBuilder().registry(JacksonRegistry.newRegistry()).build();
    public static final String VAR_REF = "ref";
    public static final String VAR_REF_TYPE = "refType";
    public static final String VAR_REF_META = "refMeta";
    public static final String VAR_COMMIT = "commit";
    public static final String VAR_KEY = "key";
    public static final String VAR_ENTRY = "entry";
    public static final String VAR_PATH = "path";
    public static final String VAR_ROLE = "role";
    public static final String VAR_ROLES = "roles";
    public static final String VAR_OP = "op";
    public static final String VAR_OPERATIONS = "operations";
    public static final List<Decl> REFERENCES_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"commit", (Type)Decls.newObjectType((String)CommitMeta.class.getName())), (Object)Decls.newVar((String)"ref", (Type)Decls.newObjectType((String)Reference.class.getName())), (Object)Decls.newVar((String)"refMeta", (Type)Decls.newObjectType((String)ReferenceMetadata.class.getName())), (Object)Decls.newVar((String)"refType", (Type)Decls.String));
    public static final List<Decl> COMMIT_LOG_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"commit", (Type)Decls.newObjectType((String)CommitMeta.class.getName())), (Object)Decls.newVar((String)"operations", (Type)Decls.newListType((Type)Decls.newObjectType((String)OperationForCel.class.getName()))));
    public static final List<Decl> CONTENT_KEY_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"key", (Type)Decls.newObjectType((String)KeyedEntityForCel.class.getName())));
    public static final List<Decl> ENTRIES_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"entry", (Type)Decls.newObjectType((String)KeyEntryForCel.class.getName())));
    public static final List<Decl> AUTHORIZATION_RULE_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"ref", (Type)Decls.String), (Object)Decls.newVar((String)"path", (Type)Decls.String), (Object)Decls.newVar((String)"role", (Type)Decls.String), (Object)Decls.newVar((String)"roles", (Type)Decls.newListType((Type)Decls.String)), (Object)Decls.newVar((String)"op", (Type)Decls.String));
    public static final List<Object> COMMIT_LOG_TYPES = ImmutableList.of(CommitMeta.class, OperationForCel.class, ContentKey.class, Namespace.class);
    public static final List<Object> CONTENT_KEY_TYPES = ImmutableList.of(KeyedEntityForCel.class);
    public static final List<Object> REFERENCES_TYPES = ImmutableList.of(CommitMeta.class, ReferenceMetadata.class, Reference.class);
    public static final List<Object> ENTRIES_TYPES = ImmutableList.of(KeyEntryForCel.class);
    public static final CommitMeta EMPTY_COMMIT_META = CommitMeta.fromMessage((String)"");
    public static final ReferenceMetadata EMPTY_REFERENCE_METADATA = ImmutableReferenceMetadata.builder().commitMetaOfHEAD(EMPTY_COMMIT_META).build();

    private CELUtil() {
    }

    public static Object forCel(Object model) {
        if (model instanceof Content) {
            return new ContentEntity((Content)model);
        }
        if (model instanceof Operation) {
            return new OperationForCelImpl((Operation)model);
        }
        if (model instanceof ContentKey) {
            return new KeyForCelImpl((ContentKey)model);
        }
        return model;
    }

    public static Object forCel(ContentKey key, Content.Type type) {
        return new KeyEntryForCelImpl(key, type);
    }

    private static class ContentEntity
    implements ContentForCel {
        private final Content content;

        private ContentEntity(Content content) {
            this.content = content;
        }

        @Override
        public String getType() {
            return this.content.getType().name();
        }

        @Override
        public String getId() {
            return this.content.getId();
        }
    }

    private static class OperationForCelImpl
    extends AbstractKeyedEntity
    implements OperationForCel {
        private final Operation op;

        OperationForCelImpl(Operation op) {
            this.op = op;
        }

        @Override
        protected ContentKey key() {
            return this.op.getKey();
        }

        @Override
        public String getType() {
            if (this.op instanceof Operation.Put) {
                return "PUT";
            }
            if (this.op instanceof Operation.Delete) {
                return "DELETE";
            }
            return "OPERATION";
        }

        @Override
        public ContentForCel getContent() {
            if (this.op instanceof Operation.Put) {
                return (ContentForCel)CELUtil.forCel(((Operation.Put)this.op).getContent());
            }
            return null;
        }

        public String toString() {
            return this.op.toString();
        }
    }

    private static class KeyForCelImpl
    extends AbstractKeyedEntity {
        private final ContentKey contentKey;

        KeyForCelImpl(ContentKey k) {
            this.contentKey = k;
        }

        @Override
        protected ContentKey key() {
            return this.contentKey;
        }

        public String toString() {
            return this.contentKey.toString();
        }
    }

    private static class KeyEntryForCelImpl
    extends AbstractKeyedEntity
    implements KeyEntryForCel {
        private final ContentKey key;
        private final Content.Type type;

        private KeyEntryForCelImpl(ContentKey key, Content.Type type) {
            this.key = key;
            this.type = type;
        }

        @Override
        protected ContentKey key() {
            return this.key;
        }

        @Override
        public String getContentType() {
            return this.type.name();
        }

        public String toString() {
            return "KeyEntryForCelImpl{key=" + this.key + ", type=" + this.type + "}";
        }
    }

    public static interface OperationForCel
    extends KeyedEntityForCel {
        public String getType();

        public ContentForCel getContent();
    }

    public static interface KeyedEntityForCel {
        public List<String> getKeyElements();

        public String getKey();

        public String getEncodedKey();

        public List<String> getNamespaceElements();

        public String getName();

        public String getNamespace();
    }

    public static interface KeyEntryForCel
    extends KeyedEntityForCel {
        public String getContentType();
    }

    private static abstract class AbstractKeyedEntity
    implements KeyedEntityForCel {
        private AbstractKeyedEntity() {
        }

        protected abstract ContentKey key();

        @Override
        public List<String> getKeyElements() {
            return this.key().getElements();
        }

        @Override
        public String getKey() {
            return this.key().toString();
        }

        @Override
        public String getEncodedKey() {
            return this.key().toPathString();
        }

        @Override
        public String getNamespace() {
            return this.key().getNamespace().name();
        }

        @Override
        public List<String> getNamespaceElements() {
            return this.key().getNamespace().getElements();
        }

        @Override
        public String getName() {
            return this.key().getName();
        }
    }

    public static interface ContentForCel {
        public String getType();

        public String getId();
    }
}

