/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.hash;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.immutables.value.Value;
import org.projectnessie.model.Validation;
import org.projectnessie.services.hash.ImmutableParsedHash;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.RelativeCommitSpec;

@Value.Immutable
public interface ParsedHash {
    public Optional<Hash> getAbsolutePart();

    public List<RelativeCommitSpec> getRelativeParts();

    public static ParsedHash of(Hash absolutePart) {
        return ImmutableParsedHash.builder().absolutePart(absolutePart).build();
    }

    public static ParsedHash of(RelativeCommitSpec ... relativeParts) {
        return ImmutableParsedHash.builder().addRelativeParts(relativeParts).build();
    }

    public static ParsedHash of(Hash absolutePart, RelativeCommitSpec ... relativeParts) {
        return ImmutableParsedHash.builder().absolutePart(absolutePart).addRelativeParts(relativeParts).build();
    }

    public static Optional<ParsedHash> parse(@Nullable String hashOrRelativeSpec, @Nonnull Hash noAncestorHash) {
        Objects.requireNonNull(noAncestorHash, "noAncestorHash");
        if (hashOrRelativeSpec == null || hashOrRelativeSpec.isEmpty()) {
            return Optional.empty();
        }
        Matcher matcher = Validation.HASH_OR_RELATIVE_COMMIT_SPEC_PATTERN.matcher(hashOrRelativeSpec);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.", (Object)hashOrRelativeSpec);
        Optional<Hash> absolutePart = Optional.ofNullable(matcher.group(1)).map(Hash::of).map(h -> h.equals(noAncestorHash) ? noAncestorHash : h);
        List relativePart = RelativeCommitSpec.parseRelativeSpecs((String)matcher.group(2));
        return Optional.of(ImmutableParsedHash.builder().absolutePart(absolutePart).relativeParts(relativePart).build());
    }
}

