/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.error.ContentKeyErrorDetails;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Validation;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.hash.ResolvedHash;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.spi.NamespaceService;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;

public class NamespaceApiImpl
extends BaseApiImpl
implements NamespaceService {
    public NamespaceApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, AccessContext accessContext) {
        super(config, store, authorizer, accessContext);
    }

    @Override
    public Namespace createNamespace(String refName, Namespace namespace) throws NessieReferenceNotFoundException {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (Object)"Namespace name must not be empty");
        try {
            ResolvedHash refWithHash = this.getHashResolver().resolveToHead(refName);
            try {
                Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, refWithHash.getHash());
                if (explicitlyCreatedNamespace.isPresent()) {
                    Namespace ignored = (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.otherContentAlreadyExistsException(namespace));
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
                if (this.getImplicitlyCreatedNamespace(namespace, refWithHash.getHash()).isPresent()) {
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ContentKey key = namespace.toContentKey();
            Operation.Put put = Operation.Put.of((ContentKey)key, (Content)namespace);
            Hash hash = this.commit(BranchName.of((String)refWithHash.getValue().getName()), "create namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put));
            Content content = this.getExplicitlyCreatedNamespace(namespace, hash).orElse(null);
            Preconditions.checkState((boolean)(content instanceof Namespace), (String)"Expected %s to return the created Namespace, but got %s", (Object)key, (Object)content);
            return (Namespace)content;
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteNamespace(String refName, Namespace namespaceToDelete) throws NessieReferenceNotFoundException, NessieNamespaceNotFoundException {
        try {
            ResolvedHash refWithHash = this.getHashResolver().resolveToHead(refName);
            Namespace namespace = this.getNamespace(namespaceToDelete, refWithHash.getHash());
            Operation.Delete delete = Operation.Delete.of((ContentKey)namespace.toContentKey());
            try (PaginationIterator keys = this.getStore().getKeys((Ref)refWithHash.getHash(), null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
                while (keys.hasNext()) {
                    KeyEntry k = (KeyEntry)keys.next();
                    if (!Namespace.of((List)k.getKey().contentKey().getElements()).isSameOrSubElementOf(namespaceToDelete) || Content.Type.NAMESPACE.equals((Object)k.getKey().type())) continue;
                    throw NamespaceApiImpl.namespaceNotEmptyException(namespaceToDelete);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.commit(BranchName.of((String)refWithHash.getValue().getName()), "delete namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)delete));
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public Namespace getNamespace(String refName, String hashOnRef, Namespace namespace) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            if (hashOnRef != null) {
                Validation.validateHash((String)hashOnRef);
            }
            ResolvedHash resolved = this.getHashResolver().resolveHashOnRef(refName, hashOnRef);
            return this.getNamespace(namespace, resolved.getHash());
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    private Namespace getNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException, NessieNamespaceNotFoundException {
        Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, hash);
        if (explicitlyCreatedNamespace.isPresent()) {
            return (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
        }
        return this.getImplicitlyCreatedNamespace(namespace, hash).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
    }

    @Override
    public GetNamespacesResponse getNamespaces(String refName, String hashOnRef, Namespace namespace) throws NessieReferenceNotFoundException {
        if (hashOnRef != null) {
            Validation.validateHash((String)hashOnRef);
        }
        try {
            ResolvedHash refWithHash = this.getHashResolver().resolveHashOnRef(refName, hashOnRef);
            HashSet explicitNamespaceKeys = new HashSet();
            HashMap implicitNamespaces = new HashMap();
            try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(namespace, refWithHash.getHash(), k -> true);){
                stream.forEach(namespaceKeyWithType -> {
                    if (Content.Type.NAMESPACE.equals((Object)namespaceKeyWithType.getKey().type())) {
                        explicitNamespaceKeys.add(namespaceKeyWithType.getKey().contentKey());
                    } else {
                        Namespace implicitNamespace = NamespaceApiImpl.namespaceFromType(namespaceKeyWithType);
                        if (!implicitNamespace.isEmpty()) {
                            implicitNamespaces.put(implicitNamespace.getElements(), implicitNamespace);
                        }
                    }
                });
            }
            ImmutableGetNamespacesResponse.Builder response = GetNamespacesResponse.builder().effectiveReference(RefUtil.toReference(refWithHash.getValue(), refWithHash.getHash()));
            if (!explicitNamespaceKeys.isEmpty()) {
                Map namespaceValues = this.getStore().getValues((Ref)refWithHash.getHash(), explicitNamespaceKeys, false);
                namespaceValues.values().stream().map(ContentResult::content).filter(Namespace.class::isInstance).map(Namespace.class::cast).peek(explicitNamespace -> implicitNamespaces.remove(explicitNamespace.getElements())).forEach(arg_0 -> ((ImmutableGetNamespacesResponse.Builder)response).addNamespaces(arg_0));
            }
            response.addAllNamespaces(implicitNamespaces.values());
            return response.build();
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    @Override
    public void updateProperties(String refName, Namespace namespaceToUpdate, Map<String, String> propertyUpdates, Set<String> propertyRemovals) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            ResolvedHash refWithHash = this.getHashResolver().resolveToHead(refName);
            Namespace namespace = this.getNamespace(namespaceToUpdate, refWithHash.getHash());
            HashMap<String, String> properties = new HashMap<String, String>(namespace.getProperties());
            if (null != propertyRemovals) {
                propertyRemovals.forEach(properties::remove);
            }
            if (null != propertyUpdates) {
                properties.putAll(propertyUpdates);
            }
            ImmutableNamespace updatedNamespace = ImmutableNamespace.copyOf((Namespace)namespace).withProperties(properties);
            Operation.Put put = Operation.Put.of((ContentKey)updatedNamespace.toContentKey(), (Content)updatedNamespace);
            this.commit(BranchName.of((String)refWithHash.getValue().getName()), "update properties for namespace " + updatedNamespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put));
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @MustBeClosed
    private Stream<KeyEntry> getNamespacesKeyStream(@Nullable Namespace namespace, Hash hash, Predicate<KeyEntry> earlyFilterPredicate) throws ReferenceNotFoundException {
        PaginationIterator iter = this.getStore().getKeys((Ref)hash, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);
        return ((Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false).onClose(() -> ((PaginationIterator)iter).close())).filter(earlyFilterPredicate).filter(k -> null == namespace || NamespaceApiImpl.namespaceFromType(k).isSameOrSubElementOf(namespace));
    }

    private static Namespace namespaceFromType(KeyEntry withType) {
        List elements = withType.getKey().contentKey().getElements();
        if (!Content.Type.NAMESPACE.equals((Object)withType.getKey().type())) {
            elements = elements.subList(0, elements.size() - 1);
        }
        return Namespace.of((List)elements);
    }

    private Optional<Content> getExplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        return Optional.ofNullable(this.getStore().getValue((Ref)hash, namespace.toContentKey(), false)).map(ContentResult::content);
    }

    private Optional<Namespace> getImplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(namespace, hash, k -> true);){
            Optional<Namespace> optional = stream.findAny().map(NamespaceApiImpl::namespaceFromType);
            return optional;
        }
    }

    private static NessieNamespaceAlreadyExistsException namespaceAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)namespace.toContentKey()), String.format("Namespace '%s' already exists", namespace));
    }

    private static NessieNamespaceAlreadyExistsException otherContentAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)namespace.toContentKey()), String.format("Another content object with name '%s' already exists", namespace));
    }

    private static NessieNamespaceNotFoundException namespaceDoesNotExistException(Namespace namespace) {
        return new NessieNamespaceNotFoundException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)namespace.toContentKey()), String.format("Namespace '%s' does not exist", namespace));
    }

    private static NessieNamespaceNotEmptyException namespaceNotEmptyException(Namespace namespace) {
        return new NessieNamespaceNotEmptyException(ContentKeyErrorDetails.contentKeyErrorDetails((ContentKey)namespace.toContentKey()), String.format("Namespace '%s' is not empty", namespace));
    }

    private static NessieReferenceNotFoundException refNotFoundException(ReferenceNotFoundException e) {
        return new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
    }

    private Hash commit(BranchName branch, String commitMsg, Operation contentOperation) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.getStore().commit(branch, Optional.empty(), (CommitMeta)this.commitMetaUpdate(null, numCommits -> null).rewriteSingle((Object)CommitMeta.fromMessage((String)commitMsg)), Collections.singletonList(contentOperation), validation -> {
            BatchAccessChecker check = this.startAccessCheck().canCommitChangeAgainstReference((NamedRef)branch);
            validation.operations().forEach(op -> {
                switch (op.operationType()) {
                    case CREATE: {
                        check.canCreateEntity((NamedRef)branch, op.identifiedKey());
                        break;
                    }
                    case UPDATE: {
                        check.canUpdateEntity((NamedRef)branch, op.identifiedKey());
                        break;
                    }
                    case DELETE: {
                        check.canDeleteEntity((NamedRef)branch, op.identifiedKey());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown operation type " + op.operationType());
                    }
                }
            });
            check.checkAndThrow();
        }, (k, c) -> {}).getCommitHash();
    }
}

