/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.storage.uri;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StorageUri
implements Comparable<StorageUri> {
    public static final String SCHEME_FILE = "file";
    public static final Comparator<StorageUri> COMPARATOR = Comparator.comparing(u -> StorageUri.normalizedForCompare(u.scheme)).thenComparing(u -> StorageUri.normalizedForCompare(u.authority)).thenComparing(u -> StorageUri.normalizedForCompare(u.path));
    private final String scheme;
    private final String authority;
    private final String path;

    private StorageUri(String location) {
        this.scheme = StorageUri.scheme(location);
        if (this.scheme != null) {
            String schemeSpecific = location.substring(this.scheme.length() + 1);
            if (schemeSpecific.startsWith("//")) {
                int pathPos = schemeSpecific.indexOf(47, 2);
                if (pathPos < 0) {
                    this.authority = StorageUri.emptyToNull(schemeSpecific.substring(2));
                    this.path = null;
                } else {
                    this.authority = StorageUri.emptyToNull(schemeSpecific.substring(2, pathPos));
                    this.path = StorageUri.normalizedPath(schemeSpecific.substring(pathPos));
                }
            } else {
                this.authority = null;
                this.path = StorageUri.normalizedPath(schemeSpecific);
            }
        } else {
            this.authority = null;
            this.path = StorageUri.normalizedPath(location);
        }
    }

    private StorageUri(String scheme, String authority, String path) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
    }

    public String location() {
        StringBuilder location = new StringBuilder();
        if (this.scheme != null) {
            location.append(this.scheme);
            location.append(':');
        }
        if (this.authority != null) {
            location.append("//");
            location.append(this.authority);
        }
        if (this.path != null) {
            location.append(this.path);
        }
        return location.toString();
    }

    public static StorageUri of(String location) {
        return new StorageUri(location);
    }

    public static StorageUri of(URI uri) {
        return StorageUri.of(uri.toString());
    }

    public String toString() {
        return this.location();
    }

    @Nullable
    private static String scheme(String location) {
        int schemePos = location.indexOf(58);
        if (schemePos > 0) {
            return location.substring(0, schemePos).toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @Nullable
    public String scheme() {
        return this.scheme;
    }

    @Nullable
    public String authority() {
        return this.authority;
    }

    @Nonnull
    public String requiredAuthority() {
        return (String)Preconditions.checkNotNull((Object)this.authority, (String)"Missing required authority in storage location: %s", (Object)this);
    }

    @Nullable
    public String path() {
        return this.path;
    }

    @Nonnull
    public String requiredPath() {
        return (String)Preconditions.checkNotNull((Object)this.path, (String)"Missing required path in storage location: %s", (Object)this);
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public StorageUri withTrailingSeparator() {
        if (this.path == null) {
            return new StorageUri(this.scheme, this.authority, "/");
        }
        if (!this.path.endsWith("/")) {
            return new StorageUri(this.scheme, this.authority, this.path + "/");
        }
        return this;
    }

    @Override
    public int compareTo(@Nonnull StorageUri other) {
        return COMPARATOR.compare(this, other);
    }

    public int hashCode() {
        int h = 1;
        h = 31 * h + (this.scheme == null ? 0 : this.scheme.hashCode());
        h = 31 * h + (this.authority == null ? 0 : this.authority.hashCode());
        h = 31 * h + (this.path == null ? 0 : this.path.hashCode());
        return h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StorageUri)) {
            return false;
        }
        StorageUri o = (StorageUri)other;
        return Objects.equals(this.scheme, o.scheme) && Objects.equals(this.authority, o.authority) && Objects.equals(this.path, o.path);
    }

    private static String normalizedForCompare(String value) {
        return value == null ? "" : value;
    }

    private static String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private static String normalizedPath(String loc) {
        StringBuilder norm = new StringBuilder(loc.length());
        int pos = 0;
        while (pos < loc.length()) {
            int idx = loc.indexOf(47, pos);
            idx = idx < 0 ? loc.length() : ++idx;
            norm.append(loc, pos, idx);
            while (idx < loc.length() && loc.charAt(idx) == '/') {
                ++idx;
            }
            pos = idx;
        }
        return norm.toString();
    }

    public StorageUri relativize(StorageUri child) {
        String base;
        if (!Objects.equals(this.scheme, child.scheme) || !Objects.equals(this.authority, child.authority)) {
            return child;
        }
        String nested = child.path == null ? "/" : child.path;
        String string = base = this.path == null ? "/" : this.path;
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        if (!nested.startsWith(base)) {
            return child;
        }
        String rel = nested.substring(base.length());
        return StorageUri.of(rel);
    }

    public StorageUri relativize(String subLocation) {
        return this.relativize(StorageUri.of(subLocation));
    }

    public StorageUri resolve(StorageUri rel) {
        if (rel.scheme() != null) {
            return rel;
        }
        Preconditions.checkArgument((!StorageUri.normalizedForCompare(rel.path).startsWith(".") ? 1 : 0) != 0, (String)"Parent and self-references are not supported: %s", (Object)rel.path);
        if (rel.path.startsWith("/")) {
            return new StorageUri(this.scheme, this.authority, rel.path);
        }
        if (this.path == null) {
            return new StorageUri(this.scheme, this.authority, "/" + rel.path);
        }
        if (!this.path.startsWith("/")) {
            return rel;
        }
        if (this.path.endsWith("/")) {
            return new StorageUri(this.scheme, this.authority, this.path + rel.path);
        }
        int pos = this.path.lastIndexOf(47);
        String basePath = this.path.substring(0, pos + 1);
        return new StorageUri(this.scheme, this.authority, basePath + rel.path);
    }

    public StorageUri resolve(String subPath) {
        return this.resolve(StorageUri.of(subPath));
    }
}

