/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.protobuf.ByteString;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@Value.Immutable
public interface CommitLogEntry {
    public long getCreatedTime();

    public Hash getHash();

    public long getCommitSeq();

    public List<Hash> getParents();

    public ByteString getMetadata();

    public List<KeyWithBytes> getPuts();

    public List<Key> getDeletes();

    @Nullable
    @jakarta.annotation.Nullable
    public KeyList getKeyList();

    public List<Hash> getKeyListsIds();

    @Nullable
    @jakarta.annotation.Nullable
    public List<Integer> getKeyListEntityOffsets();

    @Nullable
    @jakarta.annotation.Nullable
    public Float getKeyListLoadFactor();

    @Nullable
    @jakarta.annotation.Nullable
    public Integer getKeyListBucketCount();

    public int getKeyListDistance();

    public List<Hash> getAdditionalParents();

    @Value.Default
    default public KeyListVariant getKeyListVariant() {
        return KeyListVariant.EMBEDDED_AND_EXTERNAL_MRU;
    }

    default public boolean hasKeySummary() {
        return this.getKeyListVariant() != KeyListVariant.EMBEDDED_AND_EXTERNAL_MRU || this.getKeyList() != null;
    }

    public static CommitLogEntry of(long createdTime, Hash hash, long commitSeq, Iterable<Hash> parents, ByteString metadata, Iterable<KeyWithBytes> puts, Iterable<Key> deletes, int keyListDistance, KeyList keyList, Iterable<Hash> keyListIds, Iterable<Integer> keyListEntityOffsets, Iterable<Hash> additionalParents) {
        ImmutableCommitLogEntry.Builder c = ImmutableCommitLogEntry.builder().createdTime(createdTime).hash(hash).commitSeq(commitSeq).parents(parents).metadata(metadata).puts(puts).deletes(deletes).keyListDistance(keyListDistance).keyList(keyList).addAllKeyListsIds(keyListIds).addAllAdditionalParents(additionalParents);
        if (keyListEntityOffsets != null) {
            c.addAllKeyListEntityOffsets(keyListEntityOffsets);
        }
        return c.build();
    }

    public static enum KeyListVariant {
        EMBEDDED_AND_EXTERNAL_MRU,
        OPEN_ADDRESSING;

    }
}

