/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitLogEntry", generator="Immutables")
@Immutable
public final class ImmutableCommitLogEntry
implements CommitLogEntry {
    private final long createdTime;
    private final Hash hash;
    private final long commitSeq;
    private final ImmutableList<Hash> parents;
    private final ByteString metadata;
    private final ImmutableList<KeyWithBytes> puts;
    private final ImmutableList<Key> deletes;
    @Nullable
    private final KeyList keyList;
    private final ImmutableList<Hash> keyListsIds;
    @Nullable
    private final ImmutableList<Integer> keyListEntityOffsets;
    @Nullable
    private final Float keyListLoadFactor;
    @Nullable
    private final Integer keyListBucketCount;
    private final int keyListDistance;
    private final ImmutableList<Hash> additionalParents;
    private final CommitLogEntry.KeyListVariant keyListVariant;

    private ImmutableCommitLogEntry(Builder builder) {
        this.createdTime = builder.createdTime;
        this.hash = builder.hash;
        this.commitSeq = builder.commitSeq;
        this.parents = builder.parents.build();
        this.metadata = builder.metadata;
        this.puts = builder.puts.build();
        this.deletes = builder.deletes.build();
        this.keyList = builder.keyList;
        this.keyListsIds = builder.keyListsIds.build();
        this.keyListEntityOffsets = builder.keyListEntityOffsets == null ? null : builder.keyListEntityOffsets.build();
        this.keyListLoadFactor = builder.keyListLoadFactor;
        this.keyListBucketCount = builder.keyListBucketCount;
        this.keyListDistance = builder.keyListDistance;
        this.additionalParents = builder.additionalParents.build();
        this.keyListVariant = builder.keyListVariant != null ? builder.keyListVariant : Objects.requireNonNull(CommitLogEntry.super.getKeyListVariant(), "keyListVariant");
    }

    private ImmutableCommitLogEntry(long createdTime, Hash hash, long commitSeq, ImmutableList<Hash> parents, ByteString metadata, ImmutableList<KeyWithBytes> puts, ImmutableList<Key> deletes, @Nullable KeyList keyList, ImmutableList<Hash> keyListsIds, @Nullable ImmutableList<Integer> keyListEntityOffsets, @Nullable Float keyListLoadFactor, @Nullable Integer keyListBucketCount, int keyListDistance, ImmutableList<Hash> additionalParents, CommitLogEntry.KeyListVariant keyListVariant) {
        this.createdTime = createdTime;
        this.hash = hash;
        this.commitSeq = commitSeq;
        this.parents = parents;
        this.metadata = metadata;
        this.puts = puts;
        this.deletes = deletes;
        this.keyList = keyList;
        this.keyListsIds = keyListsIds;
        this.keyListEntityOffsets = keyListEntityOffsets;
        this.keyListLoadFactor = keyListLoadFactor;
        this.keyListBucketCount = keyListBucketCount;
        this.keyListDistance = keyListDistance;
        this.additionalParents = additionalParents;
        this.keyListVariant = keyListVariant;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public long getCommitSeq() {
        return this.commitSeq;
    }

    public ImmutableList<Hash> getParents() {
        return this.parents;
    }

    @Override
    public ByteString getMetadata() {
        return this.metadata;
    }

    public ImmutableList<KeyWithBytes> getPuts() {
        return this.puts;
    }

    public ImmutableList<Key> getDeletes() {
        return this.deletes;
    }

    @Override
    @Nullable
    public KeyList getKeyList() {
        return this.keyList;
    }

    public ImmutableList<Hash> getKeyListsIds() {
        return this.keyListsIds;
    }

    @Nullable
    public ImmutableList<Integer> getKeyListEntityOffsets() {
        return this.keyListEntityOffsets;
    }

    @Override
    @Nullable
    public Float getKeyListLoadFactor() {
        return this.keyListLoadFactor;
    }

    @Override
    @Nullable
    public Integer getKeyListBucketCount() {
        return this.keyListBucketCount;
    }

    @Override
    public int getKeyListDistance() {
        return this.keyListDistance;
    }

    public ImmutableList<Hash> getAdditionalParents() {
        return this.additionalParents;
    }

    @Override
    public CommitLogEntry.KeyListVariant getKeyListVariant() {
        return this.keyListVariant;
    }

    public final ImmutableCommitLogEntry withCreatedTime(long value) {
        if (this.createdTime == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(value, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableCommitLogEntry(this.createdTime, newValue, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withCommitSeq(long value) {
        if (this.commitSeq == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, value, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withParents(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, (ImmutableList<Hash>)newValue, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withParents(Iterable<? extends Hash> elements) {
        if (this.parents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, (ImmutableList<Hash>)newValue, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withMetadata(ByteString value) {
        if (this.metadata == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, newValue, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withPuts(KeyWithBytes ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, (ImmutableList<KeyWithBytes>)newValue, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withPuts(Iterable<? extends KeyWithBytes> elements) {
        if (this.puts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, (ImmutableList<KeyWithBytes>)newValue, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withDeletes(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, (ImmutableList<Key>)newValue, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withDeletes(Iterable<? extends Key> elements) {
        if (this.deletes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, (ImmutableList<Key>)newValue, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyList(@Nullable KeyList value) {
        if (this.keyList == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, value, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListsIds(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, (ImmutableList<Hash>)newValue, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListsIds(Iterable<? extends Hash> elements) {
        if (this.keyListsIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, (ImmutableList<Hash>)newValue, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListEntityOffsets(int ... elements) {
        if (elements == null) {
            return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, null, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
        }
        ImmutableList newValue = Ints.asList((int[])elements) == null ? null : ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, (ImmutableList<Integer>)newValue, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListEntityOffsets(@Nullable Iterable<Integer> elements) {
        if (this.keyListEntityOffsets == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, (ImmutableList<Integer>)newValue, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListLoadFactor(@Nullable Float value) {
        if (Objects.equals(this.keyListLoadFactor, value)) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, value, this.keyListBucketCount, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListBucketCount(@Nullable Integer value) {
        if (Objects.equals(this.keyListBucketCount, value)) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, value, this.keyListDistance, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListDistance(int value) {
        if (this.keyListDistance == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, value, this.additionalParents, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withAdditionalParents(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, (ImmutableList<Hash>)newValue, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withAdditionalParents(Iterable<? extends Hash> elements) {
        if (this.additionalParents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, (ImmutableList<Hash>)newValue, this.keyListVariant);
    }

    public final ImmutableCommitLogEntry withKeyListVariant(CommitLogEntry.KeyListVariant value) {
        CommitLogEntry.KeyListVariant newValue = Objects.requireNonNull(value, "keyListVariant");
        if (this.keyListVariant == newValue) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.commitSeq, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListEntityOffsets, this.keyListLoadFactor, this.keyListBucketCount, this.keyListDistance, this.additionalParents, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitLogEntry && this.equalTo(0, (ImmutableCommitLogEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitLogEntry another) {
        return this.createdTime == another.createdTime && this.hash.equals(another.hash) && this.commitSeq == another.commitSeq && this.parents.equals(another.parents) && this.metadata.equals((Object)another.metadata) && this.puts.equals(another.puts) && this.deletes.equals(another.deletes) && Objects.equals(this.keyList, another.keyList) && this.keyListsIds.equals(another.keyListsIds) && Objects.equals(this.keyListEntityOffsets, another.keyListEntityOffsets) && Objects.equals(this.keyListLoadFactor, another.keyListLoadFactor) && Objects.equals(this.keyListBucketCount, another.keyListBucketCount) && this.keyListDistance == another.keyListDistance && this.additionalParents.equals(another.additionalParents) && this.keyListVariant.equals((Object)another.keyListVariant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.createdTime);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.commitSeq);
        h += (h << 5) + this.parents.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.puts.hashCode();
        h += (h << 5) + this.deletes.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyList);
        h += (h << 5) + this.keyListsIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyListEntityOffsets);
        h += (h << 5) + Objects.hashCode(this.keyListLoadFactor);
        h += (h << 5) + Objects.hashCode(this.keyListBucketCount);
        h += (h << 5) + this.keyListDistance;
        h += (h << 5) + this.additionalParents.hashCode();
        h += (h << 5) + this.keyListVariant.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitLogEntry").omitNullValues().add("createdTime", this.createdTime).add("hash", (Object)this.hash).add("commitSeq", this.commitSeq).add("parents", this.parents).add("metadata", (Object)this.metadata).add("puts", this.puts).add("deletes", this.deletes).add("keyList", (Object)this.keyList).add("keyListsIds", this.keyListsIds).add("keyListEntityOffsets", this.keyListEntityOffsets).add("keyListLoadFactor", (Object)this.keyListLoadFactor).add("keyListBucketCount", (Object)this.keyListBucketCount).add("keyListDistance", this.keyListDistance).add("additionalParents", this.additionalParents).add("keyListVariant", (Object)this.keyListVariant).toString();
    }

    public static ImmutableCommitLogEntry copyOf(CommitLogEntry instance) {
        if (instance instanceof ImmutableCommitLogEntry) {
            return (ImmutableCommitLogEntry)instance;
        }
        return ImmutableCommitLogEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitLogEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATED_TIME = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_COMMIT_SEQ = 4L;
        private static final long INIT_BIT_METADATA = 8L;
        private static final long INIT_BIT_KEY_LIST_DISTANCE = 16L;
        private long initBits = 31L;
        private long createdTime;
        @javax.annotation.Nullable
        private Hash hash;
        private long commitSeq;
        private ImmutableList.Builder<Hash> parents = ImmutableList.builder();
        @javax.annotation.Nullable
        private ByteString metadata;
        private ImmutableList.Builder<KeyWithBytes> puts = ImmutableList.builder();
        private ImmutableList.Builder<Key> deletes = ImmutableList.builder();
        @javax.annotation.Nullable
        private KeyList keyList;
        private ImmutableList.Builder<Hash> keyListsIds = ImmutableList.builder();
        private ImmutableList.Builder<Integer> keyListEntityOffsets = null;
        @javax.annotation.Nullable
        private Float keyListLoadFactor;
        @javax.annotation.Nullable
        private Integer keyListBucketCount;
        private int keyListDistance;
        private ImmutableList.Builder<Hash> additionalParents = ImmutableList.builder();
        @javax.annotation.Nullable
        private CommitLogEntry.KeyListVariant keyListVariant;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitLogEntry instance) {
            Integer keyListBucketCountValue;
            Float keyListLoadFactorValue;
            Objects.requireNonNull(instance, "instance");
            this.createdTime(instance.getCreatedTime());
            this.hash(instance.getHash());
            this.commitSeq(instance.getCommitSeq());
            this.addAllParents(instance.getParents());
            this.metadata(instance.getMetadata());
            this.addAllPuts(instance.getPuts());
            this.addAllDeletes(instance.getDeletes());
            KeyList keyListValue = instance.getKeyList();
            if (keyListValue != null) {
                this.keyList(keyListValue);
            }
            this.addAllKeyListsIds(instance.getKeyListsIds());
            List<Integer> keyListEntityOffsetsValue = instance.getKeyListEntityOffsets();
            if (keyListEntityOffsetsValue != null) {
                this.addAllKeyListEntityOffsets(keyListEntityOffsetsValue);
            }
            if ((keyListLoadFactorValue = instance.getKeyListLoadFactor()) != null) {
                this.keyListLoadFactor(keyListLoadFactorValue);
            }
            if ((keyListBucketCountValue = instance.getKeyListBucketCount()) != null) {
                this.keyListBucketCount(keyListBucketCountValue);
            }
            this.keyListDistance(instance.getKeyListDistance());
            this.addAllAdditionalParents(instance.getAdditionalParents());
            this.keyListVariant(instance.getKeyListVariant());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdTime(long createdTime) {
            this.createdTime = createdTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitSeq(long commitSeq) {
            this.commitSeq = commitSeq;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(Hash element) {
            this.parents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(Hash ... elements) {
            this.parents.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parents(Iterable<? extends Hash> elements) {
            this.parents = ImmutableList.builder();
            return this.addAllParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParents(Iterable<? extends Hash> elements) {
            this.parents.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(ByteString metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes element) {
            this.puts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes ... elements) {
            this.puts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder puts(Iterable<? extends KeyWithBytes> elements) {
            this.puts = ImmutableList.builder();
            return this.addAllPuts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPuts(Iterable<? extends KeyWithBytes> elements) {
            this.puts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key element) {
            this.deletes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key ... elements) {
            this.deletes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletes(Iterable<? extends Key> elements) {
            this.deletes = ImmutableList.builder();
            return this.addAllDeletes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeletes(Iterable<? extends Key> elements) {
            this.deletes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyList(@Nullable KeyList keyList) {
            this.keyList = keyList;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListsIds(Hash element) {
            this.keyListsIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListsIds(Hash ... elements) {
            this.keyListsIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListsIds(Iterable<? extends Hash> elements) {
            this.keyListsIds = ImmutableList.builder();
            return this.addAllKeyListsIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyListsIds(Iterable<? extends Hash> elements) {
            this.keyListsIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListEntityOffsets(int element) {
            if (this.keyListEntityOffsets == null) {
                this.keyListEntityOffsets = ImmutableList.builder();
            }
            this.keyListEntityOffsets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListEntityOffsets(int ... elements) {
            if (this.keyListEntityOffsets == null) {
                this.keyListEntityOffsets = ImmutableList.builder();
            }
            this.keyListEntityOffsets.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListEntityOffsets(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.keyListEntityOffsets = null;
                return this;
            }
            this.keyListEntityOffsets = ImmutableList.builder();
            return this.addAllKeyListEntityOffsets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyListEntityOffsets(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "keyListEntityOffsets element");
            if (this.keyListEntityOffsets == null) {
                this.keyListEntityOffsets = ImmutableList.builder();
            }
            this.keyListEntityOffsets.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListLoadFactor(@Nullable Float keyListLoadFactor) {
            this.keyListLoadFactor = keyListLoadFactor;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListBucketCount(@Nullable Integer keyListBucketCount) {
            this.keyListBucketCount = keyListBucketCount;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalParents(Hash element) {
            this.additionalParents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdditionalParents(Hash ... elements) {
            this.additionalParents.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder additionalParents(Iterable<? extends Hash> elements) {
            this.additionalParents = ImmutableList.builder();
            return this.addAllAdditionalParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdditionalParents(Iterable<? extends Hash> elements) {
            this.additionalParents.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListVariant(CommitLogEntry.KeyListVariant keyListVariant) {
            this.keyListVariant = Objects.requireNonNull(keyListVariant, "keyListVariant");
            return this;
        }

        public ImmutableCommitLogEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitLogEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commitSeq");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("keyListDistance");
            }
            return "Cannot build CommitLogEntry, some of required attributes are not set " + attributes;
        }
    }
}

