/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.Difference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Difference", generator="Immutables")
@Immutable
public final class ImmutableDifference
implements Difference {
    private final byte payload;
    private final Key key;
    @Nullable
    private final ByteString fromValue;
    @Nullable
    private final ByteString toValue;
    @Nullable
    private final ByteString global;

    private ImmutableDifference(byte payload, Key key, Optional<? extends ByteString> fromValue, Optional<? extends ByteString> toValue, Optional<? extends ByteString> global) {
        this.payload = payload;
        this.key = Objects.requireNonNull(key, "key");
        this.fromValue = fromValue.orElse(null);
        this.toValue = toValue.orElse(null);
        this.global = global.orElse(null);
    }

    private ImmutableDifference(ImmutableDifference original, byte payload, Key key, @Nullable ByteString fromValue, @Nullable ByteString toValue, @Nullable ByteString global) {
        this.payload = payload;
        this.key = key;
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.global = global;
    }

    @Override
    public byte getPayload() {
        return this.payload;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Optional<ByteString> getFromValue() {
        return Optional.ofNullable(this.fromValue);
    }

    @Override
    public Optional<ByteString> getToValue() {
        return Optional.ofNullable(this.toValue);
    }

    @Override
    public Optional<ByteString> getGlobal() {
        return Optional.ofNullable(this.global);
    }

    public final ImmutableDifference withPayload(byte value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableDifference(this, value, this.key, this.fromValue, this.toValue, this.global);
    }

    public final ImmutableDifference withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDifference(this, this.payload, newValue, this.fromValue, this.toValue, this.global);
    }

    public final ImmutableDifference withFromValue(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "fromValue");
        if (this.fromValue == newValue) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, newValue, this.toValue, this.global);
    }

    public final ImmutableDifference withFromValue(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.fromValue == value) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, value, this.toValue, this.global);
    }

    public final ImmutableDifference withToValue(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "toValue");
        if (this.toValue == newValue) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, this.fromValue, newValue, this.global);
    }

    public final ImmutableDifference withToValue(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.toValue == value) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, this.fromValue, value, this.global);
    }

    public final ImmutableDifference withGlobal(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "global");
        if (this.global == newValue) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, this.fromValue, this.toValue, newValue);
    }

    public final ImmutableDifference withGlobal(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.global == value) {
            return this;
        }
        return new ImmutableDifference(this, this.payload, this.key, this.fromValue, this.toValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDifference && this.equalTo(0, (ImmutableDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableDifference another) {
        return this.payload == another.payload && this.key.equals((Object)another.key) && Objects.equals(this.fromValue, another.fromValue) && Objects.equals(this.toValue, another.toValue) && Objects.equals(this.global, another.global);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Bytes.hashCode((byte)this.payload);
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromValue);
        h += (h << 5) + Objects.hashCode(this.toValue);
        h += (h << 5) + Objects.hashCode(this.global);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Difference").omitNullValues().add("payload", (int)this.payload).add("key", (Object)this.key).add("fromValue", (Object)this.fromValue).add("toValue", (Object)this.toValue).add("global", (Object)this.global).toString();
    }

    public static ImmutableDifference of(byte payload, Key key, Optional<? extends ByteString> fromValue, Optional<? extends ByteString> toValue, Optional<? extends ByteString> global) {
        return new ImmutableDifference(payload, key, fromValue, toValue, global);
    }

    public static ImmutableDifference copyOf(Difference instance) {
        if (instance instanceof ImmutableDifference) {
            return (ImmutableDifference)instance;
        }
        return ImmutableDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Difference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private long initBits = 3L;
        private byte payload;
        @Nullable
        private Key key;
        @Nullable
        private ByteString fromValue;
        @Nullable
        private ByteString toValue;
        @Nullable
        private ByteString global;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Difference instance) {
            Optional<ByteString> globalOptional;
            Optional<ByteString> toValueOptional;
            Objects.requireNonNull(instance, "instance");
            this.payload(instance.getPayload());
            this.key(instance.getKey());
            Optional<ByteString> fromValueOptional = instance.getFromValue();
            if (fromValueOptional.isPresent()) {
                this.fromValue(fromValueOptional);
            }
            if ((toValueOptional = instance.getToValue()).isPresent()) {
                this.toValue(toValueOptional);
            }
            if ((globalOptional = instance.getGlobal()).isPresent()) {
                this.global(globalOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(byte payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(ByteString fromValue) {
            this.fromValue = Objects.requireNonNull(fromValue, "fromValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Optional<? extends ByteString> fromValue) {
            this.fromValue = fromValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(ByteString toValue) {
            this.toValue = Objects.requireNonNull(toValue, "toValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Optional<? extends ByteString> toValue) {
            this.toValue = toValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(ByteString global) {
            this.global = Objects.requireNonNull(global, "global");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(Optional<? extends ByteString> global) {
            this.global = global.orElse(null);
            return this;
        }

        public ImmutableDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDifference(null, this.payload, this.key, this.fromValue, this.toValue, this.global);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Difference, some of required attributes are not set " + attributes;
        }
    }
}

