/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableKeyDetails;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.ImmutableReferenceInfo;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.spi.BatchSpliterator;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterMetrics;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.FetchValuesUsingOpenAddressing;
import org.projectnessie.versioned.persist.adapter.spi.KeyListBuildState;
import org.projectnessie.versioned.persist.adapter.spi.Traced;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseAdapter<OP_CONTEXT extends AutoCloseable, CONFIG extends DatabaseAdapterConfig>
implements DatabaseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDatabaseAdapter.class);
    protected static final String TAG_HASH = "hash";
    protected static final String TAG_COUNT = "count";
    protected final CONFIG config;
    protected static final StoreWorker STORE_WORKER = DefaultStoreWorker.instance();
    private final AdapterEventConsumer eventConsumer;
    public static final Hash NO_ANCESTOR = Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])DatabaseAdapterUtil.newHasher().putString((CharSequence)"empty", StandardCharsets.UTF_8).hash().asBytes()));
    protected static long COMMIT_LOG_HASH_SEED = 946928273206945677L;

    protected AbstractDatabaseAdapter(CONFIG config, AdapterEventConsumer eventConsumer) {
        Objects.requireNonNull(config, "config parameter must not be null");
        this.config = config;
        this.eventConsumer = eventConsumer;
    }

    public CONFIG getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public AdapterEventConsumer getEventConsumer() {
        return this.eventConsumer;
    }

    @VisibleForTesting
    public abstract OP_CONTEXT borrowConnection();

    @Override
    public Hash noAncestorHash() {
        return NO_ANCESTOR;
    }

    @Override
    public Stream<CommitLogEntry> fetchCommitLogEntries(Stream<Hash> hashes) {
        Object ctx = this.borrowConnection();
        BatchSpliterator commitFetcher = new BatchSpliterator(this.config.getParentsPerCommit(), hashes, h -> this.fetchMultipleFromCommitLog(ctx, (List<Hash>)h, ignore -> null).spliterator(), 0);
        return (Stream)StreamSupport.stream(commitFetcher, false).onClose(() -> {
            try {
                ctx.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CommitLogEntry rebuildKeyList(CommitLogEntry entry, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        CommitLogEntry commitLogEntry;
        block9: {
            OP_CONTEXT ctx = this.borrowConnection();
            try {
                commitLogEntry = this.buildKeyList(ctx, entry, h -> {}, inMemoryCommits);
                if (ctx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferenceNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ctx.close();
        }
        return commitLogEntry;
    }

    protected CommitLogEntry commitAttempt(OP_CONTEXT ctx, long timeInMicros, Hash branchHead, CommitParams commitParams, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException, ReferenceConflictException {
        long commitSeq;
        ArrayList<String> mismatches = new ArrayList<String>();
        Callable<Void> validator = commitParams.getValidator();
        if (validator != null) {
            try {
                validator.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AbstractDatabaseAdapter.checkContentKeysUnique(commitParams);
        this.checkExpectedGlobalStates(ctx, commitParams, mismatches::add);
        CommitLogEntry currentBranchEntry = this.checkForModifiedKeysBetweenExpectedAndCurrentCommit(ctx, commitParams, branchHead, mismatches);
        if (!mismatches.isEmpty()) {
            throw new ReferenceConflictException(String.join((CharSequence)"\n", mismatches));
        }
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> newParents = new ArrayList<Hash>(parentsPerCommit);
        newParents.add(branchHead);
        if (currentBranchEntry != null) {
            List<Hash> p = currentBranchEntry.getParents();
            newParents.addAll(p.subList(0, Math.min(p.size(), parentsPerCommit - 1)));
            commitSeq = currentBranchEntry.getCommitSeq() + 1L;
        } else {
            commitSeq = 1L;
        }
        Function<Hash, CommitLogEntry> currentCommit = h -> h.equals(branchHead) ? currentBranchEntry : null;
        CommitLogEntry newBranchCommit = this.buildIndividualCommit(ctx, timeInMicros, newParents, commitSeq, commitParams.getCommitMetaSerialized(), commitParams.getPuts(), commitParams.getDeletes(), currentBranchEntry != null ? currentBranchEntry.getKeyListDistance() : 0, newKeyLists, currentCommit, Collections.emptyList());
        this.writeIndividualCommit(ctx, newBranchCommit);
        this.persistAttachments(ctx, commitParams.getAttachments().stream());
        return newBranchCommit;
    }

    private static void checkContentKeysUnique(CommitParams commitParams) {
        HashSet keys = new HashSet();
        HashSet duplicates = new HashSet();
        Stream.concat(Stream.concat(commitParams.getDeletes().stream(), commitParams.getPuts().stream().map(KeyWithBytes::getKey)), commitParams.getUnchanged().stream()).forEach(key -> {
            if (!keys.add(key)) {
                duplicates.add(key);
            }
        });
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Duplicate keys are not allowed in a commit: %s", duplicates.stream().map(Key::toString).collect(Collectors.joining(", "))));
        }
    }

    protected Hash mergeAttempt(OP_CONTEXT ctx, long timeInMicros, Hash toHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, Consumer<CommitLogEntry> writtenCommits, MergeParams mergeParams, ImmutableMergeResult.Builder<CommitLogEntry> mergeResult) throws ReferenceNotFoundException, ReferenceConflictException {
        List<CommitLogEntry> commitsToMergeChronological;
        List<CommitLogEntry> toEntriesReverseChronological;
        this.validateHashExists(ctx, mergeParams.getMergeFromHash());
        this.hashOnRef(ctx, (NamedRef)mergeParams.getToBranch(), mergeParams.getExpectedHead(), toHead);
        mergeParams.getExpectedHead().ifPresent(arg_0 -> mergeResult.expectedHash(arg_0));
        mergeResult.targetBranch(mergeParams.getToBranch()).effectiveTargetHash(toHead);
        Hash commonAncestor = this.findCommonAncestor(ctx, mergeParams.getMergeFromHash(), (NamedRef)mergeParams.getToBranch(), toHead);
        mergeResult.commonAncestor(commonAncestor);
        try (Stream<CommitLogEntry> commits = this.readCommitLogStream(ctx, toHead);){
            toEntriesReverseChronological = DatabaseAdapterUtil.takeUntilExcludeLast(commits, e -> e.getHash().equals(commonAncestor)).collect(Collectors.toList());
        }
        toEntriesReverseChronological.forEach(arg_0 -> mergeResult.addTargetCommits(arg_0));
        try (Stream<CommitLogEntry> commits = this.readCommitLogStream(ctx, mergeParams.getMergeFromHash());){
            commitsToMergeChronological = DatabaseAdapterUtil.takeUntilExcludeLast(commits, e -> e.getHash().equals(commonAncestor)).collect(Collectors.toList());
        }
        if (commitsToMergeChronological.isEmpty()) {
            throw new IllegalArgumentException(String.format("No hashes to merge from '%s' onto '%s' @ '%s' using common ancestor '%s', expected commit ID from request was '%s'.", mergeParams.getMergeFromHash().asString(), mergeParams.getToBranch().getName(), toHead, commonAncestor.asString(), mergeParams.getExpectedHead().map(Hash::asString).orElse("(not specified)")));
        }
        commitsToMergeChronological.forEach(arg_0 -> mergeResult.addSourceCommits(arg_0));
        return this.mergeTransplantCommon(ctx, timeInMicros, toHead, branchCommits, newKeyLists, commitsToMergeChronological, toEntriesReverseChronological, mergeParams, mergeResult, writtenCommits, Collections.singletonList(((CommitLogEntry)commitsToMergeChronological.get(0)).getHash()));
    }

    protected Hash transplantAttempt(OP_CONTEXT ctx, long timeInMicros, Hash targetHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, Consumer<CommitLogEntry> writtenCommits, TransplantParams transplantParams, ImmutableMergeResult.Builder<CommitLogEntry> mergeResult) throws ReferenceNotFoundException, ReferenceConflictException {
        List<CommitLogEntry> commitsToTransplantChronological;
        if (transplantParams.getSequenceToTransplant().isEmpty()) {
            throw new IllegalArgumentException("No hashes to transplant given.");
        }
        transplantParams.getExpectedHead().ifPresent(arg_0 -> mergeResult.expectedHash(arg_0));
        mergeResult.targetBranch(transplantParams.getToBranch()).effectiveTargetHash(targetHead);
        ArrayList<CommitLogEntry> targetEntriesReverseChronological = new ArrayList<CommitLogEntry>();
        this.hashOnRef(ctx, targetHead, (NamedRef)transplantParams.getToBranch(), transplantParams.getExpectedHead(), targetEntriesReverseChronological::add);
        targetEntriesReverseChronological.forEach(arg_0 -> mergeResult.addTargetCommits(arg_0));
        if (!targetEntriesReverseChronological.isEmpty() && transplantParams.getExpectedHead().isPresent() && ((CommitLogEntry)targetEntriesReverseChronological.get(0)).getHash().equals(transplantParams.getExpectedHead().get())) {
            targetEntriesReverseChronological.remove(0);
        }
        int[] index = new int[]{transplantParams.getSequenceToTransplant().size() - 1};
        Hash lastHash = transplantParams.getSequenceToTransplant().get(transplantParams.getSequenceToTransplant().size() - 1);
        try (Stream<CommitLogEntry> commits = this.readCommitLogStream(ctx, lastHash);){
            commitsToTransplantChronological = DatabaseAdapterUtil.takeUntilExcludeLast(commits, e -> {
                int n = index[0];
                index[0] = n - 1;
                int i = n;
                if (i == -1) {
                    return true;
                }
                if (!e.getHash().equals(transplantParams.getSequenceToTransplant().get(i))) {
                    throw new IllegalArgumentException("Sequence of hashes is not contiguous.");
                }
                return false;
            }).collect(Collectors.toList());
        }
        commitsToTransplantChronological.forEach(arg_0 -> mergeResult.addSourceCommits(arg_0));
        return this.mergeTransplantCommon(ctx, timeInMicros, targetHead, branchCommits, newKeyLists, commitsToTransplantChronological, targetEntriesReverseChronological, transplantParams, mergeResult, writtenCommits, Collections.emptyList());
    }

    protected Hash mergeTransplantCommon(OP_CONTEXT ctx, long timeInMicros, Hash toHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, List<CommitLogEntry> commitsToMergeChronological, List<CommitLogEntry> toEntriesReverseChronological, MetadataRewriteParams params, ImmutableMergeResult.Builder<CommitLogEntry> mergeResult, Consumer<CommitLogEntry> writtenCommits, List<Hash> additionalParents) throws ReferenceConflictException, ReferenceNotFoundException {
        Collections.reverse(toEntriesReverseChronological);
        HashMap<Key, ImmutableKeyDetails.Builder> keyDetailsMap = new HashMap<Key, ImmutableKeyDetails.Builder>();
        Function<Key, MergeType> mergeType = key -> params.getMergeTypes().getOrDefault(key, params.getDefaultMergeType());
        Function<Key, ImmutableKeyDetails.Builder> keyDetails = key -> keyDetailsMap.computeIfAbsent((Key)key, x -> MergeResult.KeyDetails.builder().mergeType((MergeType)mergeType.apply((Key)key)));
        BiConsumer<Stream, BiConsumer> keysFromCommitsToKeyDetails = (commits, receiver) -> {
            HashMap<Key, Set> keyHashesMap = new HashMap<Key, Set>();
            Function<Key, Set> keyHashes = key -> keyHashesMap.computeIfAbsent((Key)key, x -> new LinkedHashSet());
            commits.forEach(commit -> {
                commit.getDeletes().forEach(delete -> ((Set)keyHashes.apply((Key)delete)).add(commit.getHash()));
                commit.getPuts().forEach(put -> ((Set)keyHashes.apply(put.getKey())).add(commit.getHash()));
            });
            keyHashesMap.forEach((key, hashes) -> receiver.accept((ImmutableKeyDetails.Builder)keyDetails.apply((Key)key), hashes));
        };
        HashSet<Key> keysTouchedOnTarget = new HashSet<Key>();
        keysFromCommitsToKeyDetails.accept(commitsToMergeChronological.stream(), ImmutableKeyDetails.Builder::addAllSourceCommits);
        keysFromCommitsToKeyDetails.accept(toEntriesReverseChronological.stream().peek(e -> {
            e.getPuts().stream().map(KeyWithBytes::getKey).forEach(keysTouchedOnTarget::add);
            e.getDeletes().forEach(keysTouchedOnTarget::remove);
        }), ImmutableKeyDetails.Builder::addAllTargetCommits);
        Predicate<Key> skipCheckPredicate = k -> ((MergeType)mergeType.apply((Key)k)).isSkipCheck();
        Predicate<Key> mergePredicate = k -> ((MergeType)mergeType.apply((Key)k)).isMerge();
        keysTouchedOnTarget.removeIf(skipCheckPredicate);
        boolean hasCollisions = this.hasKeyCollisions(ctx, toHead, keysTouchedOnTarget, commitsToMergeChronological, keyDetails);
        keyDetailsMap.forEach((key, details) -> mergeResult.putDetails(key, (MergeResult.KeyDetails)details.build()));
        mergeResult.wasSuccessful(!hasCollisions);
        if (hasCollisions && !params.isDryRun()) {
            ImmutableMergeResult result = mergeResult.resultantTargetHash(toHead).build();
            throw new MergeConflictException(String.format("The following keys have been changed in conflict: %s", result.getDetails().entrySet().stream().filter(e -> ((MergeResult.KeyDetails)e.getValue()).getConflictType() != MergeResult.ConflictType.NONE).map(Map.Entry::getKey).sorted().map(key -> String.format("'%s'", key)).collect(Collectors.joining(", "))), (MergeResult)result);
        }
        if (params.isDryRun() || hasCollisions) {
            return toHead;
        }
        if (params.keepIndividualCommits()) {
            toHead = this.copyCommits(ctx, timeInMicros, toHead, commitsToMergeChronological, newKeyLists, params.getUpdateCommitMetadata(), mergePredicate);
            this.writeMultipleCommits(ctx, commitsToMergeChronological);
            commitsToMergeChronological.stream().peek(writtenCommits).map(CommitLogEntry::getHash).forEach(branchCommits);
        } else {
            CommitLogEntry squashed = this.squashCommits(ctx, timeInMicros, toHead, commitsToMergeChronological, newKeyLists, params.getUpdateCommitMetadata(), mergePredicate, additionalParents);
            if (squashed != null) {
                writtenCommits.accept(squashed);
                toHead = squashed.getHash();
            }
        }
        return toHead;
    }

    @MustBeClosed
    protected Stream<Difference> buildDiff(OP_CONTEXT ctx, Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet allKeys = new HashSet();
        try (Stream<Key> s = this.keysForCommitEntry(ctx, from, keyFilter).map(KeyListEntry::getKey);){
            s.forEach(allKeys::add);
        }
        s = this.keysForCommitEntry(ctx, to, keyFilter).map(KeyListEntry::getKey);
        try {
            s.forEach(allKeys::add);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        if (allKeys.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<Key> allKeysList = new ArrayList<Key>(allKeys);
        Map<Key, ContentAndState> fromValues = this.fetchValues(ctx, from, allKeysList, keyFilter);
        Map<Key, ContentAndState> toValues = this.fetchValues(ctx, to, allKeysList, keyFilter);
        Function<ContentAndState, Optional> valToContent = cs -> cs != null ? Optional.of(cs.getRefState()) : Optional.empty();
        return IntStream.range(0, allKeys.size()).mapToObj(allKeysList::get).map(k -> {
            byte payload;
            Optional t;
            ContentAndState fromVal = (ContentAndState)fromValues.get(k);
            ContentAndState toVal = (ContentAndState)toValues.get(k);
            Optional f = (Optional)valToContent.apply(fromVal);
            if (f.equals(t = (Optional)valToContent.apply(toVal))) {
                return null;
            }
            byte by = fromVal != null ? fromVal.getPayload() : (payload = toVal != null ? toVal.getPayload() : (byte)0);
            Optional<ByteString> g = Optional.ofNullable(fromVal != null ? fromVal.getGlobalState() : (toVal != null ? toVal.getGlobalState() : null));
            return Difference.of(payload, k, g, f, t);
        }).filter(Objects::nonNull);
    }

    @MustBeClosed
    protected Stream<ReferenceInfo<ByteString>> namedRefsFilterAndEnhance(OP_CONTEXT ctx, GetNamedRefsParams params, Hash defaultBranchHead, Stream<ReferenceInfo<ByteString>> refs) {
        refs = AbstractDatabaseAdapter.namedRefsMaybeFilter(params, refs);
        refs = this.namedRefsWithDefaultBranchRelatedInfo(ctx, params, refs, defaultBranchHead);
        refs = this.namedReferenceWithCommitMeta(ctx, params, refs);
        return refs;
    }

    protected static Stream<ReferenceInfo<ByteString>> namedRefsMaybeFilter(GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs) {
        if (params.getBranchRetrieveOptions().isRetrieve() && params.getTagRetrieveOptions().isRetrieve()) {
            return refs;
        }
        return refs.filter(ref -> AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref).isRetrieve());
    }

    protected static boolean namedRefsRequiresBaseReference(GetNamedRefsParams params) {
        return AbstractDatabaseAdapter.namedRefsRequiresBaseReference(params.getBranchRetrieveOptions()) || AbstractDatabaseAdapter.namedRefsRequiresBaseReference(params.getTagRetrieveOptions());
    }

    protected static boolean namedRefsRequiresBaseReference(GetNamedRefsParams.RetrieveOptions retrieveOptions) {
        return retrieveOptions.isComputeAheadBehind() || retrieveOptions.isComputeCommonAncestor();
    }

    protected static boolean namedRefsAnyRetrieves(GetNamedRefsParams params) {
        return params.getBranchRetrieveOptions().isRetrieve() || params.getTagRetrieveOptions().isRetrieve();
    }

    protected static GetNamedRefsParams.RetrieveOptions namedRefsRetrieveOptionsForReference(GetNamedRefsParams params, ReferenceInfo<ByteString> ref) {
        return AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, ref.getNamedRef());
    }

    protected static GetNamedRefsParams.RetrieveOptions namedRefsRetrieveOptionsForReference(GetNamedRefsParams params, NamedRef ref) {
        if (ref instanceof BranchName) {
            return params.getBranchRetrieveOptions();
        }
        if (ref instanceof TagName) {
            return params.getTagRetrieveOptions();
        }
        throw new IllegalArgumentException("ref must be either BranchName or TabName, but is " + ref);
    }

    @MustBeClosed
    protected Stream<ReferenceInfo<ByteString>> namedReferenceWithCommitMeta(OP_CONTEXT ctx, GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs) {
        return refs.map(ref -> {
            if (!AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref).isRetrieveCommitMetaForHead()) {
                return ref;
            }
            CommitLogEntry logEntry = this.fetchFromCommitLog(ctx, ref.getHash());
            if (logEntry == null) {
                return ref;
            }
            return ImmutableReferenceInfo.builder().from(ref).headCommitMeta((Object)logEntry.getMetadata()).commitSeq(logEntry.getCommitSeq()).addParentHashes(logEntry.getParents().get(0)).addAllParentHashes(logEntry.getAdditionalParents()).build();
        });
    }

    @MustBeClosed
    protected Stream<ReferenceInfo<ByteString>> namedRefsWithDefaultBranchRelatedInfo(OP_CONTEXT ctx, GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs, Hash defaultBranchHead) {
        if (defaultBranchHead == null) {
            return refs;
        }
        CommonAncestorState commonAncestorState = new CommonAncestorState(this, ctx, defaultBranchHead, params.getBranchRetrieveOptions().isComputeAheadBehind() || params.getTagRetrieveOptions().isComputeAheadBehind());
        return refs.map(ref -> {
            if (ref.getNamedRef().equals(params.getBaseReference())) {
                return ref;
            }
            GetNamedRefsParams.RetrieveOptions retrieveOptions = AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref);
            ReferenceInfo updated = AbstractDatabaseAdapter.namedRefsRequiresBaseReference(retrieveOptions) ? this.findCommonAncestor(ctx, ref.getHash(), commonAncestorState, (Integer diffOnFrom, Hash hash) -> {
                ReferenceInfo newRef = ref;
                if (retrieveOptions.isComputeCommonAncestor()) {
                    newRef = newRef.withCommonAncestor(hash);
                }
                if (retrieveOptions.isComputeAheadBehind()) {
                    int behind = commonAncestorState.indexOf((Hash)hash);
                    ReferenceInfo.CommitsAheadBehind aheadBehind = ReferenceInfo.CommitsAheadBehind.of((int)diffOnFrom, (int)behind);
                    newRef = newRef.withAheadBehind(aheadBehind);
                }
                return newRef;
            }) : null;
            return updated != null ? updated : ref;
        });
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, NamedRef reference, Optional<Hash> hashOnRef, Hash knownHead) throws ReferenceNotFoundException {
        return this.hashOnRef(ctx, knownHead, reference, hashOnRef, null);
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, Hash knownHead, NamedRef ref, Optional<Hash> hashOnRef, Consumer<CommitLogEntry> commitLogVisitor) throws ReferenceNotFoundException {
        if (hashOnRef.isPresent()) {
            Hash suspect = hashOnRef.get();
            if (suspect.equals(NO_ANCESTOR)) {
                if (commitLogVisitor != null) {
                    try (Stream<CommitLogEntry> commits = this.readCommitLogStream(ctx, knownHead);){
                        commits.forEach(commitLogVisitor);
                    }
                }
                return suspect;
            }
            try (Stream<Hash> hashes = this.commitsForHashOnRef(ctx, knownHead, commitLogVisitor);){
                if (hashes.noneMatch(suspect::equals)) {
                    throw DatabaseAdapterUtil.hashNotFound(ref, suspect);
                }
                Hash hash = suspect;
                return hash;
            }
        }
        return knownHead;
    }

    @MustBeClosed
    private Stream<Hash> commitsForHashOnRef(OP_CONTEXT ctx, Hash knownHead, Consumer<CommitLogEntry> commitLogVisitor) throws ReferenceNotFoundException {
        if (commitLogVisitor != null) {
            return this.readCommitLogStream(ctx, knownHead).peek(commitLogVisitor).map(CommitLogEntry::getHash);
        }
        return this.readCommitLogHashesStream(ctx, knownHead);
    }

    protected void validateHashExists(OP_CONTEXT ctx, Hash hash) throws ReferenceNotFoundException {
        if (!NO_ANCESTOR.equals(hash) && this.fetchFromCommitLog(ctx, hash) == null) {
            throw DatabaseAdapterUtil.referenceNotFound(hash);
        }
    }

    @VisibleForTesting
    public final CommitLogEntry fetchFromCommitLog(OP_CONTEXT ctx, Hash hash) {
        if (hash.equals(NO_ANCESTOR)) {
            return null;
        }
        try (Traced ignore = Traced.trace("fetchFromCommitLog").tag(TAG_HASH, hash.asString());){
            CommitLogEntry commitLogEntry = this.doFetchFromCommitLog(ctx, hash);
            return commitLogEntry;
        }
    }

    protected abstract CommitLogEntry doFetchFromCommitLog(OP_CONTEXT var1, Hash var2);

    @Override
    public Stream<CommitLogEntry> scanAllCommitLogEntries() {
        Object ctx = this.borrowConnection();
        return (Stream)this.doScanAllCommitLogEntries(ctx).onClose(() -> {
            try {
                ctx.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @MustBeClosed
    protected abstract Stream<CommitLogEntry> doScanAllCommitLogEntries(OP_CONTEXT var1);

    private List<CommitLogEntry> fetchMultipleFromCommitLog(OP_CONTEXT ctx, List<Hash> hashes, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) {
        ArrayList<CommitLogEntry> result = new ArrayList<CommitLogEntry>(hashes.size());
        BitSet remainingHashes = null;
        for (int i2 = 0; i2 < hashes.size(); ++i2) {
            Hash hash = hashes.get(i2);
            if (NO_ANCESTOR.equals(hash)) {
                result.add(null);
                continue;
            }
            CommitLogEntry found = inMemoryCommits.apply(hash);
            if (found != null) {
                result.add(found);
                continue;
            }
            if (remainingHashes == null) {
                remainingHashes = new BitSet();
            }
            result.add(null);
            remainingHashes.set(i2);
        }
        if (remainingHashes != null) {
            List<CommitLogEntry> fromStorage;
            try (Traced ignore = Traced.trace("fetchPageFromCommitLog").tag(TAG_HASH, hashes.get(0).asString()).tag(TAG_COUNT, hashes.size());){
                fromStorage = this.doFetchMultipleFromCommitLog(ctx, remainingHashes.stream().mapToObj(hashes::get).collect(Collectors.toList()));
            }
            Iterator<CommitLogEntry> iter = fromStorage.iterator();
            remainingHashes.stream().forEach(i -> result.set(i, (CommitLogEntry)iter.next()));
        }
        return result;
    }

    protected abstract List<CommitLogEntry> doFetchMultipleFromCommitLog(OP_CONTEXT var1, List<Hash> var2);

    @MustBeClosed
    protected Stream<CommitLogEntry> readCommitLogStream(OP_CONTEXT ctx, Hash initialHash) throws ReferenceNotFoundException {
        Spliterator<CommitLogEntry> split = this.readCommitLog(ctx, initialHash, h -> null);
        return StreamSupport.stream(split, false);
    }

    @MustBeClosed
    protected Stream<CommitLogEntry> readCommitLogStream(OP_CONTEXT ctx, Hash initialHash, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Spliterator<CommitLogEntry> split = this.readCommitLog(ctx, initialHash, inMemoryCommits);
        return StreamSupport.stream(split, false);
    }

    protected Spliterator<CommitLogEntry> readCommitLog(OP_CONTEXT ctx, Hash initialHash, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Preconditions.checkNotNull(inMemoryCommits, (Object)"in-memory commits cannot be null");
        if (NO_ANCESTOR.equals(initialHash)) {
            return Spliterators.emptySpliterator();
        }
        CommitLogEntry initial = inMemoryCommits.apply(initialHash);
        if (initial == null) {
            initial = this.fetchFromCommitLog(ctx, initialHash);
        }
        if (initial == null) {
            throw DatabaseAdapterUtil.referenceNotFound(initialHash);
        }
        BiFunction<AutoCloseable, List, List> fetcher = (c, hashes) -> this.fetchMultipleFromCommitLog((OP_CONTEXT)c, (List<Hash>)hashes, inMemoryCommits);
        return this.logFetcher(ctx, initial, fetcher, CommitLogEntry::getParents);
    }

    @MustBeClosed
    protected Stream<Hash> readCommitLogHashesStream(OP_CONTEXT ctx, Hash initialHash) {
        Spliterator<Hash> split = this.readCommitLogHashes(ctx, initialHash);
        return StreamSupport.stream(split, false);
    }

    protected Spliterator<Hash> readCommitLogHashes(OP_CONTEXT ctx, Hash initialHash) {
        return this.logFetcher(ctx, initialHash, (c, hashes) -> hashes, hash -> {
            CommitLogEntry entry = this.fetchFromCommitLog(ctx, (Hash)hash);
            if (entry == null) {
                return Collections.emptyList();
            }
            return entry.getParents();
        });
    }

    protected <T> Spliterator<T> logFetcher(OP_CONTEXT ctx, T initial, BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, Function<T, List<Hash>> nextPage) {
        return this.logFetcherCommon(ctx, Collections.singletonList(initial), fetcher, nextPage);
    }

    protected <T> Spliterator<T> logFetcherWithPage(OP_CONTEXT ctx, List<Hash> initialPage, BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, Function<T, List<Hash>> nextPage) {
        return this.logFetcherCommon(ctx, fetcher.apply(ctx, initialPage), fetcher, nextPage);
    }

    private <T> Spliterator<T> logFetcherCommon(OP_CONTEXT ctx, final List<T> initial, final BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, final Function<T, List<Hash>> nextPage) {
        return new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0, (AutoCloseable)ctx){
            private Iterator<T> currentBatch;
            private boolean eof;
            private T previous;
            final /* synthetic */ AutoCloseable val$ctx;
            {
                this.val$ctx = autoCloseable;
                super(est, additionalCharacteristics);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.eof) {
                    return false;
                }
                if (this.currentBatch == null) {
                    this.currentBatch = initial.iterator();
                } else if (!this.currentBatch.hasNext()) {
                    if (this.previous == null) {
                        this.eof = true;
                        return false;
                    }
                    List page = (List)nextPage.apply(this.previous);
                    this.previous = null;
                    if (!page.isEmpty()) {
                        this.currentBatch = ((List)fetcher.apply(this.val$ctx, page)).iterator();
                        if (!this.currentBatch.hasNext()) {
                            this.eof = true;
                            return false;
                        }
                    } else {
                        this.eof = true;
                        return false;
                    }
                }
                Object v = this.currentBatch.next();
                if (v != null) {
                    consumer.accept(v);
                    this.previous = v;
                }
                return true;
            }
        };
    }

    protected CommitLogEntry buildIndividualCommit(OP_CONTEXT ctx, long timeInMicros, List<Hash> parentHashes, long commitSeq, ByteString commitMeta, Iterable<KeyWithBytes> puts, Iterable<Key> deletes, int currentKeyListDistance, Consumer<Hash> newKeyLists, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits, Iterable<Hash> additionalParents) throws ReferenceNotFoundException {
        Hash commitHash = this.individualCommitHash(parentHashes, commitMeta, puts, deletes);
        int keyListDistance = currentKeyListDistance + 1;
        CommitLogEntry entry = CommitLogEntry.of(timeInMicros, commitHash, commitSeq, parentHashes, commitMeta, puts, deletes, keyListDistance, null, Collections.emptyList(), Collections.emptyList(), additionalParents);
        if (keyListDistance >= this.config.getKeyListDistance()) {
            entry = this.buildKeyList(ctx, entry, newKeyLists, inMemoryCommits);
        }
        return entry;
    }

    protected Hash individualCommitHash(List<Hash> parentHashes, ByteString commitMeta, Iterable<KeyWithBytes> puts, Iterable<Key> deletes) {
        Hasher hasher = DatabaseAdapterUtil.newHasher();
        hasher.putLong(COMMIT_LOG_HASH_SEED);
        parentHashes.forEach(h -> hasher.putBytes(h.asBytes().asReadOnlyByteBuffer()));
        hasher.putBytes(commitMeta.asReadOnlyByteBuffer());
        puts.forEach(e -> {
            DatabaseAdapterUtil.hashKey(hasher, e.getKey());
            hasher.putString((CharSequence)e.getContentId().getId(), StandardCharsets.UTF_8);
            hasher.putBytes(e.getValue().asReadOnlyByteBuffer());
        });
        deletes.forEach(e -> DatabaseAdapterUtil.hashKey(hasher, e));
        return Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])hasher.hash().asBytes()));
    }

    protected CommitLogEntry buildKeyList(OP_CONTEXT ctx, CommitLogEntry unwrittenEntry, Consumer<Hash> newKeyLists, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Hash startHash = unwrittenEntry.getParents().get(0);
        ImmutableCommitLogEntry.Builder newCommitEntry = ImmutableCommitLogEntry.builder().from(unwrittenEntry).keyListDistance(0).keyListVariant(CommitLogEntry.KeyListVariant.OPEN_ADDRESSING);
        KeyListBuildState buildState = new KeyListBuildState(newCommitEntry, this.maxEntitySize(this.config.getMaxKeyListSize()) - this.entitySize(unwrittenEntry), this.maxEntitySize(this.config.getMaxKeyListEntitySize()), this.config.getKeyListHashLoadFactor(), this::entitySize);
        HashSet keysToEnhanceWithCommitId = new HashSet();
        try (Stream<KeyListEntry> keys = this.keysForCommitEntry(ctx, startHash, null, inMemoryCommits);){
            keys.forEach(keyListEntry -> {
                if (keyListEntry.getCommitId() == null) {
                    keysToEnhanceWithCommitId.add(keyListEntry.getKey());
                } else {
                    buildState.add((KeyListEntry)keyListEntry);
                }
            });
        }
        if (!keysToEnhanceWithCommitId.isEmpty()) {
            boolean more;
            Spliterator<CommitLogEntry> clSplit = this.readCommitLog(ctx, startHash, inMemoryCommits);
            while ((more = clSplit.tryAdvance(e -> {
                e.getDeletes().forEach(keysToEnhanceWithCommitId::remove);
                for (KeyWithBytes put : e.getPuts()) {
                    if (!keysToEnhanceWithCommitId.remove(put.getKey())) continue;
                    KeyListEntry entry = KeyListEntry.of(put.getKey(), put.getContentId(), put.getPayload(), e.getHash());
                    buildState.add(entry);
                }
            })) && !keysToEnhanceWithCommitId.isEmpty()) {
            }
        }
        List<KeyListEntity> newKeyListEntities = buildState.finish();
        newKeyListEntities.stream().map(KeyListEntity::getId).forEach(newKeyLists);
        if (!newKeyListEntities.isEmpty()) {
            this.writeKeyListEntities(ctx, newKeyListEntities);
        }
        return newCommitEntry.build();
    }

    protected int maxEntitySize(int value) {
        return value;
    }

    protected abstract int entitySize(CommitLogEntry var1);

    protected abstract int entitySize(KeyListEntry var1);

    protected CommitLogEntry checkForModifiedKeysBetweenExpectedAndCurrentCommit(OP_CONTEXT ctx, CommitParams commitParams, Hash branchHead, List<String> mismatches) throws ReferenceNotFoundException {
        Hash expectedHead;
        CommitLogEntry commitAtHead = null;
        if (commitParams.getExpectedHead().isPresent() && !(expectedHead = commitParams.getExpectedHead().get()).equals(branchHead)) {
            HashSet operationKeys = Sets.newHashSetWithExpectedSize((int)(commitParams.getDeletes().size() + commitParams.getUnchanged().size() + commitParams.getPuts().size()));
            operationKeys.addAll(commitParams.getDeletes());
            operationKeys.addAll(commitParams.getUnchanged());
            commitParams.getPuts().stream().map(KeyWithBytes::getKey).forEach(operationKeys::add);
            ConflictingKeyCheckResult conflictingKeyCheckResult = this.checkConflictingKeysForCommit(ctx, branchHead, expectedHead, operationKeys, mismatches::add);
            if (!conflictingKeyCheckResult.sinceSeen && !expectedHead.equals(NO_ANCESTOR)) {
                throw DatabaseAdapterUtil.hashNotFound((NamedRef)commitParams.getToBranch(), expectedHead);
            }
            commitAtHead = conflictingKeyCheckResult.headCommit;
        }
        if (commitAtHead == null) {
            commitAtHead = this.fetchFromCommitLog(ctx, branchHead);
        }
        return commitAtHead;
    }

    @MustBeClosed
    protected Stream<KeyListEntry> keysForCommitEntry(OP_CONTEXT ctx, Hash hash, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.keysForCommitEntry(ctx, hash, keyFilter, h -> null);
    }

    @MustBeClosed
    protected Stream<KeyListEntry> keysForCommitEntry(OP_CONTEXT ctx, Hash hash, KeyFilterPredicate keyFilter, @javax.annotation.Nonnull @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        HashSet seen = new HashSet();
        Predicate<KeyListEntry> predicate = keyListEntry -> keyListEntry != null && seen.add(keyListEntry.getKey());
        if (keyFilter != null) {
            predicate = predicate.and(kt -> keyFilter.check(kt.getKey(), kt.getContentId(), kt.getPayload()));
        }
        Predicate<KeyListEntry> keyPredicate = predicate;
        Stream<CommitLogEntry> log = DatabaseAdapterUtil.takeUntilIncludeLast(this.readCommitLogStream(ctx, hash, inMemoryCommits), CommitLogEntry::hasKeySummary);
        return log.flatMap(e -> {
            seen.addAll(e.getDeletes());
            Stream<KeyListEntry> stream = e.getPuts().stream().map(put -> KeyListEntry.of(put.getKey(), put.getContentId(), put.getPayload(), e.getHash())).filter(keyPredicate);
            if (e.hasKeySummary()) {
                List<Hash> keyListIds;
                KeyList embeddedKeyList = e.getKeyList();
                if (embeddedKeyList != null) {
                    Stream embedded = embeddedKeyList.getKeys().stream().filter(keyPredicate);
                    stream = Stream.concat(stream, embedded);
                }
                if ((keyListIds = e.getKeyListsIds()) != null && !keyListIds.isEmpty()) {
                    Stream entities = Stream.of(keyListIds).flatMap(ids -> {
                        Stream<KeyListEntity> r = this.fetchKeyLists(ctx, (List<Hash>)ids);
                        return r;
                    }).map(KeyListEntity::getKeys).map(KeyList::getKeys).flatMap(Collection::stream).filter(keyPredicate);
                    stream = Stream.concat(stream, entities);
                }
            }
            return stream;
        });
    }

    protected Map<Key, ContentAndState> fetchValues(OP_CONTEXT ctx, Hash refHead, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet<Key> remainingKeys = new HashSet<Key>(keys);
        HashMap nonGlobal = new HashMap();
        HashMap keyToContentIds = new HashMap();
        HashSet<ContentId> contentIdsForGlobal = new HashSet<ContentId>();
        Consumer<CommitLogEntry> commitLogEntryHandler = entry -> {
            entry.getDeletes().forEach(remainingKeys::remove);
            for (KeyWithBytes put : entry.getPuts()) {
                if (!remainingKeys.remove(put.getKey()) || !keyFilter.check(put.getKey(), put.getContentId(), put.getPayload())) continue;
                nonGlobal.put(put.getKey(), ContentAndState.of(put.getPayload(), put.getValue()));
                keyToContentIds.put(put.getKey(), put.getContentId());
                if (!STORE_WORKER.requiresGlobalState(put.getPayload(), put.getValue())) continue;
                contentIdsForGlobal.add(put.getContentId());
            }
        };
        AtomicBoolean keyListProcessed = new AtomicBoolean();
        try (Stream<CommitLogEntry> baseLog = this.readCommitLogStream(ctx, refHead);
             Stream<CommitLogEntry> log = DatabaseAdapterUtil.takeUntilExcludeLast(baseLog, e -> remainingKeys.isEmpty());){
            log.forEach(entry -> {
                commitLogEntryHandler.accept((CommitLogEntry)entry);
                if (entry.hasKeySummary() && keyListProcessed.compareAndSet(false, true) && !remainingKeys.isEmpty()) {
                    List<KeyListEntry> keyListEntries;
                    switch (entry.getKeyListVariant()) {
                        case OPEN_ADDRESSING: {
                            keyListEntries = this.fetchValuesHandleOpenAddressingKeyList(ctx, (Collection<Key>)remainingKeys, (CommitLogEntry)entry);
                            break;
                        }
                        case EMBEDDED_AND_EXTERNAL_MRU: {
                            keyListEntries = this.fetchValuesHandleKeyList(ctx, (Set<Key>)remainingKeys, (CommitLogEntry)entry);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown key list variant " + (Object)((Object)entry.getKeyListVariant()));
                        }
                    }
                    if (!keyListEntries.isEmpty()) {
                        List<CommitLogEntry> commitLogEntries = this.fetchMultipleFromCommitLog(ctx, keyListEntries.stream().map(KeyListEntry::getCommitId).filter(Objects::nonNull).distinct().collect(Collectors.toList()), h -> null);
                        commitLogEntries.forEach(commitLogEntryHandler);
                    }
                    remainingKeys.retainAll(keyListEntries.stream().filter(e -> e.getCommitId() == null).map(KeyListEntry::getKey).collect(Collectors.toSet()));
                }
            });
        }
        Map globals = contentIdsForGlobal.isEmpty() ? Collections.emptyMap() : this.fetchGlobalStates(ctx, contentIdsForGlobal);
        return nonGlobal.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            ContentAndState cs = (ContentAndState)e.getValue();
            ByteString global = (ByteString)globals.get(keyToContentIds.get(e.getKey()));
            return global != null ? ContentAndState.of(cs.getPayload(), cs.getRefState(), global) : cs;
        }));
    }

    private List<KeyListEntry> fetchValuesHandleOpenAddressingKeyList(OP_CONTEXT ctx, Collection<Key> remainingKeys, CommitLogEntry entry) {
        FetchValuesUsingOpenAddressing helper = new FetchValuesUsingOpenAddressing(entry);
        ArrayList<KeyListEntry> keyListEntries = new ArrayList<KeyListEntry>();
        int round = 0;
        while (!remainingKeys.isEmpty()) {
            List<Hash> entitiesToFetch = helper.entityIdsToFetch(round, this.config.getKeyListEntityPrefetch(), remainingKeys);
            if (!entitiesToFetch.isEmpty()) {
                try (Stream<KeyListEntity> keyLists = this.fetchKeyLists(ctx, entitiesToFetch);){
                    keyLists.forEach(helper::entityLoaded);
                }
            }
            remainingKeys = helper.checkForKeys(round, remainingKeys, keyListEntries::add);
            ++round;
        }
        return keyListEntries;
    }

    private List<KeyListEntry> fetchValuesHandleKeyList(OP_CONTEXT ctx, Set<Key> remainingKeys, CommitLogEntry entry) {
        ArrayList<KeyListEntry> keyListEntries = new ArrayList<KeyListEntry>();
        try (Stream<KeyList> keyLists = this.keyListsFromCommitLogEntry(ctx, entry);){
            keyLists.flatMap(keyList -> keyList.getKeys().stream()).filter(Objects::nonNull).filter(keyListEntry -> remainingKeys.contains(keyListEntry.getKey())).forEach(keyListEntries::add);
        }
        return keyListEntries;
    }

    @MustBeClosed
    private Stream<KeyList> keyListsFromCommitLogEntry(OP_CONTEXT ctx, CommitLogEntry entry) {
        KeyList embeddedKeyList = entry.getKeyList();
        Stream<KeyList> keyList = embeddedKeyList != null ? Stream.of(embeddedKeyList) : Stream.empty();
        List<Hash> keyListIds = entry.getKeyListsIds();
        if (keyListIds != null && !keyListIds.isEmpty()) {
            keyList = Stream.concat(Stream.of(entry.getKeyList()), Stream.of(keyListIds).flatMap(ids -> {
                Stream<KeyList> r = this.fetchKeyLists(ctx, (List<Hash>)ids).map(KeyListEntity::getKeys);
                return r;
            }));
        }
        return keyList;
    }

    protected final Map<ContentId, ByteString> fetchGlobalStates(OP_CONTEXT ctx, Set<ContentId> contentIds) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("fetchGlobalStates").tag(TAG_COUNT, contentIds.size());){
            Map<ContentId, ByteString> map = this.doFetchGlobalStates(ctx, contentIds);
            return map;
        }
    }

    protected abstract Map<ContentId, ByteString> doFetchGlobalStates(OP_CONTEXT var1, Set<ContentId> var2) throws ReferenceNotFoundException;

    @VisibleForTesting
    @MustBeClosed
    public final Stream<KeyListEntity> fetchKeyLists(OP_CONTEXT ctx, List<Hash> keyListsIds) {
        if (keyListsIds.isEmpty()) {
            return Stream.empty();
        }
        try (Traced ignore = Traced.trace("fetchKeyLists").tag(TAG_COUNT, keyListsIds.size());){
            Stream<KeyListEntity> stream = this.doFetchKeyLists(ctx, keyListsIds);
            return stream;
        }
    }

    @MustBeClosed
    protected abstract Stream<KeyListEntity> doFetchKeyLists(OP_CONTEXT var1, List<Hash> var2);

    protected final void writeIndividualCommit(OP_CONTEXT ctx, CommitLogEntry entry) throws ReferenceConflictException {
        try (Traced ignore = Traced.trace("writeIndividualCommit");){
            this.doWriteIndividualCommit(ctx, entry);
        }
    }

    protected abstract void doWriteIndividualCommit(OP_CONTEXT var1, CommitLogEntry var2) throws ReferenceConflictException;

    protected final void writeMultipleCommits(OP_CONTEXT ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        try (Traced ignore = Traced.trace("writeMultipleCommits").tag(TAG_COUNT, entries.size());){
            this.doWriteMultipleCommits(ctx, entries);
        }
    }

    protected abstract void doWriteMultipleCommits(OP_CONTEXT var1, List<CommitLogEntry> var2) throws ReferenceConflictException;

    protected abstract void doUpdateMultipleCommits(OP_CONTEXT var1, List<CommitLogEntry> var2) throws ReferenceNotFoundException;

    @VisibleForTesting
    public final void writeKeyListEntities(OP_CONTEXT ctx, List<KeyListEntity> newKeyListEntities) {
        try (Traced ignore = Traced.trace("writeKeyListEntities").tag(TAG_COUNT, newKeyListEntities.size());){
            this.doWriteKeyListEntities(ctx, newKeyListEntities);
        }
    }

    protected abstract void doWriteKeyListEntities(OP_CONTEXT var1, List<KeyListEntity> var2);

    protected ConflictingKeyCheckResult checkConflictingKeysForCommit(OP_CONTEXT ctx, Hash upToCommitIncluding, Hash sinceCommitExcluding, Set<Key> keys, Consumer<String> mismatches) throws ReferenceNotFoundException {
        ConflictingKeyCheckResult result = new ConflictingKeyCheckResult();
        try (Stream<CommitLogEntry> commits = this.readCommitLogStream(ctx, upToCommitIncluding);){
            Stream<CommitLogEntry> log = DatabaseAdapterUtil.takeUntilExcludeLast(commits, e -> {
                if (e.getHash().equals(upToCommitIncluding)) {
                    result.headCommit = e;
                }
                if (e.getHash().equals(sinceCommitExcluding)) {
                    result.sinceSeen = true;
                    return true;
                }
                return false;
            });
            HashSet handled = new HashSet();
            log.forEach(e -> {
                e.getPuts().forEach(a -> {
                    if (keys.contains(a.getKey()) && handled.add(a.getKey())) {
                        mismatches.accept(String.format("Key '%s' has conflicting put-operation from commit '%s'.", a.getKey(), e.getHash().asString()));
                    }
                });
                e.getDeletes().forEach(a -> {
                    if (keys.contains(a) && handled.add(a)) {
                        mismatches.accept(String.format("Key '%s' has conflicting delete-operation from commit '%s'.", a, e.getHash().asString()));
                    }
                });
            });
        }
        return result;
    }

    protected Hash findCommonAncestor(OP_CONTEXT ctx, Hash from, NamedRef toBranch, Hash toHead) throws ReferenceConflictException {
        CommonAncestorState commonAncestorState = new CommonAncestorState(this, ctx, toHead, false);
        Hash commonAncestorHash = this.findCommonAncestor(ctx, from, commonAncestorState, (Integer dist, Hash hash) -> hash);
        if (commonAncestorHash == null) {
            throw new ReferenceConflictException(String.format("No common ancestor found for merge of '%s' into branch '%s' @ '%s'", from, toBranch.getName(), toHead.asString()));
        }
        return commonAncestorHash;
    }

    protected <R> R findCommonAncestor(OP_CONTEXT ctx, Hash from, CommonAncestorState state, BiFunction<Integer, Hash, R> result) {
        Iterator<Hash> fromLog = Spliterators.iterator(this.readCommitLogHashes(ctx, from));
        ArrayList<Hash> fromCommitHashes = new ArrayList<Hash>();
        block0: while (true) {
            boolean anyFetched = false;
            for (int i = 0; i < this.config.getParentsPerCommit(); ++i) {
                if (state.fetchNext()) {
                    anyFetched = true;
                }
                if (!fromLog.hasNext()) continue;
                fromCommitHashes.add(fromLog.next());
                anyFetched = true;
            }
            if (!anyFetched) {
                return null;
            }
            int diffOnFrom = 0;
            while (true) {
                if (diffOnFrom >= fromCommitHashes.size()) continue block0;
                Hash f = (Hash)fromCommitHashes.get(diffOnFrom);
                if (state.contains(f)) {
                    return result.apply(diffOnFrom, f);
                }
                ++diffOnFrom;
            }
            break;
        }
    }

    protected boolean hasKeyCollisions(OP_CONTEXT ctx, Hash refHead, Set<Key> keysTouchedOnTarget, List<CommitLogEntry> commitsChronological, Function<Key, ImmutableKeyDetails.Builder> keyDetails) throws ReferenceNotFoundException {
        HashSet<Key> keyCollisions = new HashSet<Key>();
        for (int i = commitsChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            Stream.concat(sourceCommit.getPuts().stream().map(KeyWithBytes::getKey), sourceCommit.getDeletes().stream()).filter(keysTouchedOnTarget::contains).forEach(keyCollisions::add);
        }
        if (!keyCollisions.isEmpty()) {
            this.removeKeyCollisionsForNamespaces(ctx, refHead, commitsChronological.get(commitsChronological.size() - 1).getHash(), keyCollisions);
            if (!keyCollisions.isEmpty()) {
                keyCollisions.forEach(key -> ((ImmutableKeyDetails.Builder)keyDetails.apply((Key)key)).conflictType(MergeResult.ConflictType.UNRESOLVABLE));
                return true;
            }
        }
        return false;
    }

    private void removeKeyCollisionsForNamespaces(OP_CONTEXT ctx, Hash hashFromTarget, Hash hashFromSource, Set<Key> keyCollisions) throws ReferenceNotFoundException {
        Predicate<Map.Entry> isNamespace = e -> STORE_WORKER.getType(((ContentAndState)e.getValue()).getPayload(), ((ContentAndState)e.getValue()).getRefState()).equals(Content.Type.NAMESPACE);
        Set<Key> namespacesOnTarget = this.fetchValues(ctx, hashFromTarget, keyCollisions, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().filter(isNamespace).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<Key> intersection = this.fetchValues(ctx, hashFromSource, namespacesOnTarget, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().filter(isNamespace).map(Map.Entry::getKey).collect(Collectors.toSet());
        intersection.forEach(keyCollisions::remove);
    }

    protected CommitLogEntry squashCommits(OP_CONTEXT ctx, long timeInMicros, Hash toHead, List<CommitLogEntry> commitsToMergeChronological, Consumer<Hash> newKeyLists, MetadataRewriter<ByteString> rewriteMetadata, Predicate<Key> includeKeyPredicate, Iterable<Hash> additionalParents) throws ReferenceConflictException, ReferenceNotFoundException {
        int keyListDistance;
        long commitSeq;
        ArrayList<ByteString> commitMeta = new ArrayList<ByteString>();
        LinkedHashMap<Key, KeyWithBytes> puts = new LinkedHashMap<Key, KeyWithBytes>();
        LinkedHashSet<Key> deletes = new LinkedHashSet<Key>();
        for (int i = commitsToMergeChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry source = commitsToMergeChronological.get(i);
            for (Key delete : source.getDeletes()) {
                if (!includeKeyPredicate.test(delete)) continue;
                deletes.add(delete);
                puts.remove(delete);
            }
            for (KeyWithBytes put : source.getPuts()) {
                if (!includeKeyPredicate.test(put.getKey())) continue;
                deletes.remove(put.getKey());
                puts.put(put.getKey(), put);
            }
            commitMeta.add(source.getMetadata());
        }
        if (puts.isEmpty() && deletes.isEmpty()) {
            return null;
        }
        ByteString newCommitMeta = (ByteString)rewriteMetadata.squash(commitMeta);
        CommitLogEntry targetHeadCommit = this.fetchFromCommitLog(ctx, toHead);
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> parents = new ArrayList<Hash>(parentsPerCommit);
        parents.add(toHead);
        if (targetHeadCommit != null) {
            List<Hash> p = targetHeadCommit.getParents();
            parents.addAll(p.subList(0, Math.min(p.size(), parentsPerCommit - 1)));
            commitSeq = targetHeadCommit.getCommitSeq() + 1L;
            keyListDistance = targetHeadCommit.getKeyListDistance();
        } else {
            commitSeq = 1L;
            keyListDistance = 0;
        }
        CommitLogEntry squashedCommit = this.buildIndividualCommit(ctx, timeInMicros, parents, commitSeq, newCommitMeta, puts.values(), deletes, keyListDistance, newKeyLists, h -> null, additionalParents);
        if (commitsToMergeChronological.size() == 1) {
            CommitLogEntry single = commitsToMergeChronological.get(0);
            if (squashedCommit.getHash().equals(single.getHash()) && squashedCommit.getPuts().equals(single.getPuts()) && squashedCommit.getDeletes().equals(single.getDeletes()) && squashedCommit.getMetadata().equals((Object)single.getMetadata())) {
                return single;
            }
        }
        this.writeIndividualCommit(ctx, squashedCommit);
        return squashedCommit;
    }

    protected Hash copyCommits(OP_CONTEXT ctx, long timeInMicros, Hash targetHead, List<CommitLogEntry> commitsChronological, Consumer<Hash> newKeyLists, MetadataRewriter<ByteString> rewriteMetadata, Predicate<Key> includeKeyPredicate) throws ReferenceNotFoundException {
        long commitSeq;
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> parents = new ArrayList<Hash>(parentsPerCommit);
        CommitLogEntry targetHeadCommit = this.fetchFromCommitLog(ctx, targetHead);
        if (targetHeadCommit != null) {
            parents.addAll(targetHeadCommit.getParents());
            commitSeq = targetHeadCommit.getCommitSeq() + 1L;
        } else {
            commitSeq = 1L;
        }
        int keyListDistance = targetHeadCommit != null ? targetHeadCommit.getKeyListDistance() : 0;
        HashMap<Hash, CommitLogEntry> unwrittenCommits = new HashMap<Hash, CommitLogEntry>();
        int i = commitsChronological.size() - 1;
        while (i >= 0) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            List<KeyWithBytes> puts = sourceCommit.getPuts().stream().filter(p -> includeKeyPredicate.test(p.getKey())).collect(Collectors.toList());
            List<Key> deletes = sourceCommit.getDeletes().stream().filter(includeKeyPredicate).collect(Collectors.toList());
            if (puts.isEmpty() && deletes.isEmpty()) {
                commitsChronological.remove(i);
            } else {
                while (parents.size() > parentsPerCommit - 1) {
                    parents.remove(parentsPerCommit - 1);
                }
                if (parents.isEmpty()) {
                    parents.add(targetHead);
                } else {
                    parents.add(0, targetHead);
                }
                ByteString updatedMetadata = (ByteString)rewriteMetadata.rewriteSingle((Object)sourceCommit.getMetadata());
                CommitLogEntry newEntry = this.buildIndividualCommit(ctx, timeInMicros, parents, commitSeq, updatedMetadata, puts, deletes, keyListDistance, newKeyLists, unwrittenCommits::get, Collections.emptyList());
                keyListDistance = newEntry.getKeyListDistance();
                unwrittenCommits.put(newEntry.getHash(), newEntry);
                if (!newEntry.getHash().equals(sourceCommit.getHash())) {
                    commitsChronological.set(i, newEntry);
                } else {
                    commitsChronological.remove(i);
                }
                targetHead = newEntry.getHash();
            }
            --i;
            ++commitSeq;
        }
        return targetHead;
    }

    protected void checkExpectedGlobalStates(OP_CONTEXT ctx, CommitParams commitParams, Consumer<String> mismatches) throws ReferenceNotFoundException {
        Map<ContentId, Optional<ByteString>> expectedStates = commitParams.getExpectedStates();
        if (expectedStates.isEmpty()) {
            return;
        }
        Map<ContentId, ByteString> globalStates = this.fetchGlobalStates(ctx, expectedStates.keySet());
        for (Map.Entry<ContentId, Optional<ByteString>> expectedState : expectedStates.entrySet()) {
            ByteString currentState = globalStates.get(expectedState.getKey());
            if (currentState == null) {
                if (!expectedState.getValue().isPresent()) continue;
                mismatches.accept(String.format("No current global-state for content-id '%s'.", expectedState.getKey()));
                continue;
            }
            if (!expectedState.getValue().isPresent()) {
                mismatches.accept(String.format("Global-state for content-id '%s' already exists.", expectedState.getKey()));
                continue;
            }
            if (currentState.equals((Object)expectedState.getValue().get())) continue;
            mismatches.accept(String.format("Mismatch in global-state for content-id '%s'.", expectedState.getKey()));
        }
    }

    protected final RefLog fetchFromRefLog(OP_CONTEXT ctx, Hash refLogId) {
        try (Traced ignore = Traced.trace("fetchFromRefLog").tag(TAG_HASH, refLogId != null ? refLogId.asString() : "HEAD");){
            RefLog refLog = this.doFetchFromRefLog(ctx, refLogId);
            return refLog;
        }
    }

    protected abstract RefLog doFetchFromRefLog(OP_CONTEXT var1, Hash var2);

    protected final List<RefLog> fetchPageFromRefLog(OP_CONTEXT ctx, List<Hash> hashes) {
        if (hashes.isEmpty()) {
            return Collections.emptyList();
        }
        try (Traced ignore = Traced.trace("fetchPageFromRefLog").tag(TAG_HASH, hashes.get(0).asString()).tag(TAG_COUNT, hashes.size());){
            List<RefLog> list = this.doFetchPageFromRefLog(ctx, hashes);
            return list;
        }
    }

    protected abstract List<RefLog> doFetchPageFromRefLog(OP_CONTEXT var1, List<Hash> var2);

    @MustBeClosed
    protected Stream<RefLog> readRefLogStream(OP_CONTEXT ctx, Hash initialHash) throws RefLogNotFoundException {
        Spliterator<RefLog> split = this.readRefLog(ctx, initialHash);
        return StreamSupport.stream(split, false);
    }

    protected abstract Spliterator<RefLog> readRefLog(OP_CONTEXT var1, Hash var2) throws RefLogNotFoundException;

    protected void tryLoopStateCompletion(@javax.annotation.Nonnull @Nonnull Boolean success, TryLoopState state) {
        DatabaseAdapterMetrics.tryLoopFinished(success != false ? "success" : "fail", state.getRetries(), state.getDuration(TimeUnit.NANOSECONDS));
    }

    protected void repositoryEvent(Supplier<? extends AdapterEvent.Builder<?, ?>> eventBuilder) {
        if (this.eventConsumer != null && eventBuilder != null) {
            Object event = eventBuilder.get().eventTimeMicros(this.config.currentTimeInMicros()).build();
            try {
                this.eventConsumer.accept((AdapterEvent)event);
            }
            catch (RuntimeException e) {
                AbstractDatabaseAdapter.repositoryEventDeliveryFailed(event, e);
            }
        }
    }

    private static void repositoryEventDeliveryFailed(AdapterEvent event, RuntimeException e) {
        LOGGER.warn("Repository event delivery failed for operation type {}", (Object)event.getOperationType(), (Object)e);
        Tracer t = GlobalTracer.get();
        Span span = t.activeSpan();
        Span log = span.log((Map)ImmutableMap.of((Object)"event", (Object)Tags.ERROR.getKey(), (Object)"message", (Object)"Repository event delivery failed", (Object)"error.object", (Object)e));
        Tags.ERROR.set(log, Boolean.valueOf(true));
    }

    protected abstract void persistAttachments(OP_CONTEXT var1, Stream<ContentAttachment> var2);

    protected final class CommonAncestorState {
        final Iterator<Hash> toLog;
        final List<Hash> toCommitHashesList;
        final Set<Hash> toCommitHashes = new HashSet<Hash>();
        final /* synthetic */ AbstractDatabaseAdapter this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CommonAncestorState(OP_CONTEXT ctx, Hash toHead, boolean trackCount) {
            this.this$0 = (AbstractDatabaseAdapter)this$0;
            this.toLog = Spliterators.iterator(this$0.readCommitLogHashes(ctx, toHead));
            this.toCommitHashesList = trackCount ? new ArrayList() : null;
        }

        boolean fetchNext() {
            if (this.toLog.hasNext()) {
                Hash hash = this.toLog.next();
                this.toCommitHashes.add(hash);
                if (this.toCommitHashesList != null) {
                    this.toCommitHashesList.add(hash);
                }
                return true;
            }
            return false;
        }

        public boolean contains(Hash candidate) {
            return this.toCommitHashes.contains(candidate);
        }

        public int indexOf(Hash hash) {
            return this.toCommitHashesList.indexOf(hash);
        }
    }

    protected static final class ConflictingKeyCheckResult {
        private boolean sinceSeen;
        private CommitLogEntry headCommit;

        protected ConflictingKeyCheckResult() {
        }

        public boolean isSinceSeen() {
            return this.sinceSeen;
        }

        public CommitLogEntry getHeadCommit() {
            return this.headCommit;
        }
    }
}

