/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableKeyList;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;

class KeyListBuildState {
    static final int MINIMUM_BUCKET_SIZE = 4096;
    private final ImmutableCommitLogEntry.Builder newCommitEntry;
    private final int maxEmbeddedKeyListSize;
    private final int maxKeyListEntitySize;
    private final float loadFactor;
    private final ToIntFunction<KeyListEntry> serializedEntrySize;
    private final List<KeyListEntry> entries = new ArrayList<KeyListEntry>();

    KeyListBuildState(ImmutableCommitLogEntry.Builder newCommitEntry, int maxEmbeddedKeyListSize, int maxKeyListEntitySize, float loadFactor, ToIntFunction<KeyListEntry> serializedEntrySize) {
        this.newCommitEntry = newCommitEntry;
        this.maxEmbeddedKeyListSize = maxEmbeddedKeyListSize;
        this.maxKeyListEntitySize = maxKeyListEntitySize;
        this.loadFactor = loadFactor;
        this.serializedEntrySize = serializedEntrySize;
    }

    void add(KeyListEntry entry) {
        this.entries.add(entry);
    }

    static int nextPowerOfTwo(int v) {
        Preconditions.checkArgument((0 <= v && v <= 0x40000000 ? 1 : 0) != 0, (String)"Parameter %s must be between 0 and 2^30 (both inclusive)", (int)v);
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    List<KeyListEntity> finish() {
        int openAddressingBuckets = this.openAddressingBucketCount();
        int openAddressingMask = openAddressingBuckets - 1;
        KeyListEntry[] openAddressingHashMap = new KeyListEntry[openAddressingBuckets];
        block0: for (KeyListEntry entry : this.entries) {
            int bucket;
            int hash = entry.getKey().hashCode();
            int i = bucket = hash & openAddressingMask;
            while (true) {
                if (openAddressingHashMap[i] == null) {
                    openAddressingHashMap[i] = entry;
                    continue block0;
                }
                if (++i != openAddressingBuckets) continue;
                i = 0;
            }
        }
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        ArrayList<ImmutableKeyList> keyLists = new ArrayList<ImmutableKeyList>();
        int segmentSize = 0;
        int maxSegmentSize = this.maxEmbeddedKeyListSize;
        ImmutableKeyList.Builder keyListBuilder = ImmutableKeyList.builder();
        for (int i = 0; i < openAddressingHashMap.length; ++i) {
            KeyListEntry entry = openAddressingHashMap[i];
            if (entry != null) {
                int entrySize = this.serializedEntrySize.applyAsInt(entry);
                if (segmentSize + entrySize > maxSegmentSize) {
                    maxSegmentSize = this.maxKeyListEntitySize;
                    offsets.add(i);
                    keyLists.add(keyListBuilder.build());
                    keyListBuilder = ImmutableKeyList.builder();
                    segmentSize = 0;
                }
                segmentSize += entrySize;
            }
            keyListBuilder.addKeys(entry);
        }
        if (segmentSize > 0) {
            keyLists.add(keyListBuilder.build());
        }
        if (!keyLists.isEmpty()) {
            this.newCommitEntry.keyList((KeyList)keyLists.get(0));
        } else {
            this.newCommitEntry.keyList(KeyList.EMPTY);
        }
        this.newCommitEntry.keyListLoadFactor(Float.valueOf(this.loadFactor));
        this.newCommitEntry.keyListBucketCount(openAddressingBuckets);
        List<KeyListEntity> builtEntities = keyLists.stream().skip(1L).map(keyList -> KeyListEntity.of(DatabaseAdapterUtil.randomHash(), keyList)).collect(Collectors.toList());
        if (!builtEntities.isEmpty()) {
            builtEntities.stream().map(KeyListEntity::getId).forEach(this.newCommitEntry::addKeyListsIds);
            this.newCommitEntry.addAllKeyListEntityOffsets(offsets);
        }
        return builtEntities;
    }

    @VisibleForTesting
    int openAddressingBucketCount() {
        return KeyListBuildState.nextPowerOfTwo((int)((float)this.entries.size() / this.loadFactor));
    }
}

