/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.spi.Traced;

public class TryLoopState
implements AutoCloseable {
    private static final String TAG_ATTEMPT = "try-loop.attempt";
    private static final String TAG_RETRIES = "try-loop.retries";
    private static final String TAG_ENDLESS_RETRIES = "try-loop.endless-retries";
    private Traced traced;
    private final String opName;
    private final MonotonicClock monotonicClock;
    private final long t0;
    private final long maxTime;
    private final int maxRetries;
    private final Function<TryLoopState, String> retryErrorMessage;
    private final BiConsumer<Boolean, TryLoopState> completionNotifier;
    private final long maxSleep;
    private final long initialLowerBound;
    private final long initialUpperBound;
    private long lowerBound;
    private long upperBound;
    private int retries;
    private int endlessRetries;
    private boolean unsuccessful;

    TryLoopState(String opName, Function<TryLoopState, String> retryErrorMessage, DatabaseAdapterConfig config, MonotonicClock monotonicClock, BiConsumer<Boolean, TryLoopState> completionNotifier) {
        this.opName = opName;
        this.retryErrorMessage = retryErrorMessage;
        this.maxTime = TimeUnit.MILLISECONDS.toNanos(config.getCommitTimeout());
        this.maxRetries = config.getCommitRetries();
        this.monotonicClock = monotonicClock;
        this.t0 = monotonicClock.currentNanos();
        this.lowerBound = this.initialLowerBound = config.getRetryInitialSleepMillisLower();
        this.upperBound = this.initialUpperBound = config.getRetryInitialSleepMillisUpper();
        this.maxSleep = config.getRetryMaxSleepMillis();
        this.completionNotifier = completionNotifier;
        this.start();
    }

    public static TryLoopState newTryLoopState(String opName, Function<TryLoopState, String> retryErrorMessage, BiConsumer<Boolean, TryLoopState> completionNotifier, DatabaseAdapterConfig config) {
        return new TryLoopState("try-loop." + opName, retryErrorMessage, config, DefaultMonotonicClock.INSTANCE, completionNotifier);
    }

    public int getRetries() {
        return this.retries;
    }

    public int getEndlessRetries() {
        return this.endlessRetries;
    }

    public int getTotalRetries() {
        return this.retries + this.endlessRetries;
    }

    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.monotonicClock.currentNanos() - this.t0, TimeUnit.NANOSECONDS);
    }

    public Hash success(Hash result) {
        this.completionNotifier.accept(true, this);
        return result;
    }

    private ReferenceRetryFailureException unsuccessful() {
        this.completionNotifier.accept(false, this);
        return new ReferenceRetryFailureException(this.retryErrorMessage.apply(this), this.getTotalRetries(), this.getDuration(TimeUnit.MILLISECONDS));
    }

    public void retry() throws ReferenceRetryFailureException {
        if (this.unsuccessful) {
            throw this.unsuccessful();
        }
        this.stop();
        ++this.retries;
        long current = this.monotonicClock.currentNanos();
        long elapsed = current - this.t0;
        if (this.maxTime < elapsed || this.maxRetries < this.retries + this.endlessRetries) {
            this.unsuccessful = true;
            throw this.unsuccessful();
        }
        this.sleepAndBackoff(elapsed);
        this.start();
    }

    public void resetBounds() {
        this.lowerBound = this.initialLowerBound;
        this.upperBound = this.initialUpperBound;
    }

    public void retryEndless() throws ReferenceRetryFailureException {
        if (this.unsuccessful) {
            throw this.unsuccessful();
        }
        this.stop();
        ++this.endlessRetries;
        this.sleepAndBackoff(0L);
        this.start();
    }

    private void sleepAndBackoff(long elapsed) {
        long sleepMillis = ThreadLocalRandom.current().nextLong(this.lowerBound, this.upperBound);
        sleepMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(this.maxTime - elapsed), sleepMillis);
        this.monotonicClock.sleepMillis(sleepMillis);
        long upper = this.upperBound * 2L;
        if (upper <= this.maxSleep) {
            this.lowerBound *= 2L;
            this.upperBound = upper;
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private void start() {
        this.traced = Traced.trace(this.opName).tag(TAG_ATTEMPT, this.getTotalRetries());
    }

    private void stop() {
        this.traced.tag(TAG_RETRIES, this.getRetries()).tag(TAG_ENDLESS_RETRIES, this.getEndlessRetries()).close();
    }

    static final class DefaultMonotonicClock
    implements MonotonicClock {
        static final MonotonicClock INSTANCE = new DefaultMonotonicClock();

        private DefaultMonotonicClock() {
        }

        @Override
        public long currentNanos() {
            return System.nanoTime();
        }

        @Override
        public void sleepMillis(long sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static interface MonotonicClock {
        public long currentNanos();

        public void sleepMillis(long var1);
    }
}

