/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyList", generator="Immutables")
@Immutable
public final class ImmutableKeyList
implements KeyList {
    private final List<KeyListEntry> keys;

    private ImmutableKeyList(List<KeyListEntry> keys) {
        this.keys = keys;
    }

    @Override
    public List<KeyListEntry> getKeys() {
        return this.keys;
    }

    public final ImmutableKeyList withKeys(KeyListEntry ... elements) {
        List<KeyListEntry> newValue = ImmutableKeyList.createUnmodifiableList(false, ImmutableKeyList.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableKeyList(newValue);
    }

    public final ImmutableKeyList withKeys(Iterable<? extends KeyListEntry> elements) {
        if (this.keys == elements) {
            return this;
        }
        List<KeyListEntry> newValue = ImmutableKeyList.createUnmodifiableList(false, ImmutableKeyList.createSafeList(elements, false, false));
        return new ImmutableKeyList(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyList && this.equalTo(0, (ImmutableKeyList)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyList another) {
        return this.keys.equals(another.keys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keys.hashCode();
        return h;
    }

    public String toString() {
        return "KeyList{keys=" + this.keys + "}";
    }

    public static ImmutableKeyList copyOf(KeyList instance) {
        if (instance instanceof ImmutableKeyList) {
            return (ImmutableKeyList)instance;
        }
        return ImmutableKeyList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="KeyList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<KeyListEntry> keys = new ArrayList<KeyListEntry>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyList instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllKeys(instance.getKeys());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(@Nullable KeyListEntry element) {
            this.keys.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(KeyListEntry ... elements) {
            for (KeyListEntry element : elements) {
                this.keys.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keys(Iterable<? extends KeyListEntry> elements) {
            this.keys.clear();
            return this.addAllKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeys(Iterable<? extends KeyListEntry> elements) {
            for (KeyListEntry keyListEntry : elements) {
                this.keys.add(keyListEntry);
            }
            return this;
        }

        public ImmutableKeyList build() {
            return new ImmutableKeyList(ImmutableKeyList.createUnmodifiableList(true, this.keys));
        }
    }
}

