/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.persist.adapter.ContentAndState;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentAndState", generator="Immutables")
@Immutable
public final class ImmutableContentAndState
implements ContentAndState {
    private final byte payload;
    private final ByteString refState;
    @jakarta.annotation.Nullable
    private final ByteString globalState;

    private ImmutableContentAndState(byte payload, ByteString refState, @jakarta.annotation.Nullable ByteString globalState) {
        this.payload = payload;
        this.refState = Objects.requireNonNull(refState, "refState");
        this.globalState = globalState;
    }

    private ImmutableContentAndState(ImmutableContentAndState original, byte payload, ByteString refState, @jakarta.annotation.Nullable ByteString globalState) {
        this.payload = payload;
        this.refState = refState;
        this.globalState = globalState;
    }

    @Override
    public byte getPayload() {
        return this.payload;
    }

    @Override
    public ByteString getRefState() {
        return this.refState;
    }

    @Override
    @jakarta.annotation.Nullable
    public ByteString getGlobalState() {
        return this.globalState;
    }

    public final ImmutableContentAndState withPayload(byte value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableContentAndState(this, value, this.refState, this.globalState);
    }

    public final ImmutableContentAndState withRefState(ByteString value) {
        if (this.refState == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "refState");
        return new ImmutableContentAndState(this, this.payload, newValue, this.globalState);
    }

    public final ImmutableContentAndState withGlobalState(@jakarta.annotation.Nullable ByteString value) {
        if (this.globalState == value) {
            return this;
        }
        return new ImmutableContentAndState(this, this.payload, this.refState, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentAndState && this.equalTo(0, (ImmutableContentAndState)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentAndState another) {
        return this.payload == another.payload && this.refState.equals((Object)another.refState) && Objects.equals(this.globalState, another.globalState);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Bytes.hashCode((byte)this.payload);
        h += (h << 5) + this.refState.hashCode();
        h += (h << 5) + Objects.hashCode(this.globalState);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentAndState").omitNullValues().add("payload", (int)this.payload).add("refState", (Object)this.refState).add("globalState", (Object)this.globalState).toString();
    }

    public static ImmutableContentAndState of(byte payload, ByteString refState, @jakarta.annotation.Nullable ByteString globalState) {
        return new ImmutableContentAndState(payload, refState, globalState);
    }

    public static ImmutableContentAndState copyOf(ContentAndState instance) {
        if (instance instanceof ImmutableContentAndState) {
            return (ImmutableContentAndState)instance;
        }
        return ImmutableContentAndState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentAndState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_REF_STATE = 2L;
        private long initBits = 3L;
        private byte payload;
        @Nullable
        private ByteString refState;
        @Nullable
        private ByteString globalState;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentAndState instance) {
            Objects.requireNonNull(instance, "instance");
            this.payload(instance.getPayload());
            this.refState(instance.getRefState());
            ByteString globalStateValue = instance.getGlobalState();
            if (globalStateValue != null) {
                this.globalState(globalStateValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(byte payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refState(ByteString refState) {
            this.refState = Objects.requireNonNull(refState, "refState");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder globalState(@jakarta.annotation.Nullable ByteString globalState) {
            this.globalState = globalState;
            return this;
        }

        public ImmutableContentAndState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentAndState(null, this.payload, this.refState, this.globalState);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("refState");
            }
            return "Cannot build ContentAndState, some of required attributes are not set " + attributes;
        }
    }
}

