/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.ToBranchParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeParams", generator="Immutables")
@Immutable
public final class ImmutableMergeParams
implements MergeParams {
    private final BranchName toBranch;
    private final Optional<Hash> expectedHead;
    private final NamedRef fromRef;
    private final boolean keepIndividualCommits;
    private final ImmutableMap<ContentKey, MergeType> mergeTypes;
    private final boolean isDryRun;
    private final MergeType defaultMergeType;
    private final MetadataRewriter<ByteString> updateCommitMetadata;
    private final Hash mergeFromHash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMergeParams(Builder builder) {
        this.toBranch = builder.toBranch;
        this.fromRef = builder.fromRef;
        this.mergeTypes = builder.mergeTypes.build();
        this.updateCommitMetadata = builder.updateCommitMetadata;
        this.mergeFromHash = builder.mergeFromHash;
        if (builder.expectedHead != null) {
            this.initShim.expectedHead(builder.expectedHead);
        }
        if (builder.keepIndividualCommitsIsSet()) {
            this.initShim.keepIndividualCommits(builder.keepIndividualCommits);
        }
        if (builder.isDryRunIsSet()) {
            this.initShim.isDryRun(builder.isDryRun);
        }
        if (builder.defaultMergeType != null) {
            this.initShim.defaultMergeType(builder.defaultMergeType);
        }
        this.expectedHead = this.initShim.getExpectedHead();
        this.keepIndividualCommits = this.initShim.keepIndividualCommits();
        this.isDryRun = this.initShim.isDryRun();
        this.defaultMergeType = this.initShim.getDefaultMergeType();
        this.initShim = null;
    }

    private ImmutableMergeParams(BranchName toBranch, Optional<Hash> expectedHead, NamedRef fromRef, boolean keepIndividualCommits, ImmutableMap<ContentKey, MergeType> mergeTypes, boolean isDryRun, MergeType defaultMergeType, MetadataRewriter<ByteString> updateCommitMetadata, Hash mergeFromHash) {
        this.toBranch = toBranch;
        this.expectedHead = expectedHead;
        this.fromRef = fromRef;
        this.keepIndividualCommits = keepIndividualCommits;
        this.mergeTypes = mergeTypes;
        this.isDryRun = isDryRun;
        this.defaultMergeType = defaultMergeType;
        this.updateCommitMetadata = updateCommitMetadata;
        this.mergeFromHash = mergeFromHash;
        this.initShim = null;
    }

    private Optional<Hash> getExpectedHeadInitialize() {
        return MergeParams.super.getExpectedHead();
    }

    private boolean keepIndividualCommitsInitialize() {
        return MergeParams.super.keepIndividualCommits();
    }

    private boolean isDryRunInitialize() {
        return MergeParams.super.isDryRun();
    }

    private MergeType getDefaultMergeTypeInitialize() {
        return MergeParams.super.getDefaultMergeType();
    }

    @Override
    public BranchName getToBranch() {
        return this.toBranch;
    }

    @Override
    public Optional<Hash> getExpectedHead() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExpectedHead() : this.expectedHead;
    }

    @Override
    public NamedRef getFromRef() {
        return this.fromRef;
    }

    @Override
    public boolean keepIndividualCommits() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keepIndividualCommits() : this.keepIndividualCommits;
    }

    public ImmutableMap<ContentKey, MergeType> getMergeTypes() {
        return this.mergeTypes;
    }

    @Override
    public boolean isDryRun() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDryRun() : this.isDryRun;
    }

    @Override
    public MergeType getDefaultMergeType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultMergeType() : this.defaultMergeType;
    }

    @Override
    public MetadataRewriter<ByteString> getUpdateCommitMetadata() {
        return this.updateCommitMetadata;
    }

    @Override
    public Hash getMergeFromHash() {
        return this.mergeFromHash;
    }

    public final ImmutableMergeParams withToBranch(BranchName value) {
        if (this.toBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "toBranch");
        return new ImmutableMergeParams(newValue, this.expectedHead, this.fromRef, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withExpectedHead(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
        if (this.expectedHead.equals(newValue)) {
            return this;
        }
        return new ImmutableMergeParams(this.toBranch, newValue, this.fromRef, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withFromRef(NamedRef value) {
        if (this.fromRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "fromRef");
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, newValue, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withKeepIndividualCommits(boolean value) {
        if (this.keepIndividualCommits == value) {
            return this;
        }
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, value, this.mergeTypes, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withMergeTypes(Map<? extends ContentKey, ? extends MergeType> entries) {
        if (this.mergeTypes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, this.keepIndividualCommits, (ImmutableMap<ContentKey, MergeType>)newValue, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withIsDryRun(boolean value) {
        if (this.isDryRun == value) {
            return this;
        }
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, this.keepIndividualCommits, this.mergeTypes, value, this.defaultMergeType, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withDefaultMergeType(MergeType value) {
        MergeType newValue = Objects.requireNonNull(value, "defaultMergeType");
        if (this.defaultMergeType == newValue) {
            return this;
        }
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, newValue, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withUpdateCommitMetadata(MetadataRewriter<ByteString> value) {
        if (this.updateCommitMetadata == value) {
            return this;
        }
        MetadataRewriter<ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, this.defaultMergeType, newValue, this.mergeFromHash);
    }

    public final ImmutableMergeParams withMergeFromHash(Hash value) {
        if (this.mergeFromHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "mergeFromHash");
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.fromRef, this.keepIndividualCommits, this.mergeTypes, this.isDryRun, this.defaultMergeType, this.updateCommitMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeParams && this.equalTo(0, (ImmutableMergeParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeParams another) {
        return this.toBranch.equals(another.toBranch) && this.expectedHead.equals(another.expectedHead) && this.fromRef.equals(another.fromRef) && this.keepIndividualCommits == another.keepIndividualCommits && this.mergeTypes.equals(another.mergeTypes) && this.isDryRun == another.isDryRun && this.defaultMergeType.equals((Object)another.defaultMergeType) && this.updateCommitMetadata.equals(another.updateCommitMetadata) && this.mergeFromHash.equals(another.mergeFromHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toBranch.hashCode();
        h += (h << 5) + this.expectedHead.hashCode();
        h += (h << 5) + this.fromRef.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.keepIndividualCommits);
        h += (h << 5) + this.mergeTypes.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isDryRun);
        h += (h << 5) + this.defaultMergeType.hashCode();
        h += (h << 5) + this.updateCommitMetadata.hashCode();
        h += (h << 5) + this.mergeFromHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergeParams").omitNullValues().add("toBranch", (Object)this.toBranch).add("expectedHead", this.expectedHead).add("fromRef", (Object)this.fromRef).add("keepIndividualCommits", this.keepIndividualCommits).add("mergeTypes", this.mergeTypes).add("isDryRun", this.isDryRun).add("defaultMergeType", (Object)this.defaultMergeType).add("updateCommitMetadata", this.updateCommitMetadata).add("mergeFromHash", (Object)this.mergeFromHash).toString();
    }

    public static ImmutableMergeParams copyOf(MergeParams instance) {
        if (instance instanceof ImmutableMergeParams) {
            return (ImmutableMergeParams)instance;
        }
        return ImmutableMergeParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements MergeParams.Builder {
        private static final long INIT_BIT_TO_BRANCH = 1L;
        private static final long INIT_BIT_FROM_REF = 2L;
        private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 4L;
        private static final long INIT_BIT_MERGE_FROM_HASH = 8L;
        private static final long OPT_BIT_KEEP_INDIVIDUAL_COMMITS = 1L;
        private static final long OPT_BIT_IS_DRY_RUN = 2L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private BranchName toBranch;
        @Nullable
        private Optional<Hash> expectedHead;
        @Nullable
        private NamedRef fromRef;
        private boolean keepIndividualCommits;
        private ImmutableMap.Builder<ContentKey, MergeType> mergeTypes = ImmutableMap.builder();
        private boolean isDryRun;
        @Nullable
        private MergeType defaultMergeType;
        @Nullable
        private MetadataRewriter<ByteString> updateCommitMetadata;
        @Nullable
        private Hash mergeFromHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MetadataRewriteParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ToBranchParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToBranchParams instance;
            long bits = 0L;
            if (object instanceof MergeParams) {
                instance = (MergeParams)object;
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata((MetadataRewriter)instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead((Optional)instance.getExpectedHead());
                    bits |= 2L;
                }
                this.mergeFromHash(instance.getMergeFromHash());
                if ((bits & 4L) == 0L) {
                    this.fromRef(instance.getFromRef());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.isDryRun(instance.isDryRun());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keepIndividualCommits(instance.keepIndividualCommits());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.defaultMergeType(instance.getDefaultMergeType());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllMergeTypes(instance.getMergeTypes());
                    bits |= 0x80L;
                }
            }
            if (object instanceof MetadataRewriteParams) {
                instance = (MetadataRewriteParams)object;
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata((MetadataRewriter)instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead((Optional)instance.getExpectedHead());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.fromRef(instance.getFromRef());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.isDryRun(instance.isDryRun());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.keepIndividualCommits(instance.keepIndividualCommits());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.defaultMergeType(instance.getDefaultMergeType());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllMergeTypes(instance.getMergeTypes());
                    bits |= 0x80L;
                }
            }
            if (object instanceof ToBranchParams) {
                instance = (ToBranchParams)object;
                if ((bits & 0x20L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead((Optional)instance.getExpectedHead());
                    bits |= 2L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder toBranch(BranchName toBranch) {
            this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fromRef(NamedRef fromRef) {
            this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder keepIndividualCommits(boolean keepIndividualCommits) {
            this.keepIndividualCommits = keepIndividualCommits;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putMergeTypes(ContentKey key, MergeType value) {
            this.mergeTypes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMergeTypes(Map.Entry<? extends ContentKey, ? extends MergeType> entry) {
            this.mergeTypes.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder mergeTypes(Map<? extends ContentKey, ? extends MergeType> entries) {
            this.mergeTypes = ImmutableMap.builder();
            return this.putAllMergeTypes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMergeTypes(Map<? extends ContentKey, ? extends MergeType> entries) {
            this.mergeTypes.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultMergeType(MergeType defaultMergeType) {
            this.defaultMergeType = Objects.requireNonNull(defaultMergeType, "defaultMergeType");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder updateCommitMetadata(MetadataRewriter<ByteString> updateCommitMetadata) {
            this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder mergeFromHash(Hash mergeFromHash) {
            this.mergeFromHash = Objects.requireNonNull(mergeFromHash, "mergeFromHash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public ImmutableMergeParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeParams(this);
        }

        private boolean keepIndividualCommitsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isDryRunIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("toBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromRef");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("updateCommitMetadata");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mergeFromHash");
            }
            return "Cannot build MergeParams, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MergeParams", generator="Immutables")
    private final class InitShim {
        private byte expectedHeadBuildStage = 0;
        private Optional<Hash> expectedHead;
        private byte keepIndividualCommitsBuildStage = 0;
        private boolean keepIndividualCommits;
        private byte isDryRunBuildStage = 0;
        private boolean isDryRun;
        private byte defaultMergeTypeBuildStage = 0;
        private MergeType defaultMergeType;

        private InitShim() {
        }

        Optional<Hash> getExpectedHead() {
            if (this.expectedHeadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedHeadBuildStage == 0) {
                this.expectedHeadBuildStage = (byte)-1;
                this.expectedHead = Objects.requireNonNull(ImmutableMergeParams.this.getExpectedHeadInitialize(), "expectedHead");
                this.expectedHeadBuildStage = 1;
            }
            return this.expectedHead;
        }

        void expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = expectedHead;
            this.expectedHeadBuildStage = 1;
        }

        boolean keepIndividualCommits() {
            if (this.keepIndividualCommitsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keepIndividualCommitsBuildStage == 0) {
                this.keepIndividualCommitsBuildStage = (byte)-1;
                this.keepIndividualCommits = ImmutableMergeParams.this.keepIndividualCommitsInitialize();
                this.keepIndividualCommitsBuildStage = 1;
            }
            return this.keepIndividualCommits;
        }

        void keepIndividualCommits(boolean keepIndividualCommits) {
            this.keepIndividualCommits = keepIndividualCommits;
            this.keepIndividualCommitsBuildStage = 1;
        }

        boolean isDryRun() {
            if (this.isDryRunBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDryRunBuildStage == 0) {
                this.isDryRunBuildStage = (byte)-1;
                this.isDryRun = ImmutableMergeParams.this.isDryRunInitialize();
                this.isDryRunBuildStage = 1;
            }
            return this.isDryRun;
        }

        void isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.isDryRunBuildStage = 1;
        }

        MergeType getDefaultMergeType() {
            if (this.defaultMergeTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultMergeTypeBuildStage == 0) {
                this.defaultMergeTypeBuildStage = (byte)-1;
                this.defaultMergeType = Objects.requireNonNull(ImmutableMergeParams.this.getDefaultMergeTypeInitialize(), "defaultMergeType");
                this.defaultMergeTypeBuildStage = 1;
            }
            return this.defaultMergeType;
        }

        void defaultMergeType(MergeType defaultMergeType) {
            this.defaultMergeType = defaultMergeType;
            this.defaultMergeTypeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.expectedHeadBuildStage == -1) {
                attributes.add("expectedHead");
            }
            if (this.keepIndividualCommitsBuildStage == -1) {
                attributes.add("keepIndividualCommits");
            }
            if (this.isDryRunBuildStage == -1) {
                attributes.add("isDryRun");
            }
            if (this.defaultMergeTypeBuildStage == -1) {
                attributes.add("defaultMergeType");
            }
            return "Cannot build MergeParams, attribute initializers form cycle " + attributes;
        }
    }
}

