/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentIdAndBytes", generator="Immutables")
@Immutable
public final class ImmutableContentIdAndBytes
implements ContentIdAndBytes {
    private final ContentId contentId;
    private final ByteString value;

    private ImmutableContentIdAndBytes(ContentId contentId, ByteString value) {
        this.contentId = contentId;
        this.value = value;
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public ByteString getValue() {
        return this.value;
    }

    public final ImmutableContentIdAndBytes withContentId(ContentId value) {
        if (this.contentId == value) {
            return this;
        }
        ContentId newValue = Objects.requireNonNull(value, "contentId");
        return new ImmutableContentIdAndBytes(newValue, this.value);
    }

    public final ImmutableContentIdAndBytes withValue(ByteString value) {
        if (this.value == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "value");
        return new ImmutableContentIdAndBytes(this.contentId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentIdAndBytes && this.equalTo(0, (ImmutableContentIdAndBytes)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentIdAndBytes another) {
        return this.contentId.equals(another.contentId) && this.value.equals((Object)another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentIdAndBytes").omitNullValues().add("contentId", (Object)this.contentId).add("value", (Object)this.value).toString();
    }

    public static ImmutableContentIdAndBytes copyOf(ContentIdAndBytes instance) {
        if (instance instanceof ImmutableContentIdAndBytes) {
            return (ImmutableContentIdAndBytes)instance;
        }
        return ImmutableContentIdAndBytes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentIdAndBytes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentId contentId;
        @Nullable
        private ByteString value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentIdAndBytes instance) {
            Objects.requireNonNull(instance, "instance");
            this.contentId(instance.getContentId());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(ContentId contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ByteString value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContentIdAndBytes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentIdAndBytes(this.contentId, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ContentIdAndBytes, some of required attributes are not set " + attributes;
        }
    }
}

