/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.inmem;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.InvalidProtocolBufferException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.inmem.InmemoryStore;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;

public class InmemoryDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private final InmemoryStore store;
    private final ByteString keyPrefix;

    public InmemoryDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, InmemoryStore store, AdapterEventConsumer eventConsumer) {
        super(config, eventConsumer);
        this.keyPrefix = ByteString.copyFromUtf8((String)(config.getRepositoryId() + ':'));
        Objects.requireNonNull(store, "Requires a non-null InmemoryStore from InmemoryDatabaseAdapterConfig");
        this.store = store;
    }

    private ByteString dbKey(Hash hash) {
        return this.keyPrefix.concat(hash.asBytes());
    }

    private ByteString dbKey(String name) {
        return this.dbKey(ByteString.copyFromUtf8((String)name));
    }

    private ByteString dbKey(int i) {
        return this.dbKey(Integer.toString(i));
    }

    private ByteString dbKey(ByteString key) {
        return this.keyPrefix.concat(key);
    }

    protected void doEraseRepo() {
        this.store.reinitializeRepo(this.keyPrefix);
    }

    protected AdapterTypes.GlobalStatePointer doFetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return this.globalState().get();
    }

    protected void unsafeWriteRefLogStripe(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents refLogParents) {
        this.store.refLogHeads.put(this.dbKey(stripe), refLogParents.toByteString());
    }

    protected AdapterTypes.RefLogParents doFetchRefLogParents(NonTransactionalOperationContext ctx, int stripe) {
        try {
            ByteString bytes = (ByteString)this.store.refLogHeads.get(this.dbKey(stripe));
            return bytes != null ? AdapterTypes.RefLogParents.parseFrom((ByteString)bytes) : null;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean doRefLogParentsCas(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents previousEntry, AdapterTypes.RefLogParents newEntry) {
        ByteString update = newEntry.toByteString();
        if (previousEntry != null) {
            ByteString expected = previousEntry.toByteString();
            return this.store.refLogHeads.replace(this.dbKey(stripe), expected, update);
        }
        return this.store.refLogHeads.putIfAbsent(this.dbKey(stripe), update) == null;
    }

    protected List<AdapterTypes.NamedReference> doFetchNamedReference(NonTransactionalOperationContext ctx, List<String> refNames) {
        return refNames.stream().map(refName -> (ByteString)this.store.refHeads.get(this.dbKey((String)refName))).filter(Objects::nonNull).map(serialized -> {
            try {
                return AdapterTypes.NamedReference.parseFrom((ByteString)serialized);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    protected boolean doCreateNamedReference(NonTransactionalOperationContext ctx, AdapterTypes.NamedReference namedReference) {
        ByteString existing = this.store.refHeads.putIfAbsent(this.dbKey(namedReference.getName()), namedReference.toByteString());
        return existing == null;
    }

    protected boolean doDeleteNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead) {
        AdapterTypes.NamedReference expected = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead).build();
        return this.store.refHeads.remove(this.dbKey(ref.getName()), expected.toByteString());
    }

    protected void doAddToNamedReferences(NonTransactionalOperationContext ctx, Stream<NamedRef> refStream, int addToSegment) {
        boolean bl;
        boolean success;
        Set refNamesToAdd = refStream.map(NamedRef::getName).collect(Collectors.toSet());
        do {
            AdapterTypes.ReferenceNames referenceNames;
            ByteString refNamesBytes = (ByteString)this.store.refNames.get(this.dbKey(addToSegment));
            try {
                referenceNames = refNamesBytes == null ? AdapterTypes.ReferenceNames.getDefaultInstance() : AdapterTypes.ReferenceNames.parseFrom((ByteString)refNamesBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            ByteString newRefNameBytes = referenceNames.toBuilder().addAllRefNames(refNamesToAdd).build().toByteString();
            if (refNamesBytes == null) {
                if (this.store.refNames.putIfAbsent(this.dbKey(addToSegment), newRefNameBytes) == null) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = this.store.refNames.replace(this.dbKey(addToSegment), refNamesBytes, newRefNameBytes);
        } while (!(success = bl));
    }

    protected void doRemoveFromNamedReferences(NonTransactionalOperationContext ctx, NamedRef ref, int removeFromSegment) {
        ByteString refNamesBytes;
        while ((refNamesBytes = (ByteString)this.store.refNames.get(this.dbKey(removeFromSegment))) != null) {
            AdapterTypes.ReferenceNames referenceNames;
            try {
                referenceNames = AdapterTypes.ReferenceNames.parseFrom((ByteString)refNamesBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            AdapterTypes.ReferenceNames.Builder newRefNames = referenceNames.toBuilder().clearRefNames();
            referenceNames.getRefNamesList().stream().filter(n -> !n.equals(ref.getName())).forEach(arg_0 -> ((AdapterTypes.ReferenceNames.Builder)newRefNames).addRefNames(arg_0));
            ByteString newRefNameBytes = newRefNames.build().toByteString();
            boolean success = this.store.refNames.replace(this.dbKey(removeFromSegment), refNamesBytes, newRefNameBytes);
            if (!success) continue;
            break;
        }
    }

    protected boolean doUpdateNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead, Hash newHead) {
        try {
            this.store.refHeads.compute(this.dbKey(ref.getName()), (k, existing) -> {
                AdapterTypes.NamedReference namedReference;
                if (existing == null) {
                    throw new RuntimeException((Throwable)DatabaseAdapterUtil.referenceNotFound((NamedRef)ref));
                }
                try {
                    namedReference = AdapterTypes.NamedReference.parseFrom((ByteString)existing);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                if (!namedReference.getRef().equals((Object)refHead)) {
                    throw new CasFailedException();
                }
                AdapterTypes.NamedReference newNamedReference = namedReference.toBuilder().setRef(namedReference.getRef().toBuilder().setHash(newHead.asBytes())).build();
                return newNamedReference.toByteString();
            });
            return true;
        }
        catch (CasFailedException e) {
            return false;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ReferenceNotFoundException) {
                return false;
            }
            throw e;
        }
    }

    protected void doWriteIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        if (this.store.commitLog.putIfAbsent(this.dbKey(entry.getHash()), ProtoSerialization.toProto((CommitLogEntry)entry).toByteString()) != null) {
            throw DatabaseAdapterUtil.hashCollisionDetected();
        }
    }

    protected void doWriteMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        for (CommitLogEntry entry : entries) {
            this.doWriteIndividualCommit(ctx, entry);
        }
    }

    protected void doUpdateMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceNotFoundException {
        for (CommitLogEntry entry : entries) {
            if (this.store.commitLog.replace(this.dbKey(entry.getHash()), ProtoSerialization.toProto((CommitLogEntry)entry).toByteString()) != null) continue;
            throw DatabaseAdapterUtil.referenceNotFound((Hash)entry.getHash());
        }
    }

    protected List<AdapterTypes.ReferenceNames> doFetchReferenceNames(NonTransactionalOperationContext ctx, int segment, int prefetchSegments) {
        return IntStream.rangeClosed(segment, segment + prefetchSegments).mapToObj(seg -> (ByteString)this.store.refNames.get(this.dbKey(seg))).map(s -> {
            try {
                return s != null ? AdapterTypes.ReferenceNames.parseFrom((ByteString)s) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        this.globalState().set(pointer);
    }

    protected boolean doGlobalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        return this.globalState().compareAndSet(expected, newPointer);
    }

    private AtomicReference<AdapterTypes.GlobalStatePointer> globalState() {
        return this.store.globalStatePointer.computeIfAbsent(this.keyPrefix, k -> new AtomicReference());
    }

    protected void doCleanUpCommitCas(NonTransactionalOperationContext ctx, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        branchCommits.forEach(h -> this.store.commitLog.remove(this.dbKey((Hash)h)));
        newKeyLists.forEach(h -> this.store.keyLists.remove(this.dbKey((Hash)h)));
    }

    protected void doCleanUpRefLogWrite(NonTransactionalOperationContext ctx, Hash refLogId) {
        this.store.refLog.remove(this.dbKey(refLogId));
    }

    protected AdapterTypes.GlobalStateLogEntry doFetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        ByteString serialized = (ByteString)this.store.globalStateLog.get(this.dbKey(id));
        try {
            return serialized != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((ByteString)serialized) : null;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<AdapterTypes.GlobalStateLogEntry> doFetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return hashes.stream().map(this::dbKey).map(this.store.globalStateLog::get).map(serialized -> {
            try {
                return serialized != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((ByteString)serialized) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    protected CommitLogEntry doFetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return ProtoSerialization.protoToCommitLogEntry((ByteString)((ByteString)this.store.commitLog.get(this.dbKey(hash))));
    }

    protected List<CommitLogEntry> doFetchMultipleFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return hashes.stream().map(this::dbKey).map(this.store.commitLog::get).map(ProtoSerialization::protoToCommitLogEntry).collect(Collectors.toList());
    }

    protected void doWriteKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        newKeyListEntities.forEach(e -> this.store.keyLists.put(this.dbKey(e.getId()), ProtoSerialization.toProto((KeyList)e.getKeys()).toByteString()));
    }

    protected Stream<KeyListEntity> doFetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        return keyListsIds.stream().map(hash -> {
            ByteString serialized = (ByteString)this.store.keyLists.get(this.dbKey((Hash)hash));
            return serialized != null ? KeyListEntity.of((Hash)hash, (KeyList)ProtoSerialization.protoToKeyList((ByteString)serialized)) : null;
        }).filter(Objects::nonNull);
    }

    protected RepoDescription doFetchRepositoryDescription(NonTransactionalOperationContext ctx) {
        AtomicReference ref = (AtomicReference)this.store.repoDesc.get(this.dbKey(ByteString.EMPTY));
        return ref != null ? (RepoDescription)ref.get() : null;
    }

    protected boolean doTryUpdateRepositoryDescription(NonTransactionalOperationContext ctx, RepoDescription expected, RepoDescription updateTo) {
        if (expected == null) {
            return this.store.repoDesc.putIfAbsent(this.dbKey(ByteString.EMPTY), new AtomicReference<RepoDescription>(updateTo)) == null;
        }
        return ((AtomicReference)this.store.repoDesc.get(this.dbKey(ByteString.EMPTY))).compareAndSet(expected, updateTo);
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyListEntry entry) {
        return ProtoSerialization.toProto((KeyListEntry)entry).getSerializedSize();
    }

    protected void doWriteRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        if (this.store.refLog.putIfAbsent(this.dbKey(entry.getRefLogId()), entry.toByteString()) != null) {
            throw new ReferenceConflictException(" RefLog Hash collision detected");
        }
    }

    protected RefLog doFetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        Objects.requireNonNull(refLogId, "refLogId mut not be null");
        return ProtoSerialization.protoToRefLog((ByteString)((ByteString)this.store.refLog.get(this.dbKey(refLogId))));
    }

    protected List<RefLog> doFetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return hashes.stream().map(this::dbKey).map(this.store.refLog::get).map(ProtoSerialization::protoToRefLog).collect(Collectors.toList());
    }

    protected Stream<CommitLogEntry> doScanAllCommitLogEntries(NonTransactionalOperationContext c) {
        return this.store.commitLog.entrySet().stream().filter(e -> ((ByteString)e.getKey()).startsWith(this.keyPrefix)).map(Map.Entry::getValue).map(ProtoSerialization::protoToCommitLogEntry);
    }

    private static final class CasFailedException
    extends RuntimeException {
        CasFailedException() {
        }
    }
}

