/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.nontx;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Hashable;
import org.projectnessie.versioned.ImmutableCommitResult;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.ImmutableReferenceAssignedResult;
import org.projectnessie.versioned.ImmutableReferenceCreatedResult;
import org.projectnessie.versioned.ImmutableReferenceDeletedResult;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.ResultType;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.events.CommitEvent;
import org.projectnessie.versioned.persist.adapter.events.MergeEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceAssignedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceCreatedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceDeletedEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryErasedEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryInitializedEvent;
import org.projectnessie.versioned.persist.adapter.events.TransplantEvent;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.spi.BatchSpliterator;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.Traced;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.nontx.ReferenceNamesSpliterator;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;

public abstract class NonTransactionalDatabaseAdapter<CONFIG extends NonTransactionalDatabaseAdapterConfig>
extends AbstractDatabaseAdapter<NonTransactionalOperationContext, CONFIG> {
    public static final String TAG_COMMIT_COUNT = "commit-count";
    public static final String TAG_KEY_LIST_COUNT = "key-list-count";
    public static final String TAG_REF = "ref";

    protected NonTransactionalDatabaseAdapter(CONFIG config, AdapterEventConsumer eventConsumer) {
        super(config, eventConsumer);
    }

    public NonTransactionalOperationContext borrowConnection() {
        return NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.hashOnRef(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, namedReference, hashOnReference);
    }

    public Map<ContentKey, ContentAndState> values(Hash commit, Collection<ContentKey> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.fetchValues(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commit, keys, keyFilter);
    }

    @MustBeClosed
    public Stream<CommitLogEntry> commitLog(Hash offset) throws ReferenceNotFoundException {
        return this.readCommitLogStream(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, offset);
    }

    public ReferenceInfo<ByteString> namedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null");
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        ReferenceInfo<ByteString> refHead = this.referenceHead(ctx, ref);
        Hash defaultBranchHead = this.namedRefsDefaultBranchHead(ctx, params);
        Stream<ReferenceInfo<ByteString>> refs = Stream.of(refHead);
        try (Stream refStream = this.namedRefsFilterAndEnhance(ctx, params, defaultBranchHead, refs);){
            ReferenceInfo referenceInfo = (ReferenceInfo)refStream.findFirst().orElseThrow(() -> DatabaseAdapterUtil.referenceNotFound((String)ref));
            return referenceInfo;
        }
    }

    @MustBeClosed
    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null.");
        Preconditions.checkArgument((boolean)NonTransactionalDatabaseAdapter.namedRefsAnyRetrieves((GetNamedRefsParams)params), (Object)"Must retrieve branches or tags or both.");
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        Stream<ReferenceInfo> refs = this.fetchNamedReferences(ctx).map(NonTransactionalDatabaseAdapter::namedReferenceToReferenceInfo);
        Hash defaultBranchHead = this.namedRefsDefaultBranchHead(ctx, params);
        return this.namedRefsFilterAndEnhance(ctx, params, defaultBranchHead, refs);
    }

    @MustBeClosed
    public Stream<KeyListEntry> keys(Hash commit, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.keysForCommitEntry(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commit, keyFilter);
    }

    public MergeResult<CommitLogEntry> merge(MergeParams mergeParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return (MergeResult)this.casOpLoop("merge", (NamedRef)mergeParams.getToBranch(), CasOpVariant.MERGE, (ctx, refHead, branchCommits, newKeyLists) -> {
                ImmutableMergeResult.Builder mergeResult = MergeResult.builder().resultType(ResultType.MERGE).sourceRef(mergeParams.getFromRef());
                Hash currentHead = Hash.of((ByteString)refHead.getHash());
                long timeInMicros = ((NonTransactionalDatabaseAdapterConfig)this.config).currentTimeInMicros();
                ArrayList writtenCommits = new ArrayList();
                Hash newHead = this.mergeAttempt(ctx, timeInMicros, currentHead, branchCommits, newKeyLists, writtenCommits::add, arg_0 -> ((ImmutableMergeResult.Builder)mergeResult).addCreatedCommits(arg_0), mergeParams, mergeResult);
                if (!mergeParams.isDryRun()) {
                    mergeResult.wasApplied(true);
                }
                mergeResult.resultantTargetHash(newHead);
                return CasOpResult.casOpResult(refHead, mergeResult.build(), () -> ((MergeEvent.Builder)((MergeEvent.Builder)((MergeEvent.Builder)MergeEvent.builder().previousHash(currentHead)).hash(newHead)).branch(mergeParams.getToBranch())).commits((Iterable)writtenCommits));
            }, () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Retry-failure", (MergeParams)mergeParams));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MergeResult<CommitLogEntry> transplant(TransplantParams transplantParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return (MergeResult)this.casOpLoop("transplant", (NamedRef)transplantParams.getToBranch(), CasOpVariant.MERGE, (ctx, refHead, branchCommits, newKeyLists) -> {
                ImmutableMergeResult.Builder mergeResult = MergeResult.builder().resultType(ResultType.TRANSPLANT).sourceRef(transplantParams.getFromRef());
                Hash currentHead = Hash.of((ByteString)refHead.getHash());
                long timeInMicros = ((NonTransactionalDatabaseAdapterConfig)this.config).currentTimeInMicros();
                ArrayList writtenCommits = new ArrayList();
                Hash newHead = this.transplantAttempt(ctx, timeInMicros, currentHead, branchCommits, newKeyLists, writtenCommits::add, arg_0 -> ((ImmutableMergeResult.Builder)mergeResult).addCreatedCommits(arg_0), transplantParams, mergeResult);
                if (!transplantParams.isDryRun()) {
                    mergeResult.wasApplied(true);
                }
                mergeResult.resultantTargetHash(newHead);
                return CasOpResult.casOpResult(refHead, mergeResult.build(), () -> ((TransplantEvent.Builder)((TransplantEvent.Builder)((TransplantEvent.Builder)TransplantEvent.builder().previousHash(currentHead)).hash(newHead)).branch(transplantParams.getToBranch())).commits((Iterable)writtenCommits));
            }, () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Retry-failure", (TransplantParams)transplantParams));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CommitResult<CommitLogEntry> commit(CommitParams commitParams) throws ReferenceConflictException, ReferenceNotFoundException {
        try {
            return (CommitResult)this.casOpLoop("commit", (NamedRef)commitParams.getToBranch(), CasOpVariant.COMMIT, (ctx, refHead, branchCommits, newKeyLists) -> {
                Hash currentHead = Hash.of((ByteString)refHead.getHash());
                ImmutableCommitResult.Builder commitResult = CommitResult.builder();
                long timeInMicros = ((NonTransactionalDatabaseAdapterConfig)this.config).currentTimeInMicros();
                CommitLogEntry newBranchCommit = this.commitAttempt(ctx, timeInMicros, currentHead, commitParams, newKeyLists);
                Hash newHead = newBranchCommit.getHash();
                branchCommits.accept(newHead);
                commitResult.targetBranch(commitParams.getToBranch()).commit((Hashable)newBranchCommit);
                return CasOpResult.casOpResult(refHead, commitResult.build(), () -> ((CommitEvent.Builder)((CommitEvent.Builder)((CommitEvent.Builder)CommitEvent.builder().previousHash(currentHead)).hash(newHead)).branch(commitParams.getToBranch())).addCommits(newBranchCommit));
            }, () -> DatabaseAdapterUtil.commitConflictMessage((String)"Retry-Failure", (BranchName)commitParams.getToBranch(), (Optional)commitParams.getExpectedHead()));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceCreatedResult create(NamedRef ref, Hash target) throws ReferenceAlreadyExistsException, ReferenceNotFoundException {
        try {
            return (ReferenceCreatedResult)this.casOpLoop("createRef", ref, CasOpVariant.CREATE_REF, (ctx, refHead, branchCommits, newKeyLists) -> {
                ImmutableReferenceCreatedResult.Builder result = ImmutableReferenceCreatedResult.builder().namedRef(ref);
                if (refHead != null) {
                    throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
                }
                Hash hash = target;
                if (hash == null) {
                    hash = NO_ANCESTOR;
                }
                this.validateHashExists(ctx, hash);
                Hash newHead = hash;
                result.hash(newHead);
                return CasOpResult.casOpResult(null, result.build(), () -> ((ReferenceCreatedEvent.Builder)ReferenceCreatedEvent.builder().currentHash(newHead)).ref(ref));
            }, () -> DatabaseAdapterUtil.createConflictMessage((String)"Retry-Failure", (NamedRef)ref, (Hash)target));
        }
        catch (RuntimeException | ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceDeletedResult delete(NamedRef reference, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return (ReferenceDeletedResult)this.casOpLoop("deleteRef", reference, CasOpVariant.DELETE_REF, (ctx, refHead, branchCommits, newKeyLists) -> {
                ImmutableReferenceDeletedResult.Builder result = ImmutableReferenceDeletedResult.builder().namedRef(reference);
                Hash currentHead = Hash.of((ByteString)refHead.getHash());
                DatabaseAdapterUtil.verifyExpectedHash((Hash)currentHead, (NamedRef)reference, (Optional)expectedHead);
                result.hash(currentHead);
                return CasOpResult.casOpResult(refHead, result.build(), () -> ((ReferenceDeletedEvent.Builder)ReferenceDeletedEvent.builder().currentHash(currentHead)).ref(reference));
            }, () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Retry-Failure", (NamedRef)reference, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceAssignedResult assign(NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return (ReferenceAssignedResult)this.casOpLoop("assignRef", assignee, CasOpVariant.REF_UPDATE, (ctx, refHead, branchCommits, newKeyLists) -> {
                ImmutableReferenceAssignedResult.Builder result = ImmutableReferenceAssignedResult.builder().namedRef(assignee);
                Hash beforeAssign = Hash.of((ByteString)refHead.getHash());
                DatabaseAdapterUtil.verifyExpectedHash((Hash)beforeAssign, (NamedRef)assignee, (Optional)expectedHead);
                this.validateHashExists(ctx, assignTo);
                result.previousHash(beforeAssign).currentHash(assignTo);
                return CasOpResult.casOpResult(refHead, result.build(), () -> ((ReferenceAssignedEvent.Builder)((ReferenceAssignedEvent.Builder)ReferenceAssignedEvent.builder().currentHash(assignTo)).ref(assignee)).previousHash(beforeAssign));
            }, () -> DatabaseAdapterUtil.assignConflictMessage((String)"Retry-Failure", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @MustBeClosed
    public Stream<Difference> diff(Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.buildDiff(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, from, to, keyFilter);
    }

    public void initializeRepo(String defaultBranchName) {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        if (this.fetchGlobalPointer(ctx) == null) {
            this.unsafeWriteGlobalPointer(ctx, AdapterTypes.GlobalStatePointer.newBuilder().setGlobalId(DatabaseAdapterUtil.randomHash().asBytes()).setGlobalLogHead(NO_ANCESTOR.asBytes()).setRefLogId(NO_ANCESTOR.asBytes()).addRefLogParentsInclHead(NO_ANCESTOR.asBytes()).addGlobalParentsInclHead(NO_ANCESTOR.asBytes()).build());
            this.repositoryEvent(() -> RepositoryInitializedEvent.builder().defaultBranch(defaultBranchName));
            BranchName defaultBranch = BranchName.of((String)defaultBranchName);
            Preconditions.checkState((boolean)this.createNamedReference(ctx, (NamedRef)defaultBranch, NO_ANCESTOR), (Object)"Could not create default branch");
            this.repositoryEvent(() -> ((ReferenceCreatedEvent.Builder)ReferenceCreatedEvent.builder().ref((NamedRef)defaultBranch)).currentHash(NO_ANCESTOR));
        }
    }

    public void eraseRepo() {
        this.doEraseRepo();
        this.repositoryEvent(RepositoryErasedEvent::builder);
    }

    protected abstract void doEraseRepo();

    public Optional<ContentIdAndBytes> globalContent(ContentId contentId) {
        return this.globalLogFetcher(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT).flatMap(e -> e.getPutsList().stream()).map(ProtoSerialization::protoToContentIdAndBytes).filter(entry -> contentId.equals(entry.getContentId())).map(cb -> ContentIdAndBytes.of((ContentId)cb.getContentId(), (ByteString)cb.getValue())).findFirst();
    }

    public RepoDescription fetchRepositoryDescription() {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        RepoDescription current = this.fetchRepositoryDescription(ctx);
        return current == null ? RepoDescription.DEFAULT : current;
    }

    public void updateRepositoryDescription(Function<RepoDescription, RepoDescription> updater) throws ReferenceConflictException {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        try (TryLoopState tryState = TryLoopState.newTryLoopState((String)"updateRepositoryDescription", ts -> DatabaseAdapterUtil.repoDescUpdateConflictMessage((String)String.format("Retry-failure after %d retries, %d ms", ts.getRetries(), ts.getDuration(TimeUnit.MILLISECONDS))), (arg_0, arg_1) -> ((NonTransactionalDatabaseAdapter)this).tryLoopStateCompletion(arg_0, arg_1), (DatabaseAdapterConfig)this.config);){
            while (true) {
                RepoDescription current;
                RepoDescription updated;
                if ((updated = updater.apply((current = this.fetchRepositoryDescription(ctx)) == null ? RepoDescription.DEFAULT : current)) == null) {
                    return;
                }
                if (this.tryUpdateRepositoryDescription(ctx, current, updated)) {
                    tryState.success((Object)NO_ANCESTOR);
                    return;
                }
                tryState.retry();
            }
        }
    }

    public Map<String, Map<String, String>> repoMaintenance(RepoMaintenanceParams params) {
        return Collections.emptyMap();
    }

    public void assertCleanStateForTests() {
    }

    public void writeMultipleCommits(List<CommitLogEntry> commitLogEntries) throws ReferenceConflictException {
        this.doWriteMultipleCommits(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commitLogEntries);
    }

    public void updateMultipleCommits(List<CommitLogEntry> commitLogEntries) throws ReferenceNotFoundException {
        this.doUpdateMultipleCommits(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commitLogEntries);
    }

    protected final RepoDescription fetchRepositoryDescription(NonTransactionalOperationContext ctx) {
        try (Traced ignore = Traced.trace((String)"fetchRepositoryDescription");){
            RepoDescription repoDescription = this.doFetchRepositoryDescription(ctx);
            return repoDescription;
        }
    }

    protected abstract RepoDescription doFetchRepositoryDescription(NonTransactionalOperationContext var1);

    protected final boolean tryUpdateRepositoryDescription(NonTransactionalOperationContext ctx, RepoDescription expected, RepoDescription updateTo) {
        try (Traced ignore = Traced.trace((String)"tryUpdateRepositoryDescription");){
            boolean bl = this.doTryUpdateRepositoryDescription(ctx, expected, updateTo);
            return bl;
        }
    }

    protected abstract boolean doTryUpdateRepositoryDescription(NonTransactionalOperationContext var1, RepoDescription var2, RepoDescription var3);

    protected static AdapterTypes.RefType protoTypeForRef(NamedRef target) {
        AdapterTypes.RefType type;
        if (target instanceof BranchName) {
            type = AdapterTypes.RefType.Branch;
        } else if (target instanceof TagName) {
            type = AdapterTypes.RefType.Tag;
        } else {
            throw new IllegalArgumentException(target.getClass().getSimpleName());
        }
        return type;
    }

    protected static NamedRef toNamedRef(AdapterTypes.RefType type, String name) {
        switch (type) {
            case Branch: {
                return BranchName.of((String)name);
            }
            case Tag: {
                return TagName.of((String)name);
            }
        }
        throw new IllegalArgumentException(type.name());
    }

    protected Hash hashOnRef(NonTransactionalOperationContext ctx, NamedRef reference, Optional<Hash> hashOnRef) throws ReferenceNotFoundException {
        if (DetachedRef.INSTANCE.equals(reference)) {
            return hashOnRef.orElseThrow(() -> new IllegalArgumentException("Must supply 'hashOnReference' for DETACHED"));
        }
        return this.hashOnRef(ctx, reference, hashOnRef, this.branchHead(ctx, reference));
    }

    protected <R> R casOpLoop(String opName, NamedRef ref, CasOpVariant opVariant, CasOp<R> casOp, Supplier<String> retryErrorMessage) throws VersionStoreException {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        try (TryLoopState tryState = TryLoopState.newTryLoopState((String)opName, ts -> String.format("%s after %d retries, %d ms", retryErrorMessage.get(), ts.getRetries(), ts.getDuration(TimeUnit.MILLISECONDS)), (arg_0, arg_1) -> ((NonTransactionalDatabaseAdapter)this).tryLoopStateCompletion(arg_0, arg_1), (DatabaseAdapterConfig)this.config);){
            CasOpResult<R> result;
            while (true) {
                boolean casSuccess;
                HashSet<Hash> individualCommits = new HashSet<Hash>();
                HashSet<Hash> individualKeyLists = new HashSet<Hash>();
                AdapterTypes.NamedReference refHead = this.fetchNamedReference(ctx, ref.getName());
                if ((refHead == null || refHead.getRef().getType() != NonTransactionalDatabaseAdapter.protoTypeForRef(ref)) && opVariant != CasOpVariant.CREATE_REF) {
                    throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
                }
                result = casOp.apply(ctx, refHead != null ? refHead.getRef() : null, individualCommits::add, individualKeyLists::add);
                switch (opVariant) {
                    case CREATE_REF: {
                        ReferenceCreatedResult refCreatedResult = (ReferenceCreatedResult)result.result;
                        casSuccess = this.createNamedReference(ctx, ref, refCreatedResult.getHash());
                        break;
                    }
                    case DELETE_REF: {
                        casSuccess = this.deleteNamedReference(ctx, ref, refHead.getRef());
                        break;
                    }
                    case REF_UPDATE: {
                        ReferenceAssignedResult refAssignedResult = (ReferenceAssignedResult)result.result;
                        if (refHead.getRef().getHash().equals((Object)refAssignedResult.getCurrentHash().asBytes())) {
                            Object object = tryState.success(result.result);
                            return (R)object;
                        }
                        casSuccess = this.updateNamedReference(ctx, ref, refHead.getRef(), refAssignedResult.getCurrentHash());
                        break;
                    }
                    case COMMIT: {
                        CommitResult commitResult = (CommitResult)result.result;
                        if (refHead.getRef().getHash().equals((Object)commitResult.getCommitHash().asBytes())) {
                            Object object = tryState.success(result.result);
                            return (R)object;
                        }
                        casSuccess = this.updateNamedReference(ctx, ref, refHead.getRef(), commitResult.getCommitHash());
                        break;
                    }
                    case MERGE: {
                        MergeResult mergeResult = (MergeResult)result.result;
                        Hash newHash = Objects.requireNonNull(mergeResult.getResultantTargetHash());
                        if (refHead.getRef().getHash().equals((Object)newHash.asBytes())) {
                            Object object = tryState.success(result.result);
                            return (R)object;
                        }
                        casSuccess = this.updateNamedReference(ctx, ref, refHead.getRef(), mergeResult.getResultantTargetHash());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown opVariant " + (Object)((Object)opVariant));
                    }
                }
                if (casSuccess) break;
                if (opVariant == CasOpVariant.COMMIT || opVariant == CasOpVariant.MERGE) {
                    this.cleanUpCommitCas(ctx, individualCommits, individualKeyLists);
                }
                tryState.retry();
            }
            this.repositoryEvent(result.adapterEventBuilder);
            Object object = tryState.success(result.result);
            return (R)object;
        }
    }

    protected static ReferenceInfo<ByteString> namedReferenceToReferenceInfo(AdapterTypes.NamedReference r) {
        return ReferenceInfo.of((Hash)Hash.of((ByteString)r.getRef().getHash()), (NamedRef)NonTransactionalDatabaseAdapter.toNamedRef(r.getRef().getType(), r.getName()));
    }

    protected final AdapterTypes.NamedReference fetchNamedReference(NonTransactionalOperationContext ctx, String refName) {
        List<AdapterTypes.NamedReference> namedRefs = this.fetchNamedReference(ctx, Collections.singletonList(refName));
        return namedRefs.isEmpty() ? null : namedRefs.get(0);
    }

    protected final List<AdapterTypes.NamedReference> fetchNamedReference(NonTransactionalOperationContext ctx, List<String> refNames) {
        try (Traced ignore = Traced.trace((String)"fetchNamedReference").tag(TAG_REF, (Number)refNames.size());){
            List<AdapterTypes.NamedReference> namedRefs = this.doFetchNamedReference(ctx, refNames);
            if (namedRefs.isEmpty() && this.maybeMigrateLegacyNamedReferences(ctx)) {
                namedRefs = this.doFetchNamedReference(ctx, refNames);
            }
            List<AdapterTypes.NamedReference> list = namedRefs;
            return list;
        }
    }

    private boolean maybeMigrateLegacyNamedReferences(NonTransactionalOperationContext ctx) {
        AdapterTypes.GlobalStatePointer.Builder newPointerBuilder;
        AdapterTypes.GlobalStatePointer newPointer;
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null || pointer.getNamedReferencesCount() == 0) {
            return false;
        }
        HashMap namedRefsFromGlobal = Maps.newHashMapWithExpectedSize((int)pointer.getNamedReferencesCount());
        pointer.getNamedReferencesList().forEach(nr -> namedRefsFromGlobal.put(nr.getName(), nr));
        List refNamesSegments = StreamSupport.stream(this.fetchReferenceNames(ctx), false).collect(Collectors.toList());
        HashMap refsToAddToInventoryMap = new HashMap(namedRefsFromGlobal);
        for (AdapterTypes.ReferenceNames refNames : refNamesSegments) {
            refNames.getRefNamesList().forEach(refsToAddToInventoryMap::remove);
        }
        if (!refsToAddToInventoryMap.isEmpty()) {
            Iterator refsToAddToInventory = refsToAddToInventoryMap.values().iterator();
            int namedReferencesSegment = 0;
            ArrayList<NamedRef> refsToAddToSegment = new ArrayList<NamedRef>();
            IntFunction<Integer> calculateHeadRoomForSegment = seg -> {
                AdapterTypes.ReferenceNames referenceNamesSegment = refNamesSegments.size() > seg ? (AdapterTypes.ReferenceNames)refNamesSegments.get(seg) : null;
                return this.maxEntitySize(((NonTransactionalDatabaseAdapterConfig)this.config).getReferencesSegmentSize()) - (referenceNamesSegment != null ? referenceNamesSegment.getSerializedSize() : 0);
            };
            int headRoom = calculateHeadRoomForSegment.apply(namedReferencesSegment);
            while (refsToAddToInventory.hasNext()) {
                AdapterTypes.NamedReference namedRefToAdd = (AdapterTypes.NamedReference)refsToAddToInventory.next();
                int namedRefToAddSize = ByteString.copyFromUtf8((String)namedRefToAdd.getName()).size() + 3;
                while (headRoom < namedRefToAddSize) {
                    if (!refsToAddToSegment.isEmpty()) {
                        this.doAddToNamedReferences(ctx, refsToAddToSegment.stream(), namedReferencesSegment);
                        refsToAddToSegment.clear();
                    }
                    headRoom = calculateHeadRoomForSegment.apply(++namedReferencesSegment);
                }
                refsToAddToSegment.add(NonTransactionalDatabaseAdapter.toNamedRef(namedRefToAdd.getRef().getType(), namedRefToAdd.getName()));
                headRoom -= namedRefToAddSize;
            }
            if (!refsToAddToSegment.isEmpty()) {
                this.doAddToNamedReferences(ctx, refsToAddToSegment.stream(), namedReferencesSegment);
                refsToAddToSegment.clear();
            }
        }
        do {
            AdapterTypes.NamedReference namedRefToMigrate = (AdapterTypes.NamedReference)pointer.getNamedReferencesList().get(ThreadLocalRandom.current().nextInt(pointer.getNamedReferencesCount()));
            this.doCreateNamedReference(ctx, namedRefToMigrate);
            newPointerBuilder = pointer.toBuilder().clearNamedReferences().setGlobalId(DatabaseAdapterUtil.randomHash().asBytes());
            pointer.getNamedReferencesList().stream().filter(nr -> !nr.getName().equals(namedRefToMigrate.getName())).forEach(arg_0 -> ((AdapterTypes.GlobalStatePointer.Builder)newPointerBuilder).addNamedReferences(arg_0));
        } while ((pointer = this.globalPointerCas(ctx, pointer, newPointer = newPointerBuilder.build()) ? newPointer : this.fetchGlobalPointer(ctx)) != null && pointer.getNamedReferencesCount() != 0);
        return true;
    }

    protected abstract List<AdapterTypes.NamedReference> doFetchNamedReference(NonTransactionalOperationContext var1, List<String> var2);

    @MustBeClosed
    protected final Stream<AdapterTypes.NamedReference> fetchNamedReferences(NonTransactionalOperationContext ctx) {
        this.maybeMigrateLegacyNamedReferences(ctx);
        Spliterator<AdapterTypes.ReferenceNames> split = this.fetchReferenceNames(ctx);
        Spliterator allNames = StreamSupport.stream(split, false).map(AdapterTypes.ReferenceNames::getRefNamesList).flatMap(Collection::stream).distinct().spliterator();
        BatchSpliterator batchSpliterator = new BatchSpliterator(((NonTransactionalDatabaseAdapterConfig)this.config).getReferenceNamesBatchSize(), allNames, batch -> this.fetchNamedReference(ctx, (List<String>)batch).spliterator(), 1281);
        return StreamSupport.stream(batchSpliterator, false);
    }

    protected final boolean createNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, Hash newHead) {
        AdapterTypes.NamedReference namedReference = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(AdapterTypes.RefPointer.newBuilder().setType(NonTransactionalDatabaseAdapter.protoTypeForRef(ref)).setHash(newHead.asBytes())).build();
        try (Traced ignore = Traced.trace((String)"createNamedReference").tag(TAG_REF, ref.getName());){
            int addToSegment = this.findAvailableNamedReferencesSegment(ctx);
            this.doAddToNamedReferences(ctx, Stream.of(ref), addToSegment);
            boolean bl = this.doCreateNamedReference(ctx, namedReference);
            return bl;
        }
    }

    protected int findAvailableNamedReferencesSegment(NonTransactionalOperationContext ctx) {
        int segment = 0;
        Iterator<AdapterTypes.ReferenceNames> iter = Spliterators.iterator(this.fetchReferenceNames(ctx));
        while (iter.hasNext()) {
            AdapterTypes.ReferenceNames refNames = iter.next();
            int serSize = refNames.getSerializedSize();
            if (serSize < this.maxEntitySize(((NonTransactionalDatabaseAdapterConfig)this.config).getReferencesSegmentSize())) {
                return segment;
            }
            ++segment;
        }
        return segment;
    }

    protected abstract void doAddToNamedReferences(NonTransactionalOperationContext var1, Stream<NamedRef> var2, int var3);

    protected abstract void doRemoveFromNamedReferences(NonTransactionalOperationContext var1, NamedRef var2, int var3);

    protected abstract boolean doCreateNamedReference(NonTransactionalOperationContext var1, AdapterTypes.NamedReference var2);

    protected final boolean deleteNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead) {
        try (Traced ignore = Traced.trace((String)"deleteNamedReference").tag(TAG_REF, ref.getName());){
            if (!this.doDeleteNamedReference(ctx, ref, refHead)) {
                boolean bl = false;
                return bl;
            }
            int segment = 0;
            Iterator<AdapterTypes.ReferenceNames> iter = Spliterators.iterator(this.fetchReferenceNames(ctx));
            while (iter.hasNext()) {
                AdapterTypes.ReferenceNames refNames = iter.next();
                if (refNames.getRefNamesList().contains((Object)ref.getName())) {
                    this.doRemoveFromNamedReferences(ctx, ref, segment);
                }
                ++segment;
            }
            boolean bl = true;
            return bl;
        }
    }

    protected abstract boolean doDeleteNamedReference(NonTransactionalOperationContext var1, NamedRef var2, AdapterTypes.RefPointer var3);

    protected final boolean updateNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead, Hash newHead) {
        try (Traced ignore = Traced.trace((String)"updateNamedReference").tag(TAG_REF, ref.getName());){
            boolean bl = this.doUpdateNamedReference(ctx, ref, refHead, newHead);
            return bl;
        }
    }

    protected abstract boolean doUpdateNamedReference(NonTransactionalOperationContext var1, NamedRef var2, AdapterTypes.RefPointer var3, Hash var4);

    protected abstract void unsafeWriteGlobalPointer(NonTransactionalOperationContext var1, AdapterTypes.GlobalStatePointer var2);

    protected final boolean globalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        try (Traced ignore = Traced.trace((String)"globalPointerCas");){
            boolean bl = this.doGlobalPointerCas(ctx, expected, newPointer);
            return bl;
        }
    }

    protected abstract boolean doGlobalPointerCas(NonTransactionalOperationContext var1, AdapterTypes.GlobalStatePointer var2, AdapterTypes.GlobalStatePointer var3);

    protected final void cleanUpCommitCas(NonTransactionalOperationContext ctx, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        try (Traced ignore = Traced.trace((String)"cleanUpCommitCas").tag(TAG_COMMIT_COUNT, (Number)branchCommits.size()).tag(TAG_KEY_LIST_COUNT, (Number)newKeyLists.size());){
            this.doCleanUpCommitCas(ctx, branchCommits, newKeyLists);
        }
    }

    protected abstract void doCleanUpCommitCas(NonTransactionalOperationContext var1, Set<Hash> var2, Set<Hash> var3);

    protected final Spliterator<AdapterTypes.ReferenceNames> fetchReferenceNames(NonTransactionalOperationContext ctx) {
        return new ReferenceNamesSpliterator(seg -> this.fetchReferenceNames(ctx, seg, ((NonTransactionalDatabaseAdapterConfig)this.config).getReferencesSegmentPrefetch()));
    }

    protected final List<AdapterTypes.ReferenceNames> fetchReferenceNames(NonTransactionalOperationContext ctx, int segment, int prefetchSegments) {
        try (Traced ignore = Traced.trace((String)"fetchReferenceNames");){
            List<AdapterTypes.ReferenceNames> list = this.doFetchReferenceNames(ctx, segment, prefetchSegments);
            return list;
        }
    }

    protected abstract List<AdapterTypes.ReferenceNames> doFetchReferenceNames(NonTransactionalOperationContext var1, int var2, int var3);

    protected Hash branchHead(NonTransactionalOperationContext ctx, NamedRef ref) throws ReferenceNotFoundException {
        if (ref == null) {
            return null;
        }
        AdapterTypes.NamedReference namedReference = this.fetchNamedReference(ctx, ref.getName());
        if (namedReference == null || namedReference.getRef().getType() != NonTransactionalDatabaseAdapter.protoTypeForRef(ref)) {
            throw DatabaseAdapterUtil.referenceNotFound((String)ref.getName());
        }
        return Hash.of((ByteString)namedReference.getRef().getHash());
    }

    protected ReferenceInfo<ByteString> referenceHead(NonTransactionalOperationContext ctx, String ref) throws ReferenceNotFoundException {
        AdapterTypes.NamedReference namedReference = this.fetchNamedReference(ctx, ref);
        if (namedReference == null) {
            throw DatabaseAdapterUtil.referenceNotFound((String)ref);
        }
        return NonTransactionalDatabaseAdapter.namedReferenceToReferenceInfo(namedReference);
    }

    private Hash namedRefsDefaultBranchHead(NonTransactionalOperationContext ctx, GetNamedRefsParams params) throws ReferenceNotFoundException {
        if (NonTransactionalDatabaseAdapter.namedRefsRequiresBaseReference((GetNamedRefsParams)params)) {
            Preconditions.checkNotNull((Object)params.getBaseReference(), (Object)"Base reference name missing.");
            return this.branchHead(ctx, params.getBaseReference());
        }
        return null;
    }

    protected final AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext ctx) {
        try (Traced ignore = Traced.trace((String)"fetchGlobalPointer");){
            AdapterTypes.GlobalStatePointer globalStatePointer = this.doFetchGlobalPointer(ctx);
            return globalStatePointer;
        }
    }

    protected abstract AdapterTypes.GlobalStatePointer doFetchGlobalPointer(NonTransactionalOperationContext var1);

    protected static ByteString globalLogHead(AdapterTypes.GlobalStatePointer pointer) {
        return pointer.hasGlobalLogHead() ? pointer.getGlobalLogHead() : pointer.getGlobalId();
    }

    protected Map<ContentId, ByteString> doFetchGlobalStates(NonTransactionalOperationContext ctx, Set<ContentId> contentIds) {
        if (contentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Stream<AdapterTypes.GlobalStateLogEntry> log = this.globalLogFetcher(ctx);
        HashSet<ContentId> remainingIds = new HashSet<ContentId>(contentIds);
        return DatabaseAdapterUtil.takeUntilExcludeLast(log, x -> remainingIds.isEmpty()).flatMap(e -> e.getPutsList().stream()).filter(put -> remainingIds.remove(ContentId.of((String)put.getContentId().getId()))).collect(Collectors.toMap(e -> ContentId.of((String)e.getContentId().getId()), AdapterTypes.ContentIdWithBytes::getValue));
    }

    private Stream<AdapterTypes.GlobalStateLogEntry> globalLogFetcher(NonTransactionalOperationContext ctx) {
        Spliterator split;
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null) {
            return Stream.empty();
        }
        if (pointer.getGlobalParentsInclHeadCount() == 0 || !NonTransactionalDatabaseAdapter.globalLogHead(pointer).equals((Object)pointer.getGlobalParentsInclHead(0))) {
            Hash initialId = Hash.of((ByteString)NonTransactionalDatabaseAdapter.globalLogHead(pointer));
            AdapterTypes.GlobalStateLogEntry initial = this.fetchFromGlobalLog(ctx, initialId);
            if (initial == null) {
                throw new RuntimeException(new ReferenceNotFoundException(String.format("Global log entry '%s' not does not exist.", initialId.asString())));
            }
            split = this.logFetcher(ctx, initial, this::fetchPageFromGlobalLog, e -> e.getParentsList().stream().map(Hash::of).collect(Collectors.toList()));
        } else {
            List hashes = pointer.getGlobalParentsInclHeadList().stream().map(Hash::of).collect(Collectors.toList());
            split = this.logFetcherWithPage(ctx, hashes, this::fetchPageFromGlobalLog, e -> e.getParentsList().stream().map(Hash::of).collect(Collectors.toList()));
        }
        return StreamSupport.stream(split, false);
    }

    protected final AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        try (Traced ignore = Traced.trace((String)"fetchFromGlobalLog").tag("hash", id.asString());){
            AdapterTypes.GlobalStateLogEntry globalStateLogEntry = this.doFetchFromGlobalLog(ctx, id);
            return globalStateLogEntry;
        }
    }

    protected abstract AdapterTypes.GlobalStateLogEntry doFetchFromGlobalLog(NonTransactionalOperationContext var1, Hash var2);

    protected final List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        try (Traced ignore = Traced.trace((String)"fetchPageFromGlobalLog").tag("hash", hashes.get(0).asString()).tag("count", (Number)hashes.size());){
            List<AdapterTypes.GlobalStateLogEntry> list = this.doFetchPageFromGlobalLog(ctx, hashes);
            return list;
        }
    }

    protected abstract List<AdapterTypes.GlobalStateLogEntry> doFetchPageFromGlobalLog(NonTransactionalOperationContext var1, List<Hash> var2);

    static enum CasOpVariant {
        COMMIT,
        MERGE,
        REF_UPDATE,
        CREATE_REF,
        DELETE_REF;

    }

    protected static final class CasOpResult<R> {
        final AdapterTypes.RefPointer currentHead;
        final R result;
        final Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder;

        private CasOpResult(AdapterTypes.RefPointer currentHead, R result, Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder) {
            this.currentHead = currentHead;
            this.result = result;
            this.adapterEventBuilder = adapterEventBuilder;
        }

        public static <R> CasOpResult<R> casOpResult(AdapterTypes.RefPointer currentHead, R result, Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder) {
            return new CasOpResult<R>(currentHead, result, adapterEventBuilder);
        }
    }

    @FunctionalInterface
    public static interface CasOp<R> {
        public CasOpResult<R> apply(NonTransactionalOperationContext var1, AdapterTypes.RefPointer var2, Consumer<Hash> var3, Consumer<Hash> var4) throws VersionStoreException;
    }
}

