/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.serialize;

import java.util.TreeMap;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.InvalidProtocolBufferException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableKeyList;
import org.projectnessie.versioned.persist.adapter.ImmutableRepoDescription;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;

public final class ProtoSerialization {
    private ProtoSerialization() {
    }

    public static AdapterTypes.RepoProps toProto(RepoDescription repoDescription) {
        AdapterTypes.RepoProps.Builder proto = AdapterTypes.RepoProps.newBuilder().setRepoVersion(repoDescription.getRepoVersion());
        new TreeMap<String, String>(repoDescription.getProperties()).forEach((k, v) -> proto.addProperties(AdapterTypes.Entry.newBuilder().setKey(k).setValue(v)));
        return proto.build();
    }

    public static RepoDescription protoToRepoDescription(ByteString bytes) {
        if (bytes == null) {
            return RepoDescription.DEFAULT;
        }
        try {
            AdapterTypes.RepoProps proto = AdapterTypes.RepoProps.parseFrom((ByteString)bytes);
            return ProtoSerialization.protoToRepoDescription(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static RepoDescription protoToRepoDescription(byte[] bytes) {
        if (bytes == null) {
            return RepoDescription.DEFAULT;
        }
        try {
            AdapterTypes.RepoProps proto = AdapterTypes.RepoProps.parseFrom((byte[])bytes);
            return ProtoSerialization.protoToRepoDescription(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static RepoDescription protoToRepoDescription(AdapterTypes.RepoProps proto) {
        ImmutableRepoDescription.Builder repoDesc = RepoDescription.builder().repoVersion(proto.getRepoVersion());
        proto.getPropertiesList().forEach(e -> repoDesc.putProperties(e.getKey(), e.getValue()));
        return repoDesc.build();
    }

    public static AdapterTypes.CommitLogEntry toProto(CommitLogEntry entry) {
        AdapterTypes.CommitLogEntry.Builder proto = AdapterTypes.CommitLogEntry.newBuilder().setCreatedTime(entry.getCreatedTime()).setHash(entry.getHash().asBytes()).setCommitSeq(entry.getCommitSeq()).setMetadata(entry.getMetadata()).setKeyListDistance(entry.getKeyListDistance());
        proto.setKeyListVariant(AdapterTypes.KeyListVariant.valueOf((String)entry.getKeyListVariant().name()));
        entry.getParents().forEach(p -> proto.addParents(p.asBytes()));
        entry.getPuts().forEach(p -> proto.addPuts(ProtoSerialization.toProto(p)));
        entry.getDeletes().forEach(p -> proto.addDeletes(ProtoSerialization.keyToProto(p)));
        if (entry.getKeyList() != null) {
            entry.getKeyList().getKeys().forEach(k -> proto.addKeyList(ProtoSerialization.toProto(k)));
        }
        entry.getKeyListsIds().forEach(k -> proto.addKeyListIds(k.asBytes()));
        if (entry.getKeyListEntityOffsets() != null) {
            proto.addAllKeyListEntityOffsets((Iterable)entry.getKeyListEntityOffsets());
        }
        if (entry.getKeyListLoadFactor() != null) {
            proto.setKeyListLoadFactor(entry.getKeyListLoadFactor().floatValue());
            proto.setKeyListBucketCount(entry.getKeyListBucketCount().intValue());
        }
        entry.getAdditionalParents().forEach(p -> proto.addAdditionalParents(p.asBytes()));
        return proto.build();
    }

    public static CommitLogEntry protoToCommitLogEntry(ByteString serialized) {
        try {
            if (serialized == null) {
                return null;
            }
            AdapterTypes.CommitLogEntry proto = AdapterTypes.CommitLogEntry.parseFrom((ByteString)serialized);
            return ProtoSerialization.protoToCommitLogEntry(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommitLogEntry protoToCommitLogEntry(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            AdapterTypes.CommitLogEntry proto = AdapterTypes.CommitLogEntry.parseFrom((byte[])bytes);
            return ProtoSerialization.protoToCommitLogEntry(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static CommitLogEntry protoToCommitLogEntry(AdapterTypes.CommitLogEntry proto) {
        ImmutableCommitLogEntry.Builder entry = ImmutableCommitLogEntry.builder().createdTime(proto.getCreatedTime()).hash(Hash.of((ByteString)proto.getHash())).commitSeq(proto.getCommitSeq()).metadata(proto.getMetadata()).keyListDistance(proto.getKeyListDistance());
        CommitLogEntry.KeyListVariant keyListVariant = proto.hasKeyListVariant() ? CommitLogEntry.KeyListVariant.valueOf((String)proto.getKeyListVariant().name()) : CommitLogEntry.KeyListVariant.EMBEDDED_AND_EXTERNAL_MRU;
        entry.keyListVariant(keyListVariant);
        proto.getParentsList().forEach(p -> entry.addParents(Hash.of((ByteString)p)));
        proto.getPutsList().forEach(p -> entry.addPuts(ProtoSerialization.protoToKeyWithBytes(p)));
        proto.getDeletesList().forEach(p -> entry.addDeletes(ProtoSerialization.protoToKey(p)));
        if (!proto.getKeyListList().isEmpty()) {
            ImmutableKeyList.Builder kl = ImmutableKeyList.builder();
            proto.getKeyListList().forEach(kle -> kl.addKeys(ProtoSerialization.protoToKeyListEntry(kle)));
            entry.keyList((KeyList)kl.build());
        } else if (keyListVariant != CommitLogEntry.KeyListVariant.EMBEDDED_AND_EXTERNAL_MRU) {
            entry.keyList(KeyList.EMPTY);
        }
        proto.getKeyListIdsList().forEach(p -> entry.addKeyListsIds(Hash.of((ByteString)p)));
        entry.addAllKeyListEntityOffsets((Iterable)proto.getKeyListEntityOffsetsList());
        proto.getAdditionalParentsList().forEach(p -> entry.addAdditionalParents(Hash.of((ByteString)p)));
        if (proto.hasKeyListLoadFactor()) {
            entry.keyListLoadFactor(Float.valueOf(proto.getKeyListLoadFactor()));
            entry.keyListBucketCount(Integer.valueOf(proto.getKeyListBucketCount()));
        }
        return entry.build();
    }

    public static AdapterTypes.ContentIdWithBytes toProto(ContentIdAndBytes x) {
        return AdapterTypes.ContentIdWithBytes.newBuilder().setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setValue(x.getValue()).build();
    }

    public static ContentIdAndBytes protoToContentIdAndBytes(AdapterTypes.ContentIdWithBytes proto) {
        return ContentIdAndBytes.of((ContentId)ContentId.of((String)proto.getContentId().getId()), (ByteString)proto.getValue());
    }

    public static AdapterTypes.KeyList toProto(KeyList x) {
        AdapterTypes.KeyList.Builder keyList = AdapterTypes.KeyList.newBuilder();
        for (KeyListEntry key : x.getKeys()) {
            keyList.addKeys(ProtoSerialization.toProto(key));
        }
        return keyList.build();
    }

    public static KeyList protoToKeyList(ByteString serialized) {
        try {
            AdapterTypes.KeyList proto = AdapterTypes.KeyList.parseFrom((ByteString)serialized);
            return ProtoSerialization.protoToKeyList(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyList protoToKeyList(byte[] bytes) {
        try {
            AdapterTypes.KeyList proto = AdapterTypes.KeyList.parseFrom((byte[])bytes);
            return ProtoSerialization.protoToKeyList(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableKeyList protoToKeyList(AdapterTypes.KeyList proto) {
        ImmutableKeyList.Builder keyList = ImmutableKeyList.builder();
        for (AdapterTypes.KeyListEntry key : proto.getKeysList()) {
            keyList.addKeys(ProtoSerialization.protoToKeyListEntry(key));
        }
        return keyList.build();
    }

    public static AdapterTypes.KeyWithBytes toProto(KeyWithBytes x) {
        return AdapterTypes.KeyWithBytes.newBuilder().setKey(ProtoSerialization.keyToProto(x.getKey())).setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setPayload((int)x.getPayload()).setValue(x.getValue()).build();
    }

    public static KeyWithBytes protoToKeyWithBytes(AdapterTypes.KeyWithBytes proto) {
        return KeyWithBytes.of((ContentKey)ContentKey.of((String[])((String[])proto.getKey().getElementList().toArray((Object[])new String[0]))), (ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getPayload()), (ByteString)proto.getValue());
    }

    public static AdapterTypes.KeyListEntry toProto(KeyListEntry x) {
        if (x == null) {
            return AdapterTypes.KeyListEntry.getDefaultInstance();
        }
        AdapterTypes.KeyListEntry.Builder builder = AdapterTypes.KeyListEntry.newBuilder().setKey(ProtoSerialization.keyToProto(x.getKey())).setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setPayload((int)x.getPayload());
        if (x.getCommitId() != null) {
            builder.setCommitId(x.getCommitId().asBytes());
        }
        return builder.build();
    }

    public static KeyListEntry protoToKeyListEntry(AdapterTypes.KeyListEntry proto) {
        if (!proto.hasKey()) {
            return null;
        }
        return KeyListEntry.of((ContentKey)ProtoSerialization.protoToKey(proto.getKey()), (ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getPayload()), proto.hasCommitId() ? Hash.of((ByteString)proto.getCommitId()) : null);
    }

    public static AdapterTypes.Key keyToProto(ContentKey key) {
        return AdapterTypes.Key.newBuilder().addAllElement((Iterable)key.getElements()).build();
    }

    public static ContentKey protoToKey(AdapterTypes.Key key) {
        return ContentKey.of((String[])((String[])key.getElementList().toArray((Object[])new String[0])));
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(byte[] var1) throws InvalidProtocolBufferException;
    }
}

