/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.store;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitMetaSerializer;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.ImmutableRefLogDetails;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.FilteringPaginationIterator;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.store.DefaultStoreWorker;

public class PersistVersionStore
implements VersionStore {
    private final DatabaseAdapter databaseAdapter;
    protected static final StoreWorker STORE_WORKER = DefaultStoreWorker.instance();

    public PersistVersionStore(DatabaseAdapter databaseAdapter, StoreWorker storeWorker) {
        this(databaseAdapter);
    }

    public PersistVersionStore(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.databaseAdapter.hashOnReference(namedReference, hashOnReference);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.databaseAdapter.noAncestorHash();
    }

    public Hash commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> expectedHead, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull Callable<Void> validator, BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        ImmutableCommitParams.Builder commitAttempt = ImmutableCommitParams.builder().toBranch(branch).expectedHead(expectedHead).commitMetaSerialized(this.serializeMetadata(metadata)).validator(validator);
        for (Operation operation : operations) {
            if (operation instanceof Put) {
                Put op = (Put)operation;
                Content content = op.getValue();
                if (content.getId() == null) {
                    String cid = UUID.randomUUID().toString();
                    content = STORE_WORKER.applyId(content, cid);
                    addedContents.accept(op.getKey(), cid);
                }
                ContentId contentId = ContentId.of((String)content.getId());
                commitAttempt.addPuts(KeyWithBytes.of((ContentKey)op.getKey(), (ContentId)contentId, (byte)DefaultStoreWorker.payloadForContent((Content)content), (ByteString)STORE_WORKER.toStoreOnReferenceState(content)));
                continue;
            }
            if (operation instanceof Delete) {
                commitAttempt.addDeletes(operation.getKey());
                continue;
            }
            if (operation instanceof Unchanged) {
                commitAttempt.addUnchanged(operation.getKey());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown operation type '%s'", operation));
        }
        return this.databaseAdapter.commit((CommitParams)commitAttempt.build());
    }

    public MergeResult<Commit> transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<ContentKey, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            MergeResult adapterMergeResult = this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().toBranch(targetBranch)).expectedHead(referenceHash)).sequenceToTransplant(sequenceToTransplant).updateCommitMetadata(this.updateCommitMetadataFunction(updateCommitMetadata))).keepIndividualCommits(keepIndividualCommits)).mergeTypes(mergeTypes)).defaultMergeType(defaultMergeType)).isDryRun(dryRun)).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo);
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo));
        }
    }

    public MergeResult<Commit> merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<ContentKey, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            MergeResult adapterMergeResult = this.databaseAdapter.merge(((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().toBranch(toBranch)).expectedHead(expectedHash)).mergeFromHash(fromHash).updateCommitMetadata(this.updateCommitMetadataFunction(updateCommitMetadata))).keepIndividualCommits(keepIndividualCommits)).mergeTypes(mergeTypes)).defaultMergeType(defaultMergeType)).isDryRun(dryRun)).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo);
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, fetchAdditionalInfo));
        }
    }

    private MergeResult<Commit> storeMergeResult(MergeResult<CommitLogEntry> adapterMergeResult, boolean fetchAdditionalInfo) {
        ImmutableMergeResult.Builder storeResult = ImmutableMergeResult.builder().targetBranch(adapterMergeResult.getTargetBranch()).effectiveTargetHash(adapterMergeResult.getEffectiveTargetHash()).commonAncestor(adapterMergeResult.getCommonAncestor()).resultantTargetHash(adapterMergeResult.getResultantTargetHash()).expectedHash(adapterMergeResult.getExpectedHash()).wasApplied(adapterMergeResult.wasApplied()).wasSuccessful(adapterMergeResult.wasSuccessful()).details(adapterMergeResult.getDetails());
        BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        Function<CommitLogEntry, Commit> mapper = logEntry -> {
            ImmutableCommit.Builder commit = Commit.builder();
            commit.hash(logEntry.getHash()).commitMeta(this.commitMetaFromLogEntry((CommitLogEntry)logEntry));
            enhancer.accept(commit, (CommitLogEntry)logEntry);
            return commit.build();
        };
        if (adapterMergeResult.getSourceCommits() != null) {
            adapterMergeResult.getSourceCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addSourceCommits(arg_0));
        }
        if (adapterMergeResult.getTargetCommits() != null) {
            adapterMergeResult.getTargetCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addTargetCommits(arg_0));
        }
        return storeResult.build();
    }

    private MetadataRewriter<ByteString> updateCommitMetadataFunction(final MetadataRewriter<CommitMeta> updateCommitMetadata) {
        return new MetadataRewriter<ByteString>(){

            public ByteString rewriteSingle(ByteString metadata) {
                return PersistVersionStore.this.serializeMetadata((CommitMeta)updateCommitMetadata.rewriteSingle((Object)PersistVersionStore.this.deserializeMetadata(metadata)));
            }

            public ByteString squash(List<ByteString> metadata) {
                return PersistVersionStore.this.serializeMetadata((CommitMeta)updateCommitMetadata.squash(metadata.stream().map(x$0 -> PersistVersionStore.this.deserializeMetadata(x$0)).collect(Collectors.toList())));
            }
        };
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.assign(ref, expectedHash, targetHash);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.databaseAdapter.create(ref, targetHash.orElseGet(() -> ((DatabaseAdapter)this.databaseAdapter).noAncestorHash()));
    }

    public Hash delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.databaseAdapter.delete(ref, hash);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public ReferenceInfo<CommitMeta> getNamedRef(@javax.annotation.Nonnull @Nonnull String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        ReferenceInfo namedRef = this.databaseAdapter.namedRef(ref, params);
        return namedRef.withUpdatedCommitMeta((Object)this.commitMetaFromReference((ReferenceInfo<ByteString>)namedRef));
    }

    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported");
        final Stream source = this.databaseAdapter.namedRefs(params);
        return new FilteringPaginationIterator<ReferenceInfo<ByteString>, ReferenceInfo<CommitMeta>>(source.iterator(), namedRef -> namedRef.withUpdatedCommitMeta((Object)this.commitMetaFromReference((ReferenceInfo<ByteString>)namedRef))){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported");
            }

            public String tokenForEntry(ReferenceInfo<CommitMeta> entry) {
                throw new IllegalArgumentException("Paging not supported");
            }

            public void close() {
                source.close();
            }
        };
    }

    private ByteString serializeMetadata(CommitMeta metadata) {
        return metadata != null ? CommitMetaSerializer.METADATA_SERIALIZER.toBytes((Object)metadata) : null;
    }

    private CommitMeta commitMetaFromReference(ReferenceInfo<ByteString> referenceInfo) {
        ByteString meta = (ByteString)referenceInfo.getHeadCommitMeta();
        if (meta == null) {
            return null;
        }
        ImmutableCommitMeta.Builder commitMeta = CommitMeta.builder().from(this.deserializeMetadata(meta));
        referenceInfo.getParentHashes().forEach(p -> commitMeta.addParentCommitHashes(p.asString()));
        return commitMeta.hash(referenceInfo.getHash().asString()).build();
    }

    private CommitMeta commitMetaFromLogEntry(CommitLogEntry logEntry) {
        ImmutableCommitMeta.Builder commitMeta = CommitMeta.builder();
        commitMeta.from(this.deserializeMetadata(Objects.requireNonNull(logEntry.getMetadata())));
        commitMeta.hash(logEntry.getHash().asString()).addParentCommitHashes(((Hash)logEntry.getParents().get(0)).asString());
        logEntry.getAdditionalParents().forEach(p -> commitMeta.addParentCommitHashes(p.asString()));
        return commitMeta.build();
    }

    private CommitMeta deserializeMetadata(ByteString commitMeta) {
        return commitMeta != null ? (CommitMeta)CommitMetaSerializer.METADATA_SERIALIZER.fromBytes(commitMeta) : null;
    }

    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        final Stream source = this.databaseAdapter.commitLog(hash);
        return new FilteringPaginationIterator<CommitLogEntry, Commit>(source.iterator(), e -> {
            ImmutableCommit.Builder commit = Commit.builder().hash(e.getHash()).commitMeta(this.commitMetaFromLogEntry((CommitLogEntry)e));
            if (!e.getParents().isEmpty()) {
                commit.parentHash((Hash)e.getParents().get(0));
            }
            enhancer.accept(commit, (CommitLogEntry)e);
            return commit.build();
        }){

            protected String computeTokenForCurrent() {
                return this.current() != null ? ((CommitLogEntry)this.current()).getHash().asString() : null;
            }

            public String tokenForEntry(Commit entry) {
                return entry != null ? entry.getHash().asString() : null;
            }

            public void close() {
                source.close();
            }
        };
    }

    private BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancerForCommitLog(boolean fetchAdditionalInfo) {
        if (!fetchAdditionalInfo) {
            return (commitBuilder, logEntry) -> {};
        }
        HashMap globalContents = new HashMap();
        Function<KeyWithBytes, ByteString> getGlobalContents = put -> globalContents.computeIfAbsent(put.getContentId(), cid -> this.databaseAdapter.globalContent(put.getContentId()).map(ContentIdAndBytes::getValue).orElse(null));
        return (commitBuilder, logEntry) -> {
            logEntry.getDeletes().forEach(delete -> commitBuilder.addOperations((Operation)Delete.of((ContentKey)delete)));
            logEntry.getPuts().forEach(put -> commitBuilder.addOperations((Operation)Put.of((ContentKey)put.getKey(), (Content)STORE_WORKER.valueFromStore(put.getPayload(), put.getValue(), () -> (ByteString)getGlobalContents.apply((KeyWithBytes)put)))));
        };
    }

    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported");
        Hash hash = this.refToHash(ref);
        final Stream source = this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL);
        return new FilteringPaginationIterator<KeyListEntry, KeyEntry>(source.iterator(), entry -> {
            if (withContent) {
                try {
                    ContentAndState cs = (ContentAndState)this.databaseAdapter.values(hash, Collections.singleton(entry.getKey()), KeyFilterPredicate.ALLOW_ALL).get(entry.getKey());
                    if (cs != null) {
                        Content content = this.mapContentAndState(cs);
                        return KeyEntry.of((Content.Type)DefaultStoreWorker.contentTypeForPayload((byte)entry.getPayload()), (ContentKey)entry.getKey(), (Content)content);
                    }
                }
                catch (ReferenceNotFoundException e) {
                    throw new IllegalStateException("Reference no longer exists", e);
                }
            }
            return KeyEntry.of((Content.Type)DefaultStoreWorker.contentTypeForPayload((byte)entry.getPayload()), (ContentKey)entry.getKey(), (String)entry.getContentId().getId());
        }){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported");
            }

            public String tokenForEntry(KeyEntry entry) {
                throw new IllegalArgumentException("Paging not supported");
            }

            public void close() {
                source.close();
            }
        };
    }

    public Content getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.getValues(ref, Collections.singletonList(key)).get(key);
    }

    public Map<ContentKey, Content> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.mapContentAndState((ContentAndState)e.getValue())));
    }

    private Content mapContentAndState(ContentAndState cs) {
        return STORE_WORKER.valueFromStore(cs.getPayload(), cs.getRefState(), () -> ((ContentAndState)cs).getGlobalState());
    }

    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported");
        Hash fromHash = this.refToHash(from);
        Hash toHash = this.refToHash(to);
        final Stream source = this.databaseAdapter.diff(fromHash, toHash, KeyFilterPredicate.ALLOW_ALL);
        return new FilteringPaginationIterator<Difference, Diff>(source.iterator(), d -> Diff.of((ContentKey)d.getKey(), d.getFromValue().map(v -> STORE_WORKER.valueFromStore(d.getPayload(), v, () -> d.getGlobal().orElse(null))), d.getToValue().map(v -> STORE_WORKER.valueFromStore(d.getPayload(), v, () -> d.getGlobal().orElse(null))))){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported");
            }

            public String tokenForEntry(Diff entry) {
                throw new IllegalArgumentException("Paging not supported");
            }

            public void close() {
                source.close();
            }
        };
    }

    private Hash refToHash(Ref ref) throws ReferenceNotFoundException {
        if (ref instanceof NamedRef) {
            return this.hashOnReference((NamedRef)ref, Optional.empty());
        }
        if (ref instanceof Hash) {
            return (Hash)ref;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", ref));
    }

    @Deprecated
    @MustBeClosed
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.databaseAdapter.refLog(refLogId).map(e -> ImmutableRefLogDetails.builder().refLogId(e.getRefLogId()).refName(e.getRefName()).refType(e.getRefType()).commitHash(e.getCommitHash()).parentRefLogId((Hash)e.getParents().get(0)).operationTime(e.getOperationTime()).operation(e.getOperation()).sourceHashes((Iterable)e.getSourceHashes()).build());
    }
}

