/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.store;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitMetaSerializer;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.CommitValidation;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Hashable;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.ImmutableCommitResult;
import org.projectnessie.versioned.ImmutableCommitValidation;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.ImmutableRepositoryInformation;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.FilteringPaginationIterator;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.store.DefaultStoreWorker;

public class PersistVersionStore
implements VersionStore {
    private final DatabaseAdapter databaseAdapter;
    protected static final StoreWorker STORE_WORKER = DefaultStoreWorker.instance();

    public PersistVersionStore(DatabaseAdapter databaseAdapter, StoreWorker storeWorker) {
        this(databaseAdapter);
    }

    public PersistVersionStore(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation() {
        return ImmutableRepositoryInformation.builder().noAncestorHash(this.noAncestorHash().asString()).build();
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference, List<RelativeCommitSpec> relativeLookups) throws ReferenceNotFoundException {
        Preconditions.checkArgument((boolean)relativeLookups.isEmpty(), (Object)"Relative lookups not supported for old database model");
        return this.databaseAdapter.hashOnReference(namedReference, hashOnReference);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.databaseAdapter.noAncestorHash();
    }

    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> expectedHead, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull VersionStore.CommitValidator validator, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        ImmutableCommitParams.Builder commitAttempt = ImmutableCommitParams.builder().toBranch(branch).expectedHead(expectedHead).commitMetaSerialized(this.serializeMetadata(metadata));
        ImmutableCommitValidation.Builder commitValidation = CommitValidation.builder();
        for (Operation operation : operations) {
            if (operation instanceof Put) {
                Put op = (Put)operation;
                Content content = op.getValue();
                if (content.getId() == null) {
                    String cid = UUID.randomUUID().toString();
                    content = content.withId(cid);
                    addedContents.accept(op.getKey(), cid);
                }
                ContentId contentId = ContentId.of((String)content.getId());
                int payload = DefaultStoreWorker.payloadForContent((Content)content);
                Preconditions.checkState((payload > 0 && payload <= 127 ? 1 : 0) != 0);
                commitAttempt.addPuts(KeyWithBytes.of((ContentKey)op.getKey(), (ContentId)contentId, (byte)((byte)payload), (ByteString)STORE_WORKER.toStoreOnReferenceState(content)));
                commitValidation.addOperations(CommitValidation.CommitOperation.commitOperation((IdentifiedContentKey)IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)op.getKey(), (Content.Type)DefaultStoreWorker.contentTypeForPayload((int)payload), (String)contentId.getId(), x -> null), (CommitValidation.CommitOperationType)CommitValidation.CommitOperationType.UPDATE));
                continue;
            }
            if (operation instanceof Delete) {
                commitAttempt.addDeletes(operation.getKey());
                commitValidation.addOperations(CommitValidation.CommitOperation.commitOperation((IdentifiedContentKey)IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)operation.getKey(), null, null, x -> null), (CommitValidation.CommitOperationType)CommitValidation.CommitOperationType.DELETE));
                continue;
            }
            if (operation instanceof Unchanged) {
                commitAttempt.addUnchanged(operation.getKey());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown operation type '%s'", operation));
        }
        try {
            validator.validate((CommitValidation)commitValidation.build());
        }
        catch (BaseNessieClientServerException | VersionStoreException e) {
            throw new RuntimeException(e);
        }
        return this.storeCommitResult((CommitResult<CommitLogEntry>)this.databaseAdapter.commit((CommitParams)commitAttempt.build()));
    }

    public MergeResult<Commit> transplant(VersionStore.TransplantOp transplantOp) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            Map<ContentKey, MergeType> mergeTypes = PersistVersionStore.mergeTypesForKeys(transplantOp.mergeKeyBehaviors());
            MergeResult adapterMergeResult = this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().fromRef(transplantOp.fromRef())).toBranch(transplantOp.toBranch())).expectedHead(transplantOp.expectedHash())).sequenceToTransplant((Iterable)transplantOp.sequenceToTransplant()).updateCommitMetadata(this.updateCommitMetadataFunction((MetadataRewriter<CommitMeta>)transplantOp.updateCommitMetadata()))).keepIndividualCommits(true)).mergeTypes(mergeTypes)).defaultMergeType(MergeType.valueOf((String)transplantOp.defaultMergeBehavior().name()))).isDryRun(transplantOp.dryRun())).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, transplantOp.fetchAdditionalInfo());
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, transplantOp.fetchAdditionalInfo()));
        }
    }

    public MergeResult<Commit> merge(VersionStore.MergeOp mergeOp) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            Map<ContentKey, MergeType> mergeTypes = PersistVersionStore.mergeTypesForKeys(mergeOp.mergeKeyBehaviors());
            MergeResult adapterMergeResult = this.databaseAdapter.merge(((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().fromRef(mergeOp.fromRef())).toBranch(mergeOp.toBranch())).expectedHead(mergeOp.expectedHash())).mergeFromHash(mergeOp.fromHash()).updateCommitMetadata(this.updateCommitMetadataFunction((MetadataRewriter<CommitMeta>)mergeOp.updateCommitMetadata()))).keepIndividualCommits(false)).mergeTypes(mergeTypes)).defaultMergeType(MergeType.valueOf((String)mergeOp.defaultMergeBehavior().name()))).isDryRun(mergeOp.dryRun())).build());
            return this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, mergeOp.fetchAdditionalInfo());
        }
        catch (MergeConflictException mergeConflict) {
            MergeResult adapterMergeResult = mergeConflict.getMergeResult();
            throw new MergeConflictException(mergeConflict.getMessage(), this.storeMergeResult((MergeResult<CommitLogEntry>)adapterMergeResult, mergeOp.fetchAdditionalInfo()));
        }
    }

    private static Map<ContentKey, MergeType> mergeTypesForKeys(Map<ContentKey, MergeKeyBehavior> mergeKeyBehaviorMap) {
        return mergeKeyBehaviorMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, b -> {
            Preconditions.checkArgument((((MergeKeyBehavior)b.getValue()).getResolvedContent() == null && ((MergeKeyBehavior)b.getValue()).getExpectedTargetContent() == null ? 1 : 0) != 0, (Object)"MergeKeyBehavior.resolvedContent and MergeKeyBehavior.expectedTargetContent are not supported for this storage model");
            return MergeType.valueOf((String)((MergeKeyBehavior)b.getValue()).getMergeBehavior().name());
        }));
    }

    private CommitResult<Commit> storeCommitResult(CommitResult<CommitLogEntry> adapterCommitResult) {
        CommitLogEntry logEntry = (CommitLogEntry)adapterCommitResult.getCommit();
        ImmutableCommit.Builder commit = Commit.builder().hash(logEntry.getHash()).commitMeta(this.commitMetaFromLogEntry(logEntry));
        logEntry.getParents().stream().findFirst().ifPresent(arg_0 -> ((ImmutableCommit.Builder)commit).parentHash(arg_0));
        this.enhancerForCommitLog(true).accept(commit, logEntry);
        ImmutableCommitResult.Builder storeResult = ImmutableCommitResult.builder().targetBranch(adapterCommitResult.getTargetBranch()).commit((Hashable)commit.build());
        return storeResult.build();
    }

    private MergeResult<Commit> storeMergeResult(MergeResult<CommitLogEntry> adapterMergeResult, boolean fetchAdditionalInfo) {
        ImmutableMergeResult.Builder storeResult = ImmutableMergeResult.builder().resultType(adapterMergeResult.getResultType()).sourceRef(adapterMergeResult.getSourceRef()).targetBranch(adapterMergeResult.getTargetBranch()).effectiveTargetHash(adapterMergeResult.getEffectiveTargetHash()).commonAncestor(adapterMergeResult.getCommonAncestor()).resultantTargetHash(adapterMergeResult.getResultantTargetHash()).expectedHash(adapterMergeResult.getExpectedHash()).wasApplied(adapterMergeResult.wasApplied()).wasSuccessful(adapterMergeResult.wasSuccessful()).details(adapterMergeResult.getDetails());
        BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        Function<CommitLogEntry, Commit> mapper = logEntry -> {
            ImmutableCommit.Builder commit = Commit.builder();
            commit.hash(logEntry.getHash()).commitMeta(this.commitMetaFromLogEntry((CommitLogEntry)logEntry));
            enhancer.accept(commit, (CommitLogEntry)logEntry);
            return commit.build();
        };
        if (adapterMergeResult.getSourceCommits() != null) {
            adapterMergeResult.getSourceCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addSourceCommits(arg_0));
        }
        if (adapterMergeResult.getTargetCommits() != null) {
            adapterMergeResult.getTargetCommits().stream().map(mapper).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addTargetCommits(arg_0));
        }
        enhancer = this.enhancerForCommitLog(true);
        adapterMergeResult.getCreatedCommits().stream().map(logEntry -> {
            ImmutableCommit.Builder commit = Commit.builder().hash(logEntry.getHash()).commitMeta(this.commitMetaFromLogEntry((CommitLogEntry)logEntry));
            logEntry.getParents().stream().findFirst().ifPresent(arg_0 -> ((ImmutableCommit.Builder)commit).parentHash(arg_0));
            enhancer.accept(commit, (CommitLogEntry)logEntry);
            return commit.build();
        }).forEach(arg_0 -> ((ImmutableMergeResult.Builder)storeResult).addCreatedCommits(arg_0));
        return storeResult.build();
    }

    private MetadataRewriter<ByteString> updateCommitMetadataFunction(final MetadataRewriter<CommitMeta> updateCommitMetadata) {
        return new MetadataRewriter<ByteString>(){

            public ByteString rewriteSingle(ByteString metadata) {
                return PersistVersionStore.this.serializeMetadata((CommitMeta)updateCommitMetadata.rewriteSingle((Object)PersistVersionStore.this.deserializeMetadata(metadata)));
            }

            public ByteString squash(List<ByteString> metadata, int numCommits) {
                return PersistVersionStore.this.serializeMetadata((CommitMeta)updateCommitMetadata.squash(metadata.stream().map(x$0 -> PersistVersionStore.this.deserializeMetadata(x$0)).collect(Collectors.toList()), numCommits));
            }
        };
    }

    public ReferenceAssignedResult assign(NamedRef ref, Hash expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.databaseAdapter.assign(ref, Optional.of(expectedHash), targetHash);
    }

    public ReferenceCreatedResult create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.databaseAdapter.create(ref, targetHash.orElseGet(() -> ((DatabaseAdapter)this.databaseAdapter).noAncestorHash()));
    }

    public ReferenceDeletedResult delete(NamedRef ref, Hash hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.databaseAdapter.delete(ref, Optional.of(hash));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public ReferenceInfo<CommitMeta> getNamedRef(@javax.annotation.Nonnull @Nonnull String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        ReferenceInfo namedRef = this.databaseAdapter.namedRef(ref, params);
        return namedRef.withUpdatedCommitMeta((Object)this.commitMetaFromReference((ReferenceInfo<ByteString>)namedRef));
    }

    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported by the storage model in use");
        final Stream source = this.databaseAdapter.namedRefs(params);
        return new FilteringPaginationIterator<ReferenceInfo<ByteString>, ReferenceInfo<CommitMeta>>(source.iterator(), namedRef -> namedRef.withUpdatedCommitMeta((Object)this.commitMetaFromReference((ReferenceInfo<ByteString>)namedRef))){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public String tokenForEntry(ReferenceInfo<CommitMeta> entry) {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public void close() {
                source.close();
            }
        };
    }

    private ByteString serializeMetadata(CommitMeta metadata) {
        return metadata != null ? CommitMetaSerializer.METADATA_SERIALIZER.toBytes((Object)metadata) : null;
    }

    private CommitMeta commitMetaFromReference(ReferenceInfo<ByteString> referenceInfo) {
        ByteString meta = (ByteString)referenceInfo.getHeadCommitMeta();
        if (meta == null) {
            return null;
        }
        ImmutableCommitMeta.Builder commitMeta = CommitMeta.builder().from(this.deserializeMetadata(meta));
        referenceInfo.getParentHashes().forEach(p -> commitMeta.addParentCommitHashes(p.asString()));
        return commitMeta.hash(referenceInfo.getHash().asString()).build();
    }

    private CommitMeta commitMetaFromLogEntry(CommitLogEntry logEntry) {
        ImmutableCommitMeta.Builder commitMeta = CommitMeta.builder();
        commitMeta.from(this.deserializeMetadata(Objects.requireNonNull(logEntry.getMetadata())));
        commitMeta.hash(logEntry.getHash().asString()).addParentCommitHashes(((Hash)logEntry.getParents().get(0)).asString());
        logEntry.getAdditionalParents().forEach(p -> commitMeta.addParentCommitHashes(p.asString()));
        return commitMeta.build();
    }

    private CommitMeta deserializeMetadata(ByteString commitMeta) {
        return commitMeta != null ? (CommitMeta)CommitMetaSerializer.METADATA_SERIALIZER.fromBytes(commitMeta) : null;
    }

    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        final Stream source = this.databaseAdapter.commitLog(hash);
        return new FilteringPaginationIterator<CommitLogEntry, Commit>(source.iterator(), e -> {
            ImmutableCommit.Builder commit = Commit.builder().hash(e.getHash()).commitMeta(this.commitMetaFromLogEntry((CommitLogEntry)e));
            if (!e.getParents().isEmpty()) {
                commit.parentHash((Hash)e.getParents().get(0));
            }
            enhancer.accept(commit, (CommitLogEntry)e);
            return commit.build();
        }){

            protected String computeTokenForCurrent() {
                return this.current() != null ? ((CommitLogEntry)this.current()).getHash().asString() : null;
            }

            public String tokenForEntry(Commit entry) {
                return entry != null ? entry.getHash().asString() : null;
            }

            public void close() {
                source.close();
            }
        };
    }

    private BiConsumer<ImmutableCommit.Builder, CommitLogEntry> enhancerForCommitLog(boolean fetchAdditionalInfo) {
        if (!fetchAdditionalInfo) {
            return (commitBuilder, logEntry) -> {};
        }
        HashMap globalContents = new HashMap();
        Function<KeyWithBytes, ByteString> getGlobalContents = put -> globalContents.computeIfAbsent(put.getContentId(), cid -> this.databaseAdapter.globalContent(put.getContentId()).map(ContentIdAndBytes::getValue).orElse(null));
        return (commitBuilder, logEntry) -> {
            logEntry.getDeletes().forEach(delete -> commitBuilder.addOperations((Operation)Delete.of((ContentKey)delete)));
            logEntry.getPuts().forEach(put -> commitBuilder.addOperations((Operation)Put.ofLazy((ContentKey)put.getKey(), (int)put.getPayload(), (ByteString)put.getValue(), () -> (ByteString)getGlobalContents.apply((KeyWithBytes)put))));
        };
    }

    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported by the storage model in use");
        Preconditions.checkArgument((keyRestrictions.minKey() == null && keyRestrictions.maxKey() == null && keyRestrictions.prefixKey() == null ? 1 : 0) != 0, (Object)"Key ranges not supported by the storage model in use");
        Hash hash = this.refToHash(ref);
        BiPredicate contentKeyPredicate = keyRestrictions.contentKeyPredicate();
        KeyFilterPredicate keyPred = contentKeyPredicate != null ? (k, c, t) -> contentKeyPredicate.test(k, DefaultStoreWorker.contentTypeForPayload((int)t)) : KeyFilterPredicate.ALLOW_ALL;
        final Stream source = this.databaseAdapter.keys(hash, keyPred);
        return new FilteringPaginationIterator<KeyListEntry, KeyEntry>(source.iterator(), entry -> {
            if (withContent) {
                try {
                    ContentAndState cs = (ContentAndState)this.databaseAdapter.values(hash, Collections.singleton(entry.getKey()), KeyFilterPredicate.ALLOW_ALL).get(entry.getKey());
                    if (cs != null) {
                        ContentResult content = this.mapContentAndState(entry.getKey(), cs);
                        return KeyEntry.of((IdentifiedContentKey)IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)entry.getKey(), (Content)content.content(), elements -> null), (Content)content.content());
                    }
                }
                catch (ReferenceNotFoundException e) {
                    throw new IllegalStateException("Reference no longer exists", e);
                }
            }
            return KeyEntry.of((IdentifiedContentKey)IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)entry.getKey(), (Content.Type)DefaultStoreWorker.contentTypeForPayload((int)entry.getPayload()), (String)entry.getContentId().getId(), elements -> null));
        }){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public String tokenForEntry(KeyEntry entry) {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public void close() {
                source.close();
            }
        };
    }

    public List<IdentifiedContentKey> getIdentifiedKeys(Ref ref, Collection<ContentKey> keys) {
        return keys.stream().map(key -> IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)key, null, null, x -> null)).collect(Collectors.toList());
    }

    public ContentResult getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.getValues(ref, Collections.singletonList(key)).get(key);
    }

    public Map<ContentKey, ContentResult> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.mapContentAndState((ContentKey)e.getKey(), (ContentAndState)e.getValue())));
    }

    private ContentResult mapContentAndState(ContentKey key, ContentAndState cs) {
        Content content = STORE_WORKER.valueFromStore((int)cs.getPayload(), cs.getRefState(), () -> ((ContentAndState)cs).getGlobalState());
        return ContentResult.contentResult((IdentifiedContentKey)IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)key, (Content)content, elements -> null), (Content)content, null);
    }

    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        Preconditions.checkArgument((pagingToken == null ? 1 : 0) != 0, (Object)"Paging not supported by the storage model in use");
        Preconditions.checkArgument((keyRestrictions.minKey() == null && keyRestrictions.maxKey() == null && keyRestrictions.prefixKey() == null ? 1 : 0) != 0, (Object)"Key ranges not supported by the storage model in use");
        Hash fromHash = this.refToHash(from);
        Hash toHash = this.refToHash(to);
        BiPredicate contentKeyPredicate = keyRestrictions.contentKeyPredicate();
        KeyFilterPredicate keyPred = contentKeyPredicate != null ? (k, c, t) -> contentKeyPredicate.test(k, DefaultStoreWorker.contentTypeForPayload((int)t)) : KeyFilterPredicate.ALLOW_ALL;
        final Stream source = this.databaseAdapter.diff(fromHash, toHash, keyPred);
        return new FilteringPaginationIterator<Difference, Diff>(source.iterator(), d -> {
            Content fromContent = d.getFromValue().map(v -> STORE_WORKER.valueFromStore((int)d.getPayload(), v, () -> d.getGlobal().orElse(null))).orElse(null);
            Content toContent = d.getToValue().map(v -> STORE_WORKER.valueFromStore((int)d.getPayload(), v, () -> d.getGlobal().orElse(null))).orElse(null);
            IdentifiedContentKey fromKey = fromContent != null ? IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)d.getKey(), (Content.Type)fromContent.getType(), (String)fromContent.getId(), elements -> null) : null;
            IdentifiedContentKey toKey = toContent != null ? IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)d.getKey(), (Content.Type)toContent.getType(), (String)toContent.getId(), elements -> null) : null;
            return Diff.of((IdentifiedContentKey)fromKey, (IdentifiedContentKey)toKey, Optional.ofNullable(fromContent), Optional.ofNullable(toContent));
        }){

            protected String computeTokenForCurrent() {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public String tokenForEntry(Diff entry) {
                throw new IllegalArgumentException("Paging not supported by the storage model in use");
            }

            public void close() {
                source.close();
            }
        };
    }

    private Hash refToHash(Ref ref) throws ReferenceNotFoundException {
        if (ref instanceof NamedRef) {
            return this.hashOnReference((NamedRef)ref, Optional.empty(), Collections.emptyList());
        }
        if (ref instanceof Hash) {
            return (Hash)ref;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", ref));
    }

    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        throw new IllegalArgumentException("Old database model does not support repository config objects");
    }

    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) {
        throw new IllegalArgumentException("Old database model does not support repository config objects");
    }
}

