/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests.extension;

import io.opentracing.Tracer;
import io.opentracing.mock.MockTracer;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.versioned.persist.tests.extension.NessieDbTracer;

public class NessieMockedTracingExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{NessieMockedTracingExtension.class});
    private static final MockTracer TRACER = new MockTracer();
    private static volatile boolean tracerRegistered;

    public void beforeAll(ExtensionContext context) throws Exception {
        if (GlobalTracer.isRegistered() && !tracerRegistered) {
            throw new ExtensionConfigurationException("GlobalTracer already has a registered Tracer");
        }
        tracerRegistered = true;
        GlobalTracer.registerIfAbsent((Tracer)TRACER);
        NessieMockedTracingExtension.injectTrace(context, TRACER);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        TRACER.reset();
        NessieMockedTracingExtension.injectTrace(context, TRACER);
    }

    private static void injectTrace(ExtensionContext context, MockTracer tracer) {
        Class testClass = context.getRequiredTestClass();
        AnnotationUtils.findAnnotatedFields((Class)testClass, NessieDbTracer.class, f -> true).forEach(field -> {
            if (!Modifier.isStatic(field.getModifiers()) && !context.getTestInstance().isPresent()) {
                return;
            }
            if (!field.getType().isAssignableFrom(MockTracer.class)) {
                throw new ExtensionConfigurationException("@NessieDbTracer annotated fields must be of type " + MockTracer.class.getName());
            }
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(context.getTestInstance().orElse(null), tracer);
            }
            catch (IllegalAccessException e) {
                ExceptionUtils.throwAsUncheckedException((Throwable)e);
            }
        });
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(NessieDbTracer.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return extensionContext.getStore(NAMESPACE).get((Object)"tracer", MockTracer.class);
    }
}

