/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.projectnessie.versioned.persist.adapter.AdjustableDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionConfig;

public final class SystemPropertiesConfigurer {
    public static final String CONFIG_NAME_PREFIX = "nessie.store.";
    private static final Pattern TO_PROPERTY_NAME_PATTERN = Pattern.compile("([a-z])([A-Z]+)");

    private SystemPropertiesConfigurer() {
    }

    public static <T extends AdjustableDatabaseAdapterConfig> T configureAdapterFromSystemProperties(T config) {
        return SystemPropertiesConfigurer.configureAdapterFromProperties(config, System::getProperty);
    }

    public static <T extends DatabaseConnectionConfig> T configureConnectionFromSystemProperties(T config) {
        return SystemPropertiesConfigurer.configureConnectionFromProperties(config, System::getProperty);
    }

    public static <T extends AdjustableDatabaseAdapterConfig> T configureAdapterFromProperties(T config, Function<String, String> property) {
        return (T)((AdjustableDatabaseAdapterConfig)SystemPropertiesConfigurer.configureFromPropertiesGeneric(config, DatabaseAdapterConfig.class, property));
    }

    public static <T extends DatabaseConnectionConfig> T configureConnectionFromProperties(T config, Function<String, String> property) {
        return (T)SystemPropertiesConfigurer.configureFromPropertiesGeneric(config, DatabaseConnectionConfig.class, property);
    }

    public static <T> T configureFromPropertiesGeneric(T config, Class<? super T> configType, Function<String, String> property) {
        List l = Arrays.stream(config.getClass().getMethods()).filter(m -> m.getName().startsWith("with")).filter(m -> m.getName().length() >= 5).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> configType.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterTypes().length == 1).filter(m -> property.apply(SystemPropertiesConfigurer.toPropertyName(m)) != null).collect(Collectors.toList());
        try {
            for (Method m2 : l) {
                Class<?> type = m2.getParameterTypes()[0];
                String propertyName = SystemPropertiesConfigurer.toPropertyName(m2);
                String value = property.apply(propertyName);
                if (type == String.class) {
                    config = m2.invoke(config, value);
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    config = m2.invoke(config, Integer.parseInt(value));
                    continue;
                }
                if (type == Long.class || type == Long.TYPE) {
                    config = m2.invoke(config, Long.parseLong(value));
                    continue;
                }
                if (type == Float.class || type == Float.TYPE) {
                    config = m2.invoke(config, Float.valueOf(Float.parseFloat(value)));
                    continue;
                }
                if (type == Double.class || type == Double.TYPE) {
                    config = m2.invoke(config, Double.parseDouble(value));
                    continue;
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    config = m2.invoke(config, Boolean.parseBoolean(value));
                    continue;
                }
                throw new UnsupportedOperationException("No converter from String to " + type);
            }
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toPropertyName(Method m) {
        return SystemPropertiesConfigurer.toPropertyName(m.getName().substring(4));
    }

    private static String toPropertyName(String name) {
        return CONFIG_NAME_PREFIX + TO_PROPERTY_NAME_PATTERN.matcher(name).replaceAll("$1.$2").toLowerCase(Locale.ROOT);
    }
}

